/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlatt;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtes.business.tie.exexutor.att.OnEvaluateAttendanceEndEvent;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemInstanceExt;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.TimeBucketExt;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttendAttr;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.scheme.TiePhaseIdentity;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.executor.rlatt.AttExtHelper;
import kd.wtc.wtes.business.executor.rlatt.AttPlanEvalService;
import kd.wtc.wtes.business.executor.rlatt.AttendConfigEvalService;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.attconfig.AttCustomDuration;
import kd.wtc.wtes.business.model.attconfig.AttPlan;
import kd.wtc.wtes.business.model.attconfig.AttRule;
import kd.wtc.wtes.business.model.attconfig.AttRuleCal;
import kd.wtc.wtes.business.model.attconfig.AttendConfig;
import kd.wtc.wtes.business.model.attconfig.AttendConfigQuery;
import kd.wtc.wtes.business.model.attconfig.AttendConfigResp;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.service.impl.AccessServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.TieContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttEvaluator
implements TieEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(AttEvaluator.class);
    private AttPlan attPlan;
    private AttRule attRule;
    private AttRuleCal attRuleCal;
    private List<AttRuleCal> attRuleCalList;
    private LocalDate chainDate;
    private ShiftTableSingle shiftTableSingle = null;
    private AttItemSpecData attItemSpecData = null;
    private ShiftSpec chainDateShiftSpec = null;
    private AttendConfig attendConfig;
    private AttFileModel chainDateAttFileModel;
    private AttendConfigResp attendConfigResp;
    List<TimeBucketStd> actualFilterResult;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        try {
            this.initParams(context);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("AttEvaluator.evaluate.error");
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, ex.getMessage()));
        }
        LinkedList resultNodeList = Lists.newLinkedList();
        if (this.attendConfigResp.isIfAttendDay()) {
            AttItemValue shouldAttItemValueDay = this.evaluateShouldAttItemValue(this.attendConfigResp, this.attRule.getShouldAttendDay());
            resultNodeList.add(shouldAttItemValueDay);
            AttItemValue shouldAttItemValueHour = this.evaluateShouldAttItemValue(this.attendConfigResp, this.attRule.getShouldAttendHour());
            resultNodeList.add(shouldAttItemValueHour);
        }
        resultNodeList.addAll(this.evaluateOriginAttItemValue(context));
        List<AttItemValue> customDurationAttItemValueList = this.evaluateCustomDurationAttItemValues(context, resultNodeList, dataNodes);
        resultNodeList.addAll(customDurationAttItemValueList);
        LOG.debug("AttEvaluator.resultNodeList.size={}", (Object)resultNodeList.size());
        List<AttItemValue> customExtValues = this.evaluateCustomExt(context, resultNodeList);
        resultNodeList.addAll(customExtValues);
        List<AttItemValue> attItemValues = AttExtHelper.afterExecAttendance(context, resultNodeList, this.attRule, this.chainDateShiftSpec);
        resultNodeList.addAll(attItemValues);
        return TieDataResultStd.success(resultNodeList);
    }

    private void initParams(TieContextStd context) throws IllegalArgumentException {
        this.chainDate = context.getChainDate();
        this.attItemSpecData = ContextUtil.getAttItemSpecData(context);
        this.chainDateAttFileModel = ContextUtil.getAttFile(context, this.chainDate);
        this.shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        this.chainDateShiftSpec = this.shiftTableSingle.getShiftSpec(this.chainDate);
        DateAttribute periodChainDateAttr = this.shiftTableSingle.getDateAttribute(this.chainDate);
        DateType periodChainDateType = this.shiftTableSingle.getDateType(this.chainDate);
        if (this.chainDateShiftSpec == null || this.chainDateShiftSpec.getId() == 0L) {
            LOG.debug(String.format(Locale.ROOT, "not find matched shiftInfo in %s", WTCDateUtils.date2Str((Date)WTCDateUtils.toDate((LocalDate)this.chainDate), (String)"yyyy-MM-dd")));
            throw new IllegalArgumentException(String.format(Locale.ROOT, "not find matched shiftInfo in %s", WTCDateUtils.date2Str((Date)WTCDateUtils.toDate((LocalDate)this.chainDate), (String)"yyyy-MM-dd")));
        }
        boolean off = this.chainDateShiftSpec.isOff();
        if (periodChainDateType == null || periodChainDateType.getId() == 0L) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "not find matched dateType info in %s", WTCDateUtils.date2Str((Date)WTCDateUtils.toDate((LocalDate)this.chainDate), (String)"yyyy-MM-dd")));
        }
        this.attPlan = this.chainDateAttFileModel.getAttPlan(this.chainDate);
        if (this.attPlan == null) {
            LOG.warn("not find matched attendance plan");
            throw new IllegalArgumentException("not find matched attendance plan");
        }
        this.attRule = AttPlanEvalService.getInstance().getAttRuleByAttPlanAndDateInfo(this.attPlan, this.chainDate, context);
        if (this.attRule == null) {
            LOG.warn("not find matched attendance plan");
            throw new IllegalArgumentException("not find matched attendance rule");
        }
        this.attRuleCalList = AttPlanEvalService.getInstance().getAttRuleListCalByAttRuleAndDateInfo(this.attRule, periodChainDateType, off, periodChainDateAttr, this.chainDateAttFileModel, ContextUtil.getLimitScopeMap(context));
        if (this.attRuleCalList != null && !this.attRuleCalList.isEmpty()) {
            this.attRuleCal = this.attRuleCalList.get(0);
        }
        if (this.attRuleCal == null) {
            LOG.warn("not find matched attendance attRuleCal");
        }
        this.attendConfig = (AttendConfig)this.attRule.getAttendConfigTimeSeqBo().getVersionByDate(this.chainDate);
        AttendConfigEvalService attendConfigEvalService = (AttendConfigEvalService)WTCAppContextHelper.getBean(AttendConfigEvalService.class);
        this.attendConfigResp = attendConfigEvalService.getAttendInfo(this.getAttConfig());
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttEvaluator_initParams  this.attendConfigResp = {}", (Object)JSON.toJSONString((Object)this.attendConfigResp));
        }
        List<TieDataNodeStd> rawTimeBuckets = context.getRawTimeBuckets();
        BizDataSource actualAttDataSource = ContextUtil.getConfigMix(context).getDataSource(BizTypeEnum.ATT, PreDataAttendAttr.PD_1110_S);
        this.actualFilterResult = this.filterDataSource(actualAttDataSource, rawTimeBuckets).stream().map(TimeBucketStd.class::cast).collect(Collectors.toList());
    }

    private AttendConfigQuery getAttConfig() {
        AttendConfigQuery query = new AttendConfigQuery();
        query.setAttendConfig(this.attendConfig);
        query.setBoId(this.chainDateAttFileModel.getBid());
        query.setQueryDate(this.chainDate);
        query.setShiftTableSingle(this.shiftTableSingle);
        query.setAttRule(this.attRule);
        return query;
    }

    private List<AttItemValue> evaluateCustomDurationAttItemValues(TieContextStd context, List<AttItemValue> attItemValues, List<TieDataNodeStd> dataNodes) {
        LinkedList resultList = Lists.newLinkedList();
        if (this.attRuleCal == null || CollectionUtils.isEmpty(this.attRuleCal.getAttCustomDurations())) {
            return resultList;
        }
        Map<Long, AttItemValue> attItemValueMap = context.getAllHandleResultAttItemValueMap(dataNodes);
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)attItemValueMap.size());
        HashMap timeDataMap = Maps.newHashMapWithExpectedSize((int)attItemValueMap.size());
        attItemValueMap.forEach((key, value) -> {
            if (value.getAttItemInstance().getAttItemSpec().getDataType() == DataType.TIMES && value.getAttItemInstance().getItemValue() != null) {
                timeDataMap.put(value.getAttItemInstance().getAttItemSpec().getBid(), value.getAttItemInstance().getItemValue());
            } else {
                dataMap.put(value.getAttItemInstance().getAttItemSpec().getBid(), value.getAttItemInstance().getSecondDecimal());
            }
        });
        for (AttItemValue attItemValue : attItemValues) {
            dataMap.merge(attItemValue.getAttItemInstance().getAttItemSpec().getBid(), attItemValue.getAttItemInstance().getSecondDecimal(), BigDecimal::add);
        }
        List<TieDataNodeStd> allItemNodes = context.getAllDataNodes().stream().collect(Collectors.toList());
        ArrayList<TimeSeqBo<AttCustomDuration>> needDealCustomList = new ArrayList<TimeSeqBo<AttCustomDuration>>();
        if (this.attRule.isMultiAllow()) {
            for (AttRuleCal attRuleCalTemp : this.attRuleCalList) {
                needDealCustomList.addAll(attRuleCalTemp.getAttCustomDurations());
            }
        } else {
            needDealCustomList.addAll(this.attRuleCal.getAttCustomDurations());
        }
        HashSet<Long> existAttItemSet = new HashSet<Long>(needDealCustomList.size());
        for (TimeSeqBo timeSeqBo : needDealCustomList) {
            AttCustomDuration attCustomDuration = (AttCustomDuration)timeSeqBo.getVersionByDate(this.chainDate);
            if (attCustomDuration == null) continue;
            AttItemSpec attCustomAttItem = this.attItemSpecData.getByBidAndDate(attCustomDuration.getAttItemBid(), this.chainDate);
            if (attCustomAttItem == null) {
                LOG.warn("AttendConfigResp.evaluateCustomDurationAttItemValues attCustomAttItem should not be null,periodFirstDate = {},attITemBid={},attCustomDurationBId = {},attItemNumber ={}", new Object[]{this.chainDate, attCustomDuration.getAttItemBid(), attCustomDuration.getBid(), attCustomDuration.getAttItemNumber()});
                throw new IllegalArgumentException("attCustomAttItem should not be null");
            }
            if (existAttItemSet.contains(attCustomDuration.getAttItemBid())) continue;
            existAttItemSet.add(attCustomDuration.getAttItemBid());
            if (attCustomAttItem.getDataType() == DataType.TIMES) {
                BigDecimal times = attCustomDuration.getTimes(timeDataMap);
                AttItemInstance attCustomAttItemInstance = new AttItemInstance(attCustomAttItem, times);
                resultList.add(((AttItemValue.Builder)((TieDataNode.Builder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(attCustomDuration.filterAttItems(allItemNodes))).attItemInstance(attCustomAttItemInstance)).evaluationRule(EvaluationRuleModel.of(this.attRule.getId(), "wtp_attendrule"))).build());
                timeDataMap.merge(attCustomAttItemInstance.getAttItemSpec().getBid(), times, BigDecimal::add);
                continue;
            }
            BigDecimal seconds = attCustomDuration.getSeconds(dataMap);
            BigDecimal day = this.chainDateShiftSpec.secondsToDays(seconds);
            AttItemInstance attCustomAttItemInstance = new AttItemInstance(attCustomAttItem, day, seconds);
            resultList.add(((AttItemValue.Builder)((TieDataNode.Builder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(attCustomDuration.filterAttItems(allItemNodes))).attItemInstance(attCustomAttItemInstance)).evaluationRule(EvaluationRuleModel.of(this.attRule.getId(), "wtp_attendrule"))).build());
            dataMap.merge(attCustomAttItemInstance.getAttItemSpec().getBid(), seconds, BigDecimal::add);
        }
        LOG.debug("AttEvaluator.evaluateCustomDurationAttItemValues.result:{}", resultList.stream().map(value -> value.getAttItemInstance().getSecondDecimal()).collect(Collectors.toList()));
        return resultList;
    }

    private AttItemValue evaluateShouldAttItemValue(AttendConfigResp resp, long attItemId) {
        if (resp == null) {
            LOG.warn("AttEvaluator.evaluateShouldAttItemValue resp is null");
            return null;
        }
        BigDecimal dayVal = resp.getAttendDay();
        BigDecimal secondVal = resp.getAttendHour();
        if (dayVal == null || secondVal == null) {
            LOG.warn("dayVal == null || secondVal == null, should not be null");
            dayVal = BigDecimal.ZERO;
            secondVal = BigDecimal.ZERO;
        }
        AttItemSpec shouldAttItem = this.attItemSpecData.getByBidAndDate(attItemId, this.chainDate);
        AttItemInstance shouldAttItemInstance = new AttItemInstance(shouldAttItem, dayVal, secondVal);
        LOG.debug("AttEvaluator.evaluateShouldAttItemValue.dayVal:{},secondVal:{}", (Object)dayVal, (Object)secondVal);
        return (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(Lists.newLinkedList())).attItemInstance(shouldAttItemInstance)).build();
    }

    private List<AttItemValue> evaluateOriginAttItemValue(TieContextStd context) {
        List<TieDataNodeStd> rawTimeBuckets = context.getRawTimeBuckets();
        BizDataSource oriAttDataSource = ContextUtil.getConfigMix(context).getDataSource(BizTypeEnum.ATT, PreDataAttendAttr.PD_1020_S);
        BizDataSource actualAttDataSource = ContextUtil.getConfigMix(context).getDataSource(BizTypeEnum.ATT, PreDataAttendAttr.PD_1110_S);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
        AttItemValue attItemValue = this.filterSource(oriAttDataSource, rawTimeBuckets, PreDataAttItem.PD_AT_1020);
        AttItemValue acAttItemValue = this.filterSource(actualAttDataSource, rawTimeBuckets, PreDataAttItem.PD_AT_1040);
        if (attItemValue != null) {
            result.add(attItemValue);
        }
        if (acAttItemValue != null) {
            result.add(acAttItemValue);
        }
        return result;
    }

    private AttItemValue filterSource(BizDataSource attDataSource, List<TieDataNodeStd> rawTimeBuckets, long attItemId) {
        List<TieDataNodeStd> filterTimeBuckets = this.filterDataSource(attDataSource, rawTimeBuckets);
        if (CollectionUtils.isEmpty(filterTimeBuckets)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("AttEvaluator.filterSource filterTimeBuckets after filter is null");
            }
            return null;
        }
        BigDecimal seconds = filterTimeBuckets.stream().map(timeBucket -> timeBucket.getAttItemInstances().get(0).getSecondDecimal()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal day = this.chainDateShiftSpec.secondsToDays(seconds);
        AttItemSpec originAttItem = this.attItemSpecData.getByBidAndDate(attItemId, this.chainDate);
        LOG.debug("AttEvaluator.filterSource attItemId:{},originAttItem is null?:{}", (Object)attItemId, (Object)(originAttItem == null ? 1 : 0));
        AttItemInstance originAttItemInstance = new AttItemInstance(originAttItem, null, day, seconds, null);
        LOG.debug("AttEvaluator.filterSource.result:{}", (Object)seconds);
        return (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(filterTimeBuckets)).attItemInstance(originAttItemInstance)).build();
    }

    private List<TieDataNodeStd> filterDataSource(BizDataSource attDataSource, List<TieDataNodeStd> rawTimeBuckets) {
        List<TieDataNodeStd> filterTimeBuckets = rawTimeBuckets;
        if (attDataSource != null) {
            AccessServiceImpl accessService = (AccessServiceImpl)WTCAppContextHelper.getBean(AccessServiceImpl.class);
            filterTimeBuckets = accessService.accessFilterByCondition(rawTimeBuckets, attDataSource.getCondition()).stream().map(TimeBucketStd.class::cast).collect(Collectors.toList());
        }
        return filterTimeBuckets;
    }

    private List<AttItemValue> evaluateCustomExt(TieContextStd context, LinkedList<AttItemValue> resultNodeList) {
        ArrayList customExtItems = Lists.newArrayListWithCapacity((int)10);
        WTCPluginProxy pluginProxy = (WTCPluginProxy)ContextExtUtil.getExtPlugin(context, "kd.sdk.wtc.wtes.business.tie.exexutor.att.AttEvaluatorExpService");
        AtomicReference attItemSpecExtList = new AtomicReference(Collections.emptyList());
        pluginProxy.invokeReplace(attExpService -> {
            ArrayList actualFilterResultExt = Lists.newArrayListWithExpectedSize((int)this.actualFilterResult.size());
            for (TimeBucketStd timeBucketStd : this.actualFilterResult) {
                TimeBucketExt ext = ContextExtUtil.covertTimeBucketExt(timeBucketStd);
                actualFilterResultExt.add(ext);
            }
            List<TieDataNodeStd> allDataNodes = context.getAllDataNodes();
            TieStepIdentity tieStepIdentity = context.getTieStepIdentity();
            Map<Long, AttItemValue> allHandleResultAndAttItemValue = TieContextUtil.getAllHandleResultAndAttItemValue(allDataNodes, this.chainDateShiftSpec, resultNodeList, tieStepIdentity);
            Map<Long, AttItemInstanceExt> allHandleResultAttInstanceMap = ContextExtUtil.convertToAttItemInstanceMap(allHandleResultAndAttItemValue);
            Map<Long, AttItemValue> curPhaseHandleResultAndAttItemValue = TieContextUtil.getCurPhaseHandleResultAndAttItemValue(allDataNodes, this.chainDateShiftSpec, resultNodeList, tieStepIdentity);
            Map<Long, AttItemInstanceExt> curStageAttItemInstanceExtMap = ContextExtUtil.convertToAttItemInstanceMap(curPhaseHandleResultAndAttItemValue);
            TiePhaseIdentity phaseIdentity = tieStepIdentity.getPhaseIdentity();
            String tiePhaseRusult = phaseIdentity.getResult().getCode();
            OnEvaluateAttendanceEndEvent endEvent = new OnEvaluateAttendanceEndEvent(ContextExtUtil.getTieContextExt(context), (List)actualFilterResultExt, curStageAttItemInstanceExtMap, allHandleResultAttInstanceMap, tiePhaseRusult);
            attExpService.onEvaluateAttendanceEnd(endEvent);
            attItemSpecExtList.set(endEvent.getAttItemSpecExtList());
        });
        if (CollectionUtils.isNotEmpty((Collection)attItemSpecExtList.get())) {
            for (AttItemInstanceExt attItemInstanceExt : attItemSpecExtList.get()) {
                customExtItems.add(ContextExtUtil.covertAttItemValue(attItemInstanceExt));
            }
        }
        return customExtItems;
    }
}

