/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlatt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.attconfig.AttRule;
import kd.wtc.wtes.business.model.attconfig.AttendConfigQuery;
import kd.wtc.wtes.business.model.attconfig.AttendConfigResp;
import kd.wtc.wtes.common.constants.TimeConstants;

public class AttendConfigEvalService {
    private static final Log LOG = LogFactory.getLog(AttendConfigEvalService.class);
    private IDateRangeService dateRangeService = new DateRangeServiceImpl();

    public AttendConfigResp getAttendInfo(AttendConfigQuery query) {
        LOG.debug("AttendConfigQuery{boid={},queryDate={}}", (Object)query.getBoId(), (Object)query.getQueryDate());
        AttendConfigResp resp = new AttendConfigResp();
        resp.setBoId(query.getBoId());
        resp.setDate(query.getQueryDate());
        AccessDto condition = query.getAttendConfig().getAccessDto();
        ShiftTableSingle shiftTableSingle = query.getShiftTableSingle();
        Roster roster = shiftTableSingle.getRoster(query.getQueryDate());
        AttRule attRule = query.getAttRule();
        this.checkRoster(attRule, roster, condition, shiftTableSingle.getShiftSpec(query.getQueryDate()), resp);
        return resp;
    }

    private void checkRoster(AttRule attRule, Roster roster, AccessDto accessDto, ShiftSpec shiftSpec, AttendConfigResp resp) {
        if (roster != null) {
            LOG.debug("AttendConfigEvalService_checkRoster roster_date ={},roster_id ={}", (Object)roster.getRosterDate(), (Object)roster.getId());
            Boolean satisfyDateRange = this.dateRangeService.isSatisfyDateRange(roster.getDateType().getId(), roster.getDateAttribute().getCode(), Boolean.valueOf(roster.getShiftSpec().isOff()), accessDto);
            resp.setIfAttendDay(satisfyDateRange);
            if (shiftSpec.isOff() && shiftSpec.getOffNonPlan()) {
                resp.setAttendHour(BigDecimal.ZERO);
                resp.setAttendDay(BigDecimal.ZERO);
            } else {
                boolean containOverTime = attRule.isContainOverTime();
                Integer time = shiftSpec.getStandardTime();
                if (!containOverTime) {
                    time = time - shiftSpec.getOtTime();
                }
                BigDecimal days = BigDecimal.valueOf(time.intValue()).divide(shiftSpec.getShiftMiddleRule().getAlldayhour(), 10, RoundingMode.HALF_UP).divide(TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL, 10, RoundingMode.HALF_UP);
                resp.setAttendHour(BigDecimal.valueOf(time.intValue()));
                resp.setAttendDay(days);
            }
        } else {
            resp.setIfAttendDay(false);
        }
    }
}

