/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rldailyproxy;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.sdk.wtc.wtes.business.tie.exexutor.daily.ExecDailyEvaluatorEvent;
import kd.sdk.wtc.wtes.business.tie.exexutor.daily.TieAttDailyEvaluatorExtPlugin;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.ext.model.daily.ExecDailyEvaluatorEventImpl;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.TieContextUtil;

public class TieAttDailyEvaluatorExtProxy
implements TieEvaluatorStd {
    private final TieAttDailyEvaluatorExtPlugin tieAttDailyEvaluatorExtPlugin;

    public TieAttDailyEvaluatorExtProxy(TieAttDailyEvaluatorExtPlugin tieAttDailyEvaluatorExtPlugin) {
        this.tieAttDailyEvaluatorExtPlugin = tieAttDailyEvaluatorExtPlugin;
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        if (this.tieAttDailyEvaluatorExtPlugin == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, TieAttDailyEvaluatorExtProxy.getWarnMsg()));
        }
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(context.getChainDate());
        Map<Long, AttItemValue> curChainInstances = TieContextUtil.getAllHandleResultAndAttItemValue(context.getAllDataNodes(), shiftSpec, WTCCollections.modifiableEmptyList(), context.getTieStepIdentity());
        ExecDailyEvaluatorEventImpl evt = new ExecDailyEvaluatorEventImpl(context, curChainInstances);
        this.tieAttDailyEvaluatorExtPlugin.doEvaluate((ExecDailyEvaluatorEvent)evt);
        List tieDataNodeExtList = evt.getTieDataNodeExtList();
        List result = tieDataNodeExtList.stream().map(ContextExtUtil::covertAttItemValue).collect(Collectors.toList());
        return TieDataResultStd.success(result);
    }

    private static String getWarnMsg() {
        return ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8003\u52e4\u6838\u7b97\u81ea\u5b9a\u4e49\u6838\u7b97\u6b65\u9aa4\u63a5\u53e3\u3002", (String)"TieAttDailyEvaluatorExtProxy_01", (String)"wtc-wtes-business", (Object[])new Object[0]);
    }
}

