/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlex;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtes.business.tie.exexutor.ex.ExEvaluatorEvent;
import kd.sdk.wtc.wtes.business.tie.model.attitem.AttItemInstanceExt;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.personfilter.utils.JudgeResult;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.predata.wtbd.PreDataExAttribute;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.rlex.ExCalHelper;
import kd.wtc.wtes.business.executor.rlex.ExConstant;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.init.LogicCardData;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ExAttPackage;
import kd.wtc.wtes.business.model.LogicCard;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.rlex.ExConfig;
import kd.wtc.wtes.business.model.rlex.ExConfigEntry;
import kd.wtc.wtes.business.model.rlexenum.DurationUnitEnum;
import kd.wtc.wtes.business.model.rlexenum.ExDealMethodEnum;
import kd.wtc.wtes.business.model.rlexenum.ExDealTypeEnum;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.business.model.util.ParserUtil;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.AttItemValueStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.RoundRuleService;
import kd.wtc.wtes.common.enums.ShiftType;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.Label;
import kd.wtc.wtes.common.util.LabelSet;

public class ExRoundEvaluator
implements TieEvaluatorStd {
    private LocalDate chainDate = null;
    private AttFileModel attFileModel = null;
    private ExAttPackage exAttPackage = null;
    private ShiftSpec shiftSpec = null;
    private static final Log log = LogFactory.getLog(ExRoundEvaluator.class);
    private TieContextStd tieContext;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        TieDataResultStd dataResult = this.beforeEvaluator(context);
        return this.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    private List<AttItemValue> buryPoint(TieContextStd context) {
        ArrayList res = Lists.newArrayList();
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        LocalDate chainDate = context.getChainDate();
        ExAttPackage exAttPackage = attFileModel.getAttExPackage(chainDate);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        if (ShiftType.PARFLEXSHIFT == shiftSpec.getShiftType()) {
            AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
            List<AttBillTimeBucket> attBillTimeBuckets = attBillTimeBucketData.getBillTimeBuckets(attFileModel.getAttPersonId(), chainDate);
            attBillTimeBuckets = attBillTimeBuckets.stream().filter(bill -> "BT".equals(bill.getBillTypeBig()) || "VA".equals(bill.getBillTypeBig())).collect(Collectors.toList());
            LogicCardData logicCardData = ContextUtil.getLogicCardData(context);
            List<LogicCard> logicCards = logicCardData.getByAttPersonIdAndDate(attFileModel.getAttPersonId(), chainDate);
            List outWorkCollect = shiftSpec.getShiftSessions().stream().filter(item -> item.getOutWorkType() == OutWorkType.BREAK).collect(Collectors.toList());
            List shiftSessionExts = outWorkCollect.stream().map(coll -> ContextExtUtil.covertShiftSessionExt(coll)).collect(Collectors.toList());
            List attBillTimeBucketExts = attBillTimeBuckets.stream().map(bill -> ContextExtUtil.covertBillTimeBucketExt(bill)).collect(Collectors.toList());
            List LogicCardExts = logicCards.stream().map(card -> ContextExtUtil.covertLogicCardExt(card)).collect(Collectors.toList());
            WTCPluginProxy pluginProxy = (WTCPluginProxy)ContextExtUtil.getExtPlugin(context, "kd.sdk.wtc.wtes.business.tie.exexutor.ex.ExEvaluatorExpService");
            ExEvaluatorEvent event = new ExEvaluatorEvent(ContextExtUtil.getTieContextExt(context), shiftSessionExts, attBillTimeBucketExts, LogicCardExts);
            pluginProxy.invokeReplace(exEvaluatorExpService -> exEvaluatorExpService.extraTimeBucket(event));
            if (Objects.isNull(event) || Objects.isNull(event.getAttItemSpecExtList())) {
                if (log.isDebugEnabled()) {
                    log.debug("buryPoint.ExSimpleTimeBuckets is null");
                }
                return res;
            }
            if (log.isDebugEnabled()) {
                log.debug("buryPoint.ExSimpleTimeBuckets:{}", (Object)event.getAttItemSpecExtList());
            }
            for (AttItemInstanceExt itemInstanceExt : event.getAttItemSpecExtList()) {
                AttItemValue attItemValue = ContextExtUtil.covertAttItemValue(itemInstanceExt);
                for (AttItemInstance newItemInstance : attItemValue.getAttItemInstances()) {
                    newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_attr", (String)PreDataExAttribute.PD_1020_S.toString()));
                    Long exProcess = exAttPackage.isRuleEngine() ? (Long)context.getVariable(ExCalHelper.getVariableKey(context, "wtp_exprocess"), VScope.CHAIN) : exAttPackage.getExProcess();
                    String exProcessStr = null == exProcess ? "" : exProcess.toString();
                    newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"exProcess", (String)exProcessStr));
                    newItemInstance.getExtraLabels().add((ILabel)Label.of((String)"ex_origAttItem", (String)JSONObject.toJSONString(Collections.singletonList(PreDataAttItem.PD_EX_1080_S))));
                }
                res.add(attItemValue);
            }
        }
        return res;
    }

    private TieDataResultStd beforeEvaluator(TieContextStd context) {
        List dataNodeStd = context.getDataNodesOfPrevStepExecutor();
        if (CollectionUtils.isEmpty(dataNodeStd)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u7b97\u8f93\u51fa\u5f02\u5e38\u7684\u539f\u59cb\u9879\u76ee\uff0c\u4e0d\u505a\u5f02\u5e38\u7ed3\u679c\u8ba1\u7b97\u3002", (String)"ExRoundEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        this.tieContext = context;
        this.chainDate = context.getChainDate();
        this.attFileModel = ContextUtil.getCurrentAttFile(context);
        this.exAttPackage = this.attFileModel.getAttExPackage(this.chainDate);
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        this.shiftSpec = shiftTableSingle.getShiftSpec(this.chainDate);
        return null;
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        List dataNodeStd = context.getDataNodesOfPrevStepExecutor();
        List<AttItemValue> res = this.buryPoint(context);
        if (CollectionUtils.isNotEmpty(dataNodeStd)) {
            List<AttItemValueStd> itemValue = dataNodes.stream().filter(AttItemValueStd.class::isInstance).map(AttItemValueStd.class::cast).collect(Collectors.toList());
            res.addAll(this.resCal(itemValue, context));
        }
        res.forEach(item -> item.getAttItemInstances().forEach(attItem -> attItem.getExtraLabels().add((ILabel)Label.of((String)"exFilterType", (String)"exGeneral"))));
        return TieDataResultStd.success(res);
    }

    private List<AttItemValue> resCal(List<AttItemValueStd> timeBuckets, TieContextStd context) {
        this.tieContext = context;
        LocalDate chainDate = context.getChainDate();
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        ExAttPackage exAttPackage = attFileModel.getAttExPackage(chainDate);
        Long diffAttItemId = exAttPackage.getAttItem();
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        ArrayList res = Lists.newArrayListWithExpectedSize((int)timeBuckets.size());
        log.debug("ExRoundEvaluator_chainDate_{}_timeBuckets_{}", (Object)chainDate, (Object)timeBuckets.size());
        for (AttItemValueStd attItemValue : timeBuckets) {
            List<ExConfigEntry> configEntries = this.getExConfigByPunchCard(attItemValue, context);
            log.debug("ExRoundEvaluator_configEntries_{}", (Object)configEntries.size());
            ArrayList entryRes = Lists.newArrayListWithExpectedSize((int)configEntries.size());
            for (ExConfigEntry configEntry : configEntries) {
                ExDealTypeEnum deal = configEntry.getDealType();
                if (ExDealTypeEnum.DEAL_TYPE_B == deal) {
                    this.ladderProcess(configEntry, attItemValue, entryRes, chainDate, attItemSpecData, shiftSpec, diffAttItemId);
                    continue;
                }
                if (ExDealTypeEnum.DEAL_TYPE_A == deal) {
                    this.noLadderProcess(configEntry, attItemValue, entryRes, chainDate, attItemSpecData, shiftSpec, diffAttItemId);
                    continue;
                }
                ExConfig config = (ExConfig)attItemValue.getMatchedRule();
                throw new WtesBizException(new ErrorCode("002", MessageFormat.format(ResManager.loadKDString((String)"\u7f16\u7801:{0}\u7684\u5f02\u5e38\u914d\u7f6e\u7684\u5f02\u5e38\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38\u3002", (String)"ExRoundEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]), config.getNumber())), new Object[0]);
            }
            if (CollectionUtils.isEmpty((Collection)entryRes)) {
                log.debug("ExRoundEvaluator_not_matchCard_{}", (Object)chainDate);
                entryRes.add(ExCalHelper.changeToAttItemValue(attItemValue));
            }
            res.addAll(entryRes);
        }
        return res;
    }

    private List<ExConfigEntry> getExConfigByPunchCard(AttItemValueStd attItemValue, TieContextStd context) {
        ExConfig config = (ExConfig)attItemValue.getMatchedRule();
        if (config.isAllPunchCard()) {
            return config.getEntryList();
        }
        LabelSet<ILabel> extraLabels = attItemValue.getAttItemInstance().getExtraLabels();
        String punchCard = extraLabels.getValue("ex_punchCard");
        return config.getEntryList().stream().filter(entry -> entry.getPunchCard().toString().equals(punchCard)).collect(Collectors.toList());
    }

    private void noLadderProcess(ExConfigEntry configEntry, AttItemValueStd attItemValue, List<AttItemValue> res, LocalDate chainDate, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, Long diffAttItemId) {
        if (!this.checkBack(configEntry, attItemValue)) {
            log.debug("ExRoundEvaluator_checkBack_\u4e0d\u6ee1\u8db3");
            return;
        }
        BigDecimal seconds = attItemValue.getAttItemInstance().getSecondDecimal();
        if (this.judgeValue(seconds, configEntry, chainDate)) {
            BigDecimal day = attItemValue.getAttItemInstance().getDay();
            Long roundRuleId = configEntry.getRoundRule();
            if (null == roundRuleId || roundRuleId == 0L) {
                this.exportRes(configEntry, attItemValue, res, chainDate, attItemSpecData, seconds, day);
                return;
            }
            Map<Long, RoundWrapper> roundWrapperMap = ContextUtil.getRoundWrapperMap(this.tieContext);
            RoundWrapper roundWrapper = roundWrapperMap.get(roundRuleId);
            List<Long> resultAttItems = configEntry.getResultAttItems();
            for (Long attItemId : resultAttItems) {
                AttItemSpec attitemSpec = attItemSpecData.getByBidAndDate(attItemId, chainDate);
                BigDecimal roundSeconds = RoundRuleService.roundValue(roundWrapper, seconds, attitemSpec, ContextUtil.getShiftSpec(this.tieContext));
                day = shiftSpec.secondsToDays(roundSeconds);
                this.exportRes(configEntry, attitemSpec, attItemValue, res, roundSeconds, day);
                if (null == diffAttItemId || 0L == diffAttItemId || seconds.compareTo(roundSeconds) == 0) continue;
                AttItemSpec diffAttItem = attItemSpecData.getByBidAndDate(diffAttItemId, chainDate);
                this.exportDiffAttItem(configEntry, attItemValue, res, diffAttItem, seconds, roundSeconds, shiftSpec);
            }
        }
    }

    private boolean judgeValue(BigDecimal seconds, ExConfigEntry configEntry, LocalDate chainDate) {
        if (">".equals(configEntry.getAre())) {
            return seconds.compareTo(configEntry.getCulValueSecond()) > 0;
        }
        if (">=".equals(configEntry.getAre())) {
            return seconds.compareTo(configEntry.getCulValueSecond()) >= 0;
        }
        throw new WtesBizException(new ErrorCode("003", MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5:{0}\u7684\u5f02\u5e38\u914d\u7f6e\u7684\u5f02\u5e38\u5904\u7406\u6761\u4ef6\u5173\u7cfb\u914d\u7f6e\u5f02\u5e38\u3002", (String)"ExRoundEvaluator_5", (String)"wtc-wtes-business", (Object[])new Object[0]), chainDate)), new Object[0]);
    }

    private void exportResRoundRule(ExConfigEntry configEntry, AttItemValueStd attItemValue, List<AttItemValue> res, LocalDate chainDate, AttItemSpecData attItemSpecData) {
        BigDecimal seconds = attItemValue.getAttItemInstance().getSecondDecimal();
        BigDecimal resValue = BigDecimal.ZERO;
        BigDecimal day = attItemValue.getAttItemInstance().getDay();
        List<Long> resultAttItems = configEntry.getResultAttItems();
        Map<Long, RoundWrapper> roundWrapperMap = ContextUtil.getRoundWrapperMap(this.tieContext);
        for (Long attItemId : resultAttItems) {
            AttItemSpec attitemSpec = attItemSpecData.getByBidAndDate(attItemId, chainDate);
            if (configEntry.getRoundRule() != null) {
                RoundWrapper roundWrapper = roundWrapperMap.get(configEntry.getRoundRule());
                resValue = roundWrapper == null ? seconds : RoundRuleService.roundValue(roundWrapper, seconds, attitemSpec, ContextUtil.getShiftSpec(this.tieContext));
                day = this.shiftSpec.secondsToDays(resValue);
            }
            AttItemInstance itemInstance = new AttItemInstance(attitemSpec, null, day, resValue, null);
            itemInstance.getExtraLabels().addAll(attItemValue.getAttItemInstance().getExtraLabels());
            AttItemValue newAttItemValue = ExCalHelper.getAttItemValue(attItemValue, configEntry, itemInstance);
            res.add(newAttItemValue);
        }
    }

    private void exportRes(ExConfigEntry configEntry, AttItemValueStd attItemValue, List<AttItemValue> res, LocalDate chainDate, AttItemSpecData attItemSpecData, BigDecimal seconds, BigDecimal day) {
        List<Long> resultAttItems = configEntry.getResultAttItems();
        for (Long attItemId : resultAttItems) {
            AttItemSpec attitemSpec = attItemSpecData.getByBidAndDate(attItemId, chainDate);
            AttItemInstance itemInstance = new AttItemInstance(attitemSpec, null, day, seconds, null);
            itemInstance.getExtraLabels().addAll(attItemValue.getAttItemInstance().getExtraLabels());
            AttItemValue newAttItemValue = ExCalHelper.getAttItemValue(attItemValue, configEntry, itemInstance);
            res.add(newAttItemValue);
        }
    }

    private void exportRes(ExConfigEntry configEntry, AttItemSpec attitemSpec, AttItemValueStd attItemValue, List<AttItemValue> res, BigDecimal seconds, BigDecimal day) {
        AttItemInstance itemInstance = new AttItemInstance(attitemSpec, null, day, seconds, null);
        itemInstance.getExtraLabels().addAll(attItemValue.getAttItemInstance().getExtraLabels());
        AttItemValue newAttItemValue = ExCalHelper.getAttItemValue(attItemValue, configEntry, itemInstance);
        res.add(newAttItemValue);
    }

    private void exportDiffAttItem(ExConfigEntry configEntry, AttItemValueStd attItemValue, List<AttItemValue> res, AttItemSpec attItemSpec, BigDecimal seconds, BigDecimal roundSeconds, ShiftSpec shiftSpec) {
        BigDecimal diffSeconds = seconds.subtract(roundSeconds);
        BigDecimal day = shiftSpec.secondsToDays(diffSeconds.abs());
        if (diffSeconds.compareTo(BigDecimal.ZERO) < 0) {
            day = day.multiply(new BigDecimal("-1"));
        }
        AttItemInstance diffItem = new AttItemInstance(attItemSpec, null, day, diffSeconds, null);
        diffItem.getExtraLabels().add((ILabel)Label.of((String)"ex_no_export", (String)Boolean.TRUE.toString()));
        AttItemValue resAttItemValue = ExCalHelper.getAttItemValue(attItemValue, configEntry, diffItem);
        res.add(resAttItemValue);
    }

    private void ladderProcess(ExConfigEntry configEntry, AttItemValueStd attItemValue, List<AttItemValue> res, LocalDate chainDate, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, Long diffAttItemId) {
        if (!this.checkBack(configEntry, attItemValue)) {
            log.debug("ExRoundEvaluator_checkBack_\u4e0d\u6ee1\u8db3");
            return;
        }
        BigDecimal seconds = attItemValue.getAttItemInstance().getSecondDecimal();
        if (!this.ruleCheck(configEntry, seconds).booleanValue()) {
            log.debug("ExRoundEvaluator_ruleCheck_\u4e0d\u6ee1\u8db3");
            return;
        }
        if (ExDealMethodEnum.DEAL_TYPE_A == ExDealMethodEnum.getByCode(configEntry.getDealMethod())) {
            this.exportResRoundRule(configEntry, attItemValue, res, chainDate, attItemSpecData);
        } else if (ExDealMethodEnum.DEAL_TYPE_B == ExDealMethodEnum.getByCode(configEntry.getDealMethod())) {
            BigDecimal day;
            BigDecimal appointSeconds;
            if (DurationUnitEnum.UNIT_DAY == configEntry.getAppointUnit()) {
                appointSeconds = shiftSpec.daysToSecondDecimal(configEntry.getTimeValue());
                day = configEntry.getTimeValue();
            } else {
                appointSeconds = DurationUnitEnum.changeValueToSecond(configEntry.getAppointUnit().getCode(), configEntry.getTimeValue());
                day = shiftSpec.secondsToDays(appointSeconds);
            }
            this.exportRes(configEntry, attItemValue, res, chainDate, attItemSpecData, appointSeconds, day);
            if (seconds != appointSeconds) {
                AttItemSpec attitemSpec = attItemSpecData.getByBidAndDate(diffAttItemId, chainDate);
                this.exportDiffAttItem(configEntry, attItemValue, res, attitemSpec, seconds, appointSeconds, shiftSpec);
            }
        } else {
            throw new WtesBizException(new ErrorCode("002", ResManager.loadKDString((String)"\u5f02\u5e38\u9636\u68af\u5f0f\u65f6\u957f\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u4e0d\u5408\u683c\u3002", (String)"ExRoundEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    private Boolean ruleCheck(ExConfigEntry entry, BigDecimal seconds) {
        StringBuilder sub = new StringBuilder();
        sub.append(seconds).append(' ').append(entry.getAre()).append(' ').append(entry.getCulValueSecond()).append(' ').append(entry.getLogic()).append(' ').append(seconds).append(' ').append(entry.getBre()).append(' ').append(entry.getMaxValueSecond()).append(' ');
        try {
            if (log.isDebugEnabled()) {
                log.debug("ExRoundEvaluator_\u89c4\u5219\u5224\u65ad_{}", (Object)sub.toString());
            }
            return new ParserUtil().calculate(sub.toString(), null);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("EX_001", ResManager.loadKDString((String)"\u5f02\u5e38\u8ba1\u7b97\u89c4\u5219\u89e3\u6790\u5f02\u5e38\u3002", (String)"ExRoundEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[]{e});
        }
    }

    private boolean checkBack(ExConfigEntry configEntry, AttItemValueStd attItemValue) {
        RuleConditionInfo backSetCondition = configEntry.getBackSetCondition();
        if (backSetCondition == null) {
            return true;
        }
        LinkedHashMap dataMap = Maps.newLinkedHashMap();
        Optional<TimeBucketStd> timeBucketStd = attItemValue.parentDataNodes().stream().filter(TimeBucketStd.class::isInstance).map(TimeBucketStd.class::cast).findFirst();
        if (!timeBucketStd.isPresent()) {
            throw new KDBizException(new ErrorCode("EX_003", ResManager.loadKDString((String)"\u5f02\u5e38\u8f6c\u6362\u8ba1\u7b97\u65f6{0}\u3001\u4f11\u5047\u6807\u8bc6\u83b7\u53d6\u5f02\u5e38\u3002", (String)"ExRoundEvaluator_4", (String)"wtc-wtes-business", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()})), new Object[]{attItemValue});
        }
        HashMap param = Maps.newHashMapWithExpectedSize((int)ExConstant.NUMBER_2);
        param.put("businesstravel", timeBucketStd.get().getTravelBillState());
        param.put("vacation", timeBucketStd.get().getAbsenceBillState());
        dataMap.put(ID.genLongId(), param);
        JudgeResult judge = JudgeConditionService.judge((LinkedHashMap)dataMap, (RuleConditionInfo)backSetCondition);
        log.debug("ExRoundEvaluator_\u573a\u666f\u8bbe\u7f6e\u4f11\u5047\u548c\u51fa\u5dee,\u5339\u914d\u7ed3\u679c {}", (Object)judge);
        return judge.isMatched();
    }
}

