/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlid;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.RawTimeBucket;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailSingle;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailTable;
import kd.wtc.wtes.business.model.rlid.IncrDecrConf;
import kd.wtc.wtes.business.model.rlid.IncrDecrConfEntry;
import kd.wtc.wtes.business.model.rlid.IncrDecrPlan;
import kd.wtc.wtes.business.model.rlid.IncrDecrRule;
import kd.wtc.wtes.business.model.util.ParserUtil;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.business.service.IAccessService;
import kd.wtc.wtes.business.service.impl.AccessServiceImpl;
import kd.wtc.wtes.business.service.impl.DateRangeServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.ITieDataNodeExt;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.constants.TimeConstants;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.Label;

public class IncrDecrEvaluator
implements TieEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(IncrDecrEvaluator.class);
    private List<TieDataNode> tieAllDataNodeList;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        AttRecordDetailTable recordDetailTable;
        AttSubject.AttSubjectEntry attSub;
        List list;
        IncrDecrRule rule;
        List<TieDataNode> tieDataNodeList = null;
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        IncrDecrPlan incrDecrPlan = attFileModel.getIncrDecrPlan(chainDate);
        if (incrDecrPlan == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format("There is no IncrDecrPlan exists for attPersonId=%s, chainDate=%s", attPersonId, chainDate)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("IncrDecrEvaluator calculate begin,chainDate[{}],incrdecrPlan:{}", (Object)chainDate, (Object)incrDecrPlan.getId());
        }
        if (null == (rule = this.getIncrDecrRule(chainDate, context, incrDecrPlan))) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format("There is no IncrDecrRule exists for attPersonId=%s, chainDate=%s", attPersonId, chainDate)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("IncrDecrEvaluator calculate begin,incrdecrRule:{}", (Object)rule.getId());
        }
        List<TieDataNodeStd> rawTimeBuckets = context.getRawTimeBuckets();
        List<IncrDecrConf> configList = this.getMatchConfigByIncrDecrRule(rule, chainDate);
        this.tieAllDataNodeList = new LinkedList<TieDataNode>();
        for (IncrDecrConf incrDecrConf : configList) {
            if (HRStringUtils.equals((String)"2", (String)incrDecrConf.getSuitType())) continue;
            this.getTieDataNodeListFromConf(incrDecrConf, tieDataNodeList, context, rawTimeBuckets);
        }
        List zerIncrDecrList = this.tieAllDataNodeList.stream().filter(tieDataNode -> tieDataNode.getLabelSet().containsKey("labelIncrDecrRecord")).filter(tieDataNode -> tieDataNode.getLabelSet().containsKey("labelIncrDecrReturnZero")).map(ITieDataNodeExt::getAttItemInstances).flatMap(Collection::stream).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(zerIncrDecrList)) {
            for (AttItemInstance instance : zerIncrDecrList) {
                this.updateCurrContinueItemValue(context, instance);
            }
        }
        if (WTCCollections.isNotEmpty(list = this.tieAllDataNodeList.stream().filter(tieDataNode -> tieDataNode.getLabelSet().containsKey("labelIncrDecrRecord")).filter(tieDataNode -> !tieDataNode.getLabelSet().containsKey("labelIncrDecrReturnZero")).map(ITieDataNodeExt::getAttItemInstances).flatMap(Collection::stream).collect(Collectors.toList()))) {
            context.setVariable("INCR_DECR_ATT_ITEMS", list, VScope.CHAIN);
        }
        List resultDataList = this.tieAllDataNodeList.stream().filter(tieDataNode -> tieDataNode.getLabelSet().containsKey("labelRecord")).collect(Collectors.toList());
        Map map = (Map)context.getVariable("INCR_DECR_ATT_ITEMS", VScope.LINE);
        if (WTCCollections.isNotEmpty((Map)map)) {
            map.remove(chainDate.minusDays(1L));
        }
        if ((attSub = context.getAttSubjectEntry()).getCurrentDate().equals(attSub.getStartDate()) && null != (recordDetailTable = context.getInitParamMust("ATT_RECORD_DETAIL", AttRecordDetailTable.class))) {
            recordDetailTable.removeByPersonId(context.getAttPersonId());
        }
        return TieDataResultStd.success(resultDataList);
    }

    protected void getTieDataNodeListBySerialLimit(IncrDecrConf conf, List<TieDataNode> tieDataNodeList, TieContextStd context, IncrDecrConfEntry entry) {
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        LocalDate chainDate = context.getChainDate();
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        String triggerMode = conf.getTriggerMode();
        if (!"A".equals(triggerMode)) {
            return;
        }
        String serialLimit = entry.getSerialLimit();
        if (HRStringUtils.equalsIgnoreCase((String)"true", (String)serialLimit)) {
            this.continueAttItemValue(tieDataNodeList, context, conf, entry, attItemSpecData, shiftSpec, chainDate);
        }
    }

    protected void getTieDataNodeListFromConf(IncrDecrConf conf, List<TieDataNode> tieDataNodeList, TieContextStd context, List<TieDataNodeStd> rawTimeBuckets) {
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        LocalDate chainDate = context.getChainDate();
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        String triggerMode = conf.getTriggerMode();
        for (IncrDecrConfEntry entry : conf.getEntry()) {
            if ("B".equals(triggerMode)) {
                this.getTieDataNodeListByFixTime(context, rawTimeBuckets, entry, conf, attItemSpecData, shiftSpec, tieDataNodeList);
                continue;
            }
            if ("A".equals(triggerMode)) {
                this.getTieDataNodeListByAttProject(context, rawTimeBuckets, entry, conf, attItemSpecData, shiftSpec, tieDataNodeList);
                continue;
            }
            if ("C".equals(triggerMode)) {
                this.getTieDataNodeListByNoLimit(context, rawTimeBuckets, entry, conf, attItemSpecData, shiftSpec, tieDataNodeList);
                continue;
            }
            throw new WtesBizException(new ErrorCode("002", ResManager.loadKDString((String)"\u589e\u51cf\u89e6\u53d1\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38\u3002", (String)"IncrDecrEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    protected void getTieDataNodeListByNoLimit(TieContextStd context, List<TieDataNodeStd> rawTimeBuckets, IncrDecrConfEntry entry, IncrDecrConf conf, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, List<TieDataNode> tieDataNodeList) {
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        LocalDate chainDate = context.getChainDate();
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        boolean matchDateRange = dateRangeService.filterDataNodesWithoutTimeArr(WTCDateRangeSource.IDP, context, conf.getDateConditionAccessDto(), shiftTableSingle, chainDate);
        if (CollectionUtils.isEmpty(rawTimeBuckets) && !matchDateRange) {
            LOG.debug("IncrDecrEvaluator calculate NoLimit type,not found rawTimeBuckets");
            return;
        }
        List<TimeBucketStd> timeBucketStds = RawTimeBucket.cast(rawTimeBuckets);
        List<Object> collect = timeBucketStds.stream().map(TimeBucketStd::unwrapAndCopy).collect(Collectors.toList());
        if (HRStringUtils.isNotEmpty((String)conf.getCondition())) {
            collect = dateRangeService.filterDataNodes(WTCDateRangeSource.IDP, context, RawTimeBucket.cast(rawTimeBuckets), conf.getDateConditionAccessDto());
        }
        if (CollectionUtils.isEmpty(collect) && !matchDateRange) {
            LOG.debug("IncrDecrEvaluator calculate NoLimit type,after Condition not found TimeBuckets");
            return;
        }
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(entry.getCurAttItemId(), chainDate);
        String incdecRelation = entry.getIndecrRel();
        BigDecimal amount = entry.getIndecrValue();
        if (StringUtils.equals((CharSequence)incdecRelation, (CharSequence)"B")) {
            amount = BigDecimal.ZERO.subtract(amount);
        }
        AttItemInstance attItemInstance = null;
        DataType dataType = attItemSpec.getDataType();
        if (DataType.TIMES == dataType) {
            attItemInstance = new AttItemInstance(attItemSpec, amount);
        } else if (DataType.DURATION == dataType) {
            BigDecimal secondsAmount = this.getSecond(attItemSpec.getUnit(), amount, shiftSpec);
            BigDecimal dayAmount = shiftSpec.secondsToDays(secondsAmount);
            attItemInstance = new AttItemInstance(attItemSpec, dayAmount, secondsAmount);
        }
        this.cacheAttItemInstanceMap(attItemInstance, context, false, amount, tieDataNodeList, attItemSpec, shiftSpec);
        this.tieAllDataNodeList.add((TieDataNode)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).evaluationRule(EvaluationRuleModel.of(conf.getId(), "wtp_incdecconf"))).parentDataNodes(Collections.emptyList())).addLabel((ILabel)Label.of((String)"labelRecord"))).matchedRule((IEntity)conf)).build());
    }

    protected void getTieDataNodeListByAttProject(TieContextStd context, List<TieDataNodeStd> rawTimeBuckets, IncrDecrConfEntry entry, IncrDecrConf conf, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, List<TieDataNode> tieDataNodeList) {
        boolean isSerialLimit = HRStringUtils.equalsIgnoreCase((String)"true", (String)entry.getSerialLimit());
        if (CollectionUtils.isEmpty(rawTimeBuckets)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IncrDecrEvaluator calculate AttProject type,not found rawTimeBuckets");
            }
            if (isSerialLimit) {
                this.getTieDataNodeListBySerialLimit(conf, tieDataNodeList, context, entry);
            }
            return;
        }
        LocalDate chainDate = context.getChainDate();
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        List<TimeBucketStd> timeBucketStds = RawTimeBucket.cast(rawTimeBuckets);
        List<Object> collect = timeBucketStds.stream().map(TimeBucketStd::unwrapAndCopy).collect(Collectors.toList());
        if (HRStringUtils.isNotEmpty((String)conf.getCondition())) {
            collect = dateRangeService.filterDataNodes(WTCDateRangeSource.IDP, context, RawTimeBucket.cast(rawTimeBuckets), conf.getDateConditionAccessDto());
        }
        if (CollectionUtils.isEmpty(collect)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IncrDecrEvaluator calculate AttProject type,after condition not found TimeBuckets");
            }
            if (isSerialLimit) {
                this.getTieDataNodeListBySerialLimit(conf, tieDataNodeList, context, entry);
            }
            return;
        }
        if (this.parseExpress(context, chainDate, entry, shiftSpec)) {
            if (isSerialLimit) {
                this.newAttItemValue(tieDataNodeList, context, conf, entry, attItemSpecData, shiftSpec, chainDate);
                this.continueTriggerAttItem(context, conf, entry, attItemSpecData, shiftSpec);
            } else {
                this.newAttItemValueList(tieDataNodeList, context, conf, entry, attItemSpecData, shiftSpec, chainDate);
            }
        } else if (isSerialLimit) {
            this.getTieDataNodeListBySerialLimitNotMatch(conf, tieDataNodeList, context, entry);
        }
    }

    protected void getTieDataNodeListBySerialLimitNotMatch(IncrDecrConf conf, List<TieDataNode> tieDataNodeList, TieContextStd context, IncrDecrConfEntry entry) {
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        LocalDate chainDate = context.getChainDate();
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        boolean isSameDateType = this.isSameDateType(shiftTableSingle.getDateAttribute(chainDate).getCode(), entry.getDayType()) || HRStringUtils.equals((String)"D", (String)entry.getDayType());
        boolean isSameShiftType = this.isSameShiftType(shiftSpec, entry);
        if (isSameDateType && isSameShiftType) {
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(entry.getCurAttItemId(), chainDate);
            AttItemInstance attItemInstance = null;
            DataType dataType = attItemSpec.getDataType();
            if (DataType.TIMES == dataType) {
                attItemInstance = new AttItemInstance(attItemSpec, BigDecimal.ZERO);
            } else if (DataType.DURATION == dataType) {
                attItemInstance = new AttItemInstance(attItemSpec, BigDecimal.ZERO, BigDecimal.ZERO);
            }
            this.removeBeforeSameContinueAttItem(tieDataNodeList, attItemInstance, context);
            this.cacheAttItemInstanceMap(attItemInstance, context, false, BigDecimal.ZERO, tieDataNodeList, attItemSpec, shiftSpec);
            this.tieAllDataNodeList.add((TieDataNode)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).evaluationRule(EvaluationRuleModel.of(conf.getId(), "wtp_incdecconf"))).parentDataNodes(Collections.emptyList())).addLabel((ILabel)Label.of((String)"labelIncrDecrRecord"))).matchedRule((IEntity)conf)).build());
        } else {
            this.continueAttItemValue(tieDataNodeList, context, conf, entry, attItemSpecData, shiftSpec, chainDate);
        }
    }

    protected void getTieDataNodeListByFixTime(TieContextStd context, List<TieDataNodeStd> rawTimeBuckets, IncrDecrConfEntry entry, IncrDecrConf conf, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, List<TieDataNode> tieDataNodeList) {
        if (CollectionUtils.isEmpty(rawTimeBuckets)) {
            LOG.debug("IncrDecrEvaluator calculate fixTime type,not found rawTimeBuckets");
            return;
        }
        LocalDate chainDate = context.getChainDate();
        BizDataSource attDataSource = ContextUtil.getConfigMix(context).getDataSource(BizTypeEnum.INCR_DECR);
        List<TieDataNodeStd> filterTimeBuckets = rawTimeBuckets;
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        if (attDataSource != null) {
            IAccessService accessService = (IAccessService)WTCAppContextHelper.getBean(AccessServiceImpl.class);
            filterTimeBuckets = accessService.accessFilterByCondition(rawTimeBuckets, attDataSource.getCondition()).stream().map(TimeBucketStd.class::cast).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(filterTimeBuckets)) {
            LOG.debug("IncrDecrEvaluator calculate fixTime type,not found TimeBuckets");
            return;
        }
        List<TimeBucketStd> timeBucketStds = RawTimeBucket.cast(filterTimeBuckets);
        List<Object> collect = timeBucketStds.stream().map(TimeBucketStd::unwrapAndCopy).collect(Collectors.toList());
        if (HRStringUtils.isNotEmpty((String)conf.getCondition())) {
            collect = dateRangeService.filterDataNodes(WTCDateRangeSource.IDP, context, RawTimeBucket.cast(filterTimeBuckets), conf.getDateConditionAccessDto());
        }
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        collect.stream().filter(timeBucket -> this.isTheFixDatePrecedeTimeBucket((TimeBucket)timeBucket, entry)).findFirst().ifPresent(timeBucket -> this.newAttItemValue(tieDataNodeList, context, conf, entry, attItemSpecData, shiftSpec, chainDate));
    }

    protected IncrDecrRule getIncrDecrRule(LocalDate chainDate, TieContextStd context, IncrDecrPlan incrDecrPlan) {
        TimeSeqBo<IncrDecrRule> ruleTimeSeqBo;
        IncrDecrRule rule = !HRStringUtils.equalsIgnoreCase((String)"2", (String)incrDecrPlan.getSetRuleWay()) ? (null != (ruleTimeSeqBo = incrDecrPlan.getIncrDecrRule()) ? (IncrDecrRule)incrDecrPlan.getIncrDecrRule().getVersionByDate(chainDate) : this.getEngineRule(context, incrDecrPlan, chainDate)) : this.getEngineRule(context, incrDecrPlan, chainDate);
        return rule;
    }

    protected IncrDecrRule getEngineRule(TieContextStd context, IncrDecrPlan incrDecrPlan, LocalDate chainDate) {
        RuleParam ruleParam = new RuleParam(RuleEngineEnum.idp.getSceneNumber(), RuleEngineEnum.idp.getBizApp(), incrDecrPlan.getId());
        ruleParam.setScenePlanName(RuleEngineEnum.idp.getScenePlanName());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
        List<Long> ids = this.getRuleIds(policyResults, "wtp_incdecrules");
        RuleEngineMetaData ruleEngineMetaData = ContextUtil.getRuleEngineMetaData(context);
        for (Long id : ids) {
            TimeSeqBo bizRuleById = (TimeSeqBo)ruleEngineMetaData.getBizRuleById(id);
            if (null == bizRuleById) continue;
            return (IncrDecrRule)bizRuleById.getVersionByDate(chainDate);
        }
        return null;
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, null);
    }

    protected List<IncrDecrConf> getMatchConfigByIncrDecrRule(IncrDecrRule rule, LocalDate chainDate) {
        LinkedList<IncrDecrConf> configList = new LinkedList<IncrDecrConf>();
        List<IncrDecrRule.Tuple> tuples = rule.getEntities();
        for (IncrDecrRule.Tuple tuple : tuples) {
            IncrDecrConf incrDecrConf = (IncrDecrConf)tuple.getIncrDecrConfBo().getVersionByDate(chainDate);
            if (null == incrDecrConf) continue;
            configList.add(incrDecrConf);
        }
        return configList;
    }

    protected boolean isTheFixDatePrecedeTimeBucket(TimeBucket timeBucket, IncrDecrConfEntry entry) {
        Long triggerTime = entry.getRegularTime();
        LocalDateTime startTime = timeBucket.getStartTime();
        LocalDateTime endTime = timeBucket.getEndTime();
        LocalDateTime startTimeBucket = startTime.truncatedTo(ChronoUnit.DAYS).plus(triggerTime, ChronoUnit.SECONDS);
        LocalDateTime endLocalDate = endTime.truncatedTo(ChronoUnit.DAYS);
        if (startTime.truncatedTo(ChronoUnit.DAYS).equals(endLocalDate)) {
            return startTimeBucket.isAfter(startTime) && startTimeBucket.isBefore(endTime) || startTimeBucket.isEqual(startTime) || startTimeBucket.isEqual(endTime);
        }
        boolean startDateCheck = startTimeBucket.isAfter(startTime) && startTimeBucket.isBefore(endLocalDate);
        LocalDateTime endTimeBucket = endLocalDate.plus(triggerTime, ChronoUnit.SECONDS);
        boolean endDateCheck = endTimeBucket.isBefore(endTime) || endTimeBucket.equals(endTime);
        return startDateCheck || startTimeBucket.isEqual(startTime) || endDateCheck;
    }

    protected void newAttItemValue(List<TieDataNode> tieDataNodeList, TieContextStd context, IncrDecrConf conf, IncrDecrConfEntry entry, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, LocalDate chainDate) {
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(entry.getCurAttItemId(), chainDate);
        String incdecRelation = entry.getIndecrRel();
        BigDecimal amount = entry.getIndecrValue();
        if (StringUtils.equals((CharSequence)incdecRelation, (CharSequence)"B")) {
            amount = BigDecimal.ZERO.subtract(amount);
        }
        DataType dataType = attItemSpec.getDataType();
        AttItemInstance attItemInstance = this.genAttItemInstance(attItemSpec, amount, shiftSpec);
        String serialLimit = entry.getSerialLimit();
        boolean isSaveAttRecord = true;
        if (HRStringUtils.equalsIgnoreCase((String)"true", (String)serialLimit)) {
            boolean isNotSameDateShift;
            boolean isSerialLimitAdd = this.isSerialLimitAdd(context, chainDate, entry, shiftSpec);
            AttItemInstance preInstance = this.getPreInstanceSerialLimit(context, chainDate, attItemSpec, entry);
            boolean isSerialLimitContinue = this.isSerialLimitContinue(context, chainDate, entry);
            ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
            String dateAttributeCode = shiftTableSingle.getDateAttribute(chainDate).getCode();
            boolean isSameDateType = this.isSameDateType(dateAttributeCode, entry.getDayType());
            boolean isSameShiftType = this.isSameShiftType(shiftSpec, entry);
            boolean bl = isNotSameDateShift = !isSameDateType && !HRStringUtils.equals((String)"D", (String)entry.getDayType()) || !isSameShiftType;
            if (isNotSameDateShift) {
                isSaveAttRecord = false;
            }
            if (null != preInstance && isSerialLimitAdd) {
                if (DataType.TIMES == dataType) {
                    BigDecimal newAmount = amount.add(preInstance.getItemValue());
                    attItemInstance = new AttItemInstance(attItemSpec, newAmount);
                } else if (DataType.DURATION == dataType) {
                    BigDecimal secondsAmount = this.getSecond(attItemSpec.getUnit(), amount, shiftSpec);
                    BigDecimal dayAmount = shiftSpec.secondsToDays(secondsAmount);
                    BigDecimal newSecondsAmount = secondsAmount.add(preInstance.getSecondDecimal());
                    BigDecimal newDayAmount = dayAmount.add(preInstance.getDay());
                    attItemInstance = new AttItemInstance(attItemSpec, newDayAmount, newSecondsAmount);
                }
            } else if (null != preInstance && isSerialLimitContinue) {
                attItemInstance = preInstance;
                attItemInstance.getExtraLabels().add((ILabel)Label.of((String)"continue"));
            } else if (null == preInstance && isNotSameDateShift) {
                if (DataType.TIMES == dataType) {
                    attItemInstance = new AttItemInstance(attItemSpec, BigDecimal.ZERO);
                } else if (DataType.DURATION == dataType) {
                    attItemInstance = new AttItemInstance(attItemSpec, BigDecimal.ZERO, BigDecimal.ZERO);
                } else {
                    throw new WTCBizException(ResManager.loadKDString((String)"\u8003\u52e4\u9879\u76ee[{0}]\u7684\u5355\u4f4d\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"IncrDecrEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[]{attItemSpec.getNumber()}));
                }
                attItemInstance.getExtraLabels().add((ILabel)Label.of((String)"continue"));
            }
        }
        this.removeBeforeSameContinueAttItem(tieDataNodeList, attItemInstance, context);
        this.cacheAttItemInstanceMap(attItemInstance, context, false, amount, tieDataNodeList, attItemSpec, shiftSpec);
        AttItemValue.Builder builder = (AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).evaluationRule(EvaluationRuleModel.of(conf.getId(), "wtp_incdecconf"))).parentDataNodes(Collections.emptyList())).matchedRule((IEntity)conf);
        if (isSaveAttRecord) {
            builder.addLabel((ILabel)Label.of((String)"labelRecord"));
        }
        if (HRStringUtils.equalsIgnoreCase((String)"true", (String)serialLimit)) {
            builder.addLabel((ILabel)Label.of((String)"labelIncrDecrRecord"));
        }
        this.tieAllDataNodeList.add((TieDataNode)builder.build());
    }

    protected AttItemInstance genAttItemInstance(AttItemSpec attItemSpec, BigDecimal amount, ShiftSpec shiftSpec) {
        AttItemInstance attItemInstance = null;
        DataType dataType = attItemSpec.getDataType();
        if (DataType.TIMES == dataType) {
            attItemInstance = new AttItemInstance(attItemSpec, amount);
        } else if (DataType.DURATION == dataType) {
            BigDecimal secondsAmount = this.getSecond(attItemSpec.getUnit(), amount, shiftSpec);
            BigDecimal dayAmount = shiftSpec.secondsToDays(secondsAmount);
            attItemInstance = new AttItemInstance(attItemSpec, dayAmount, secondsAmount);
        }
        return attItemInstance;
    }

    protected boolean isSameShiftType(ShiftSpec shiftSpec, IncrDecrConfEntry entry) {
        boolean offShift = shiftSpec.isOff();
        boolean notSameShiftType = HRStringUtils.equals((String)"1", (String)entry.getShiftType()) && !offShift || HRStringUtils.equals((String)"2", (String)entry.getShiftType()) && offShift;
        return !notSameShiftType;
    }

    protected void continueAttItemValue(List<TieDataNode> tieDataNodeList, TieContextStd context, IncrDecrConf conf, IncrDecrConfEntry entry, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, LocalDate chainDate) {
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(entry.getCurAttItemId(), chainDate);
        AttItemInstance attItemInstance = null;
        AttItemInstance preInstance = this.getPreInstanceSerialLimit(context, chainDate, attItemSpec, entry);
        boolean isSerialLimitContinue = this.isSerialLimitContinue(context, chainDate, entry);
        if (null != preInstance && isSerialLimitContinue) {
            attItemInstance = preInstance;
        }
        boolean contain = false;
        if (null != attItemInstance) {
            for (TieDataNode node : this.tieAllDataNodeList) {
                if (!node.containsAttItem(attItemInstance.getAttItemSpec())) continue;
                contain = true;
                break;
            }
            if (!contain) {
                attItemInstance.getExtraLabels().add((ILabel)Label.of((String)"continue"));
                this.tieAllDataNodeList.add((TieDataNode)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).evaluationRule(EvaluationRuleModel.of(conf.getId(), "wtp_incdecconf"))).parentDataNodes(Collections.emptyList())).matchedRule((IEntity)conf)).addLabel((ILabel)Label.of((String)"continue"))).addLabel((ILabel)Label.of((String)"labelIncrDecrRecord"))).build());
                this.cacheAttItemInstanceMap(attItemInstance, context, false, null, tieDataNodeList, attItemSpec, shiftSpec);
            }
        }
    }

    protected boolean isSerialLimitContinue(TieContextStd context, LocalDate chainDate, IncrDecrConfEntry entry) {
        Date currentDate;
        AttPeriodTable attPeriodTable = ContextUtil.getAttPeriodTable(context);
        Optional<PerAttPeriod> specificPer = attPeriodTable.getPerAttPeriodByAttPersonIdAndDate(context.getAttPersonId(), chainDate);
        if (!specificPer.isPresent()) {
            return false;
        }
        PerAttPeriod perAttPeriod = specificPer.get();
        if (HRStringUtils.equals((String)"0", (String)entry.getSerialPeriod())) {
            Date preDate = WTCDateUtils.toDate((LocalDate)chainDate.minusDays(1L));
            if (perAttPeriod.getAttPeriodStartDate().getTime() > preDate.getTime() || perAttPeriod.getAttPeriodEndDate().getTime() < preDate.getTime()) {
                return false;
            }
        }
        return (currentDate = WTCDateUtils.toDate((LocalDate)chainDate)).getTime() != perAttPeriod.getAttPeriodStartDate().getTime() || !HRStringUtils.equals((String)"0", (String)entry.getSerialPeriod());
    }

    protected boolean isSerialLimitAdd(TieContextStd context, LocalDate chainDate, IncrDecrConfEntry entry, ShiftSpec shiftSpec) {
        boolean notSameShiftType;
        Date currentDate;
        AttPeriodTable attPeriodTable = ContextUtil.getAttPeriodTable(context);
        Optional<PerAttPeriod> specificPer = attPeriodTable.getPerAttPeriodByAttPersonIdAndDate(context.getAttPersonId(), chainDate);
        if (!specificPer.isPresent()) {
            return false;
        }
        PerAttPeriod perAttPeriod = specificPer.get();
        if (HRStringUtils.equals((String)"0", (String)entry.getSerialPeriod())) {
            Date preDate = WTCDateUtils.toDate((LocalDate)chainDate.minusDays(1L));
            if (perAttPeriod.getAttPeriodStartDate().getTime() > preDate.getTime() || perAttPeriod.getAttPeriodEndDate().getTime() < preDate.getTime()) {
                return false;
            }
        }
        if ((currentDate = WTCDateUtils.toDate((LocalDate)chainDate)).getTime() == perAttPeriod.getAttPeriodStartDate().getTime() && HRStringUtils.equals((String)"0", (String)entry.getSerialPeriod())) {
            return false;
        }
        boolean offShift = shiftSpec.isOff();
        boolean bl = notSameShiftType = HRStringUtils.equals((String)"1", (String)entry.getShiftType()) && !offShift || HRStringUtils.equals((String)"2", (String)entry.getShiftType()) && offShift;
        if (notSameShiftType) {
            return false;
        }
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        String dateAttributeCode = shiftTableSingle.getDateAttribute(chainDate).getCode();
        boolean isSameDateType = this.isSameDateType(dateAttributeCode, entry.getDayType());
        return HRStringUtils.equals((String)"D", (String)entry.getDayType()) || isSameDateType;
    }

    protected boolean isSameDateType(String dateAttributeCode, String dayType) {
        boolean result = false;
        if (HRStringUtils.equals((String)DateAttribute.HOLIDAY.getCode(), (String)dateAttributeCode) && HRStringUtils.equals((String)"C", (String)dayType)) {
            return true;
        }
        if (HRStringUtils.equals((String)DateAttribute.WORKDAY.getCode(), (String)dateAttributeCode) && HRStringUtils.equals((String)"A", (String)dayType)) {
            return true;
        }
        if (HRStringUtils.equals((String)DateAttribute.OFFDAY.getCode(), (String)dateAttributeCode) && HRStringUtils.equals((String)"B", (String)dayType)) {
            return true;
        }
        return result;
    }

    protected AttItemInstance getPreInstanceSerialLimit(TieContextStd context, LocalDate chainDate, AttItemSpec attItemSpec, IncrDecrConfEntry entry) {
        Map itemMap;
        AttPeriodTable attPeriodTable;
        Optional<PerAttPeriod> specificPer;
        AttItemInstance instance = null;
        if (HRStringUtils.equals((String)"0", (String)entry.getSerialPeriod()) && (specificPer = (attPeriodTable = ContextUtil.getAttPeriodTable(context)).getPerAttPeriodByAttPersonIdAndDate(context.getAttPersonId(), chainDate)).isPresent()) {
            PerAttPeriod perAttPeriod = specificPer.get();
            Date preDate = WTCDateUtils.toDate((LocalDate)chainDate.minusDays(1L));
            if (perAttPeriod.getAttPeriodStartDate().getTime() > preDate.getTime() || perAttPeriod.getAttPeriodEndDate().getTime() < preDate.getTime()) {
                return null;
            }
        }
        LocalDate preLocalDate = chainDate.minusDays(1L);
        Map map = (Map)context.getVariable("INCR_DECR_ATT_ITEMS", VScope.LINE);
        if (MapUtils.isNotEmpty((Map)map) && MapUtils.isNotEmpty((Map)(itemMap = (Map)map.get(preLocalDate)))) {
            instance = (AttItemInstance)itemMap.get(attItemSpec.getBid());
        }
        if (null != instance) {
            return instance;
        }
        return this.getPreInstanceFromAttRecordDetail(context, preLocalDate, attItemSpec);
    }

    protected AttItemInstance getPreInstanceFromAttRecordDetail(TieContextStd context, LocalDate preLocalDate, AttItemSpec attItemSpec) {
        AttRecordDetailSingle single;
        Map<Long, AttRecordDetailSingle> detailMap;
        AttItemInstance instance = null;
        AttRecordDetailTable attRecordDetailTable = context.getInitParamMust("ATT_RECORD_DETAIL", AttRecordDetailTable.class);
        Map<LocalDate, Map<Long, AttRecordDetailSingle>> localDateMap = attRecordDetailTable.getByAttPersonId(context.getAttPersonId());
        if (MapUtils.isNotEmpty(localDateMap) && MapUtils.isNotEmpty(detailMap = localDateMap.get(preLocalDate)) && null != (single = detailMap.get(attItemSpec.getBid()))) {
            if (HRStringUtils.equals((String)"0", (String)single.getDateType())) {
                BigDecimal amount = single.getValue();
                instance = new AttItemInstance(attItemSpec, amount);
            } else if (HRStringUtils.equals((String)"1", (String)single.getDateType())) {
                BigDecimal secondsAmount = single.getValueSecond();
                BigDecimal dayAmount = single.getValue();
                instance = new AttItemInstance(attItemSpec, dayAmount, secondsAmount);
            }
        }
        return instance;
    }

    protected void newAttItemValueList(List<TieDataNode> tieDataNodeList, TieContextStd context, IncrDecrConf conf, IncrDecrConfEntry entry, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec, LocalDate chainDate) {
        List<IncrDecrConfEntry.ResultEntry> resultEntryList = entry.getResultEntry();
        for (IncrDecrConfEntry.ResultEntry resultEntry : resultEntryList) {
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(resultEntry.getResultItemId(), chainDate);
            String incdecRelation = resultEntry.getResultRel();
            BigDecimal amount = resultEntry.getResultValue();
            if (StringUtils.equals((CharSequence)incdecRelation, (CharSequence)"B")) {
                amount = BigDecimal.ZERO.subtract(amount);
            }
            AttItemInstance attItemInstance = null;
            DataType dataType = attItemSpec.getDataType();
            if (DataType.TIMES == dataType) {
                attItemInstance = new AttItemInstance(attItemSpec, amount);
            } else if (DataType.DURATION == dataType) {
                BigDecimal secondsAmount = this.getSecond(attItemSpec.getUnit(), amount, shiftSpec);
                BigDecimal dayAmount = shiftSpec.secondsToDays(secondsAmount);
                attItemInstance = new AttItemInstance(attItemSpec, dayAmount, secondsAmount);
            }
            boolean resetAttItem = StringUtils.equals((CharSequence)incdecRelation, (CharSequence)"C");
            this.cacheAttItemInstanceMap(attItemInstance, context, resetAttItem, amount, tieDataNodeList, attItemSpec, shiftSpec);
            AttItemValue attItemValue = (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).evaluationRule(EvaluationRuleModel.of(conf.getId(), "wtp_incdecconf"))).parentDataNodes(Collections.emptyList())).matchedRule((IEntity)conf)).addLabel((ILabel)(resetAttItem ? Label.of((String)"reset") : Label.of((String)"incrdecr")))).addLabel((ILabel)Label.of((String)"labelRecord"))).build();
            this.removeBeforeSameContinueAttItem(tieDataNodeList, attItemInstance, context);
            this.tieAllDataNodeList.add(attItemValue);
        }
    }

    protected void cacheAttItemInstanceMap(AttItemInstance attItemInstance, TieContextStd context, boolean resetAttItem, BigDecimal amount, List<TieDataNode> tieDataNodeList, AttItemSpec attItemSpec, ShiftSpec shiftSpec) {
        if (null == attItemInstance) {
            return;
        }
        LocalDate chainDate = context.getChainDate();
        HashMap<LocalDate, HashMap<Long, AttItemInstance>> map = (HashMap<LocalDate, HashMap<Long, AttItemInstance>>)context.getVariable("INCR_DECR_ATT_ITEMS", VScope.LINE);
        if (MapUtils.isEmpty((Map)map)) {
            HashMap<Long, AttItemInstance> attItemMap = new HashMap<Long, AttItemInstance>(16);
            attItemMap.put(attItemInstance.getAttItemSpec().getBid(), attItemInstance);
            map = new HashMap<LocalDate, HashMap<Long, AttItemInstance>>(8);
            map.put(chainDate, attItemMap);
        } else {
            HashMap<Long, AttItemInstance> attItemMap = (HashMap<Long, AttItemInstance>)map.get(chainDate);
            if (MapUtils.isEmpty((Map)attItemMap)) {
                attItemMap = new HashMap<Long, AttItemInstance>(16);
                attItemMap.put(attItemInstance.getAttItemSpec().getBid(), attItemInstance);
            } else if (resetAttItem) {
                attItemMap.put(attItemInstance.getAttItemSpec().getBid(), attItemInstance);
                this.removeBeforeSameAttItem(tieDataNodeList, attItemInstance);
            } else {
                this.cacheNewAttItemMap(attItemMap, attItemInstance, amount, attItemSpec, shiftSpec);
            }
            map.put(chainDate, attItemMap);
        }
        context.setVariable("INCR_DECR_ATT_ITEMS", map, VScope.LINE);
    }

    protected void cacheNewAttItemMap(Map<Long, AttItemInstance> attItemMap, AttItemInstance attItemInstance, BigDecimal amount, AttItemSpec attItemSpec, ShiftSpec shiftSpec) {
        AttItemInstance cacheAttItem = attItemMap.get(attItemInstance.getAttItemSpec().getBid());
        if (null != cacheAttItem && null != amount) {
            DataType cacheDataType = cacheAttItem.getAttItemSpec().getDataType();
            if (DataType.TIMES == cacheDataType) {
                BigDecimal newAmount = amount.add(cacheAttItem.getItemValue());
                AttItemInstance newAttItem = new AttItemInstance(attItemSpec, newAmount);
                attItemMap.put(newAttItem.getAttItemSpec().getBid(), newAttItem);
            } else if (DataType.DURATION == cacheDataType) {
                BigDecimal secondsAmount = this.getSecond(attItemSpec.getUnit(), amount, shiftSpec);
                BigDecimal dayAmount = shiftSpec.secondsToDays(secondsAmount);
                BigDecimal newSecondsAmount = secondsAmount.add(cacheAttItem.getSecondDecimal());
                BigDecimal newDayAmount = dayAmount.add(cacheAttItem.getDay());
                AttItemInstance newAttItem = new AttItemInstance(attItemSpec, newDayAmount, newSecondsAmount);
                attItemMap.put(newAttItem.getAttItemSpec().getBid(), newAttItem);
            }
        } else {
            attItemMap.put(attItemInstance.getAttItemSpec().getBid(), attItemInstance);
        }
    }

    protected void rollbackAttItemMap(Map<Long, AttItemInstance> attItemMap, AttItemInstance attItemInstance, AttItemInstance instance) {
        if (null != attItemInstance && null != instance) {
            DataType dataType = attItemInstance.getAttItemSpec().getDataType();
            if (DataType.TIMES == dataType) {
                BigDecimal newAmount = attItemInstance.getItemValue().subtract(instance.getItemValue());
                AttItemInstance newAttItem = new AttItemInstance(attItemInstance.getAttItemSpec(), newAmount);
                attItemMap.put(newAttItem.getAttItemSpec().getBid(), newAttItem);
            } else if (DataType.DURATION == dataType) {
                BigDecimal secondsAmount = attItemInstance.getSecondDecimal();
                BigDecimal dayAmount = attItemInstance.getDay();
                BigDecimal newSecondsAmount = secondsAmount.subtract(instance.getSecondDecimal());
                BigDecimal newDayAmount = dayAmount.subtract(instance.getDay());
                AttItemInstance newAttItem = new AttItemInstance(attItemInstance.getAttItemSpec(), newDayAmount, newSecondsAmount);
                attItemMap.put(newAttItem.getAttItemSpec().getBid(), newAttItem);
            }
        }
    }

    protected void removeBeforeSameAttItem(List<TieDataNode> tieDataNodeList, AttItemInstance attItemInstance) {
        Iterator<TieDataNode> iterator = this.tieAllDataNodeList.iterator();
        while (iterator.hasNext()) {
            TieDataNode node = iterator.next();
            long attItemId = node.getAttItemInstances().get(0).getAttItemSpec().getBid();
            if (attItemId != attItemInstance.getAttItemSpec().getBid()) continue;
            iterator.remove();
        }
    }

    protected void removeBeforeSameContinueAttItem(List<TieDataNode> tieDataNodeList, AttItemInstance attItemInstance, TieContextStd context) {
        if (null == attItemInstance) {
            return;
        }
        Iterator<TieDataNode> iterator = this.tieAllDataNodeList.iterator();
        ArrayList<AttItemInstance> removeList = new ArrayList<AttItemInstance>(2);
        while (iterator.hasNext()) {
            TieDataNode node = iterator.next();
            long attItemId = node.getAttItemInstances().get(0).getAttItemSpec().getBid();
            if (attItemId != attItemInstance.getAttItemSpec().getBid() || !node.getLabelSet().containsKey("continue")) continue;
            removeList.add(node.getAttItemInstances().get(0));
            iterator.remove();
        }
        Map map = (Map)context.getVariable("INCR_DECR_ATT_ITEMS", VScope.LINE);
        if (CollectionUtils.isEmpty(removeList) || MapUtils.isEmpty((Map)map)) {
            return;
        }
        LocalDate chainDate = context.getChainDate();
        Map attItemMap = (Map)map.get(chainDate);
        if (MapUtils.isEmpty((Map)attItemMap)) {
            return;
        }
        for (AttItemInstance instance : removeList) {
            AttItemInstance currInstance = (AttItemInstance)attItemMap.get(instance.getAttItemSpec().getBid());
            if (null == currInstance) continue;
            this.rollbackAttItemMap(attItemMap, currInstance, instance);
            map.put(chainDate, attItemMap);
            context.setVariable("INCR_DECR_ATT_ITEMS", map, VScope.LINE);
        }
    }

    protected BigDecimal getSecond(String unit, BigDecimal amount, ShiftSpec shiftSpec) {
        if (AttitemUnitEnum.DAY.getUnit().equals(unit)) {
            return shiftSpec.daysToSecondDecimal(amount);
        }
        if (AttitemUnitEnum.HOUR.getUnit().equals(unit)) {
            return amount.multiply(TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL);
        }
        if (AttitemUnitEnum.MINUTE.getUnit().equals(unit)) {
            return amount.multiply(TimeConstants.SECOND_OF_ONE_MINUTE_DECIMAL);
        }
        return amount;
    }

    protected BigDecimal secondToUnit(String unit, BigDecimal amount, int dataAccuracy, ShiftSpec shiftSpec) {
        BigDecimal attSecond = amount;
        if (AttitemUnitEnum.DAY.getUnit().equals(unit)) {
            return shiftSpec.secondsToDays(amount);
        }
        if (AttitemUnitEnum.HOUR.getUnit().equals(unit)) {
            return IncrDecrEvaluator.scale(attSecond, dataAccuracy, TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL);
        }
        if (AttitemUnitEnum.MINUTE.getUnit().equals(unit)) {
            return IncrDecrEvaluator.scale(attSecond, dataAccuracy, TimeConstants.SECOND_OF_ONE_MINUTE_DECIMAL);
        }
        if (AttitemUnitEnum.SECOND.getUnit().equals(unit)) {
            return attSecond;
        }
        return attSecond;
    }

    protected static BigDecimal scale(BigDecimal value, int dataAccuracy, BigDecimal scale) {
        return value.divide(scale, dataAccuracy, RoundingMode.HALF_UP);
    }

    protected boolean parseExpress(TieContextStd context, LocalDate chainDate, IncrDecrConfEntry entry, ShiftSpec shiftSpec) {
        List<TieDataNodeStd> allDateNode = context.getAllDataNodes();
        Map<Long, AttItemValue> attItemValueMap = context.getAllHandleResultAttItemValueMap(allDateNode);
        if (CollectionUtils.isEmpty(attItemValueMap)) {
            return false;
        }
        String relateExpress = entry.getRelateExpress();
        for (IncrDecrConfEntry.LimitEntry limitEntry : entry.getLimitEntry()) {
            BigDecimal attValue;
            List<AttItemInstance> instances = this.getInstancesFromLimitEntry(limitEntry, context, attItemValueMap, chainDate);
            if (CollectionUtils.isEmpty(instances)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" IncrDecrEvaluator calculate,not match express. limitAttItems:{},attItemValueMapKey:{}", (Object)JSON.toJSONString(limitEntry.getAttItems()), (Object)JSON.toJSONString(attItemValueMap.keySet()));
                }
                relateExpress = relateExpress.replaceAll(limitEntry.getLimitNo(), "false");
                continue;
            }
            AttItemInstance attItemInstance = instances.get(0);
            AttItemSpec attItemSpec = attItemInstance.getAttItemSpec();
            DataType dataType = attItemSpec.getDataType();
            if (DataType.DURATION == dataType) {
                String unit = attItemSpec.getUnit();
                BigDecimal sumAtt = BigDecimal.ZERO;
                for (AttItemInstance attItem : instances) {
                    sumAtt = sumAtt.add(attItem.getSecondDecimal());
                }
                int dataAccuracy = attItemSpec.getDataAccuracy();
                attValue = this.secondToUnit(unit, sumAtt, dataAccuracy, shiftSpec);
            } else if (DataType.TIMES == dataType) {
                attValue = instances.stream().map(AttItemInstance::getItemValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            } else {
                throw new WTCBizException(ResManager.loadKDString((String)"\u8003\u52e4\u9879\u76ee[{0}]\u7684\u5355\u4f4d\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"IncrDecrEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[]{attItemSpec.getNumber()}));
            }
            String parse = limitEntry.getParser().replaceAll("attValue", attValue.setScale(10, RoundingMode.HALF_UP).toString());
            relateExpress = relateExpress.replaceAll(limitEntry.getLimitNo(), parse);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" IncrDecrEvaluator calculate,relateExpress:{}", (Object)relateExpress);
            }
            return new ParserUtil().calculate(relateExpress, null);
        }
        catch (Exception e) {
            throw new WtesException(new ErrorCode("rlid_01", ResManager.loadKDString((String)"\u589e\u51cf\u8ba1\u7b97\u9650\u5236\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\u3002", (String)"IncrDecrEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0])), new Object[]{e});
        }
    }

    protected List<AttItemInstance> getInstancesFromLimitEntry(IncrDecrConfEntry.LimitEntry limitEntry, TieContextStd context, Map<Long, AttItemValue> attItemValueMap, LocalDate chainDate) {
        ArrayList instances = Lists.newArrayList();
        if (LOG.isDebugEnabled()) {
            LOG.debug(" IncrDecrEvaluator calculate,limitEntry.getAttItems:{}", (Object)JSON.toJSONString(limitEntry.getAttItems()));
        }
        for (Long attItemId : limitEntry.getAttItems()) {
            Map map = (Map)context.getVariable("INCR_DECR_ATT_ITEMS", VScope.LINE);
            if (MapUtils.isNotEmpty((Map)map)) {
                Map attItemMap = (Map)map.get(chainDate);
                if (MapUtils.isNotEmpty((Map)attItemMap)) {
                    AttItemInstance cacheAttItem = (AttItemInstance)attItemMap.get(attItemId);
                    if (null != cacheAttItem && !cacheAttItem.getExtraLabels().containsKey("continue")) {
                        instances.add(cacheAttItem);
                        continue;
                    }
                    this.getInstancesFromAttItemValueMap(instances, attItemValueMap, attItemId);
                    continue;
                }
                this.getInstancesFromAttItemValueMap(instances, attItemValueMap, attItemId);
                continue;
            }
            this.getInstancesFromAttItemValueMap(instances, attItemValueMap, attItemId);
        }
        return instances;
    }

    protected void getInstancesFromAttItemValueMap(List<AttItemInstance> instances, Map<Long, AttItemValue> attItemValueMap, Long attItemId) {
        List<AttItemInstance> attItemInstances;
        AttItemValue attItemValue = attItemValueMap.get(attItemId);
        if (null != attItemValue && CollectionUtils.isNotEmpty(attItemInstances = attItemValue.getAttItemInstances())) {
            instances.addAll(attItemInstances);
        }
    }

    protected List<Long> getRuleIds(List<PolicyResult> policyResults, String ruleEntity) {
        LinkedList ruleIds = Lists.newLinkedList();
        for (PolicyResult policyResult : policyResults) {
            if (policyResult.getRuleResults().isEmpty()) {
                Object obj = policyResult.getDefaultResults().get(ruleEntity);
                this.parseResultObj(obj, ruleIds);
                continue;
            }
            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                Object obj = ruleResult.getMatchResults().get(ruleEntity);
                this.parseResultObj(obj, ruleIds);
            }
        }
        return ruleIds;
    }

    protected void parseResultObj(Object obj, List<Long> ids) {
        if (obj instanceof DynamicObject) {
            ids.add(((DynamicObject)obj).getLong("id"));
        } else if (obj instanceof DynamicObjectCollection) {
            ids.addAll(((DynamicObjectCollection)obj).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        } else if (obj instanceof DynamicObject[]) {
            ids.addAll(Arrays.stream((DynamicObject[])obj).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
    }

    protected AttItemInstance getCurrContinueItemValue(TieContextStd context, IncrDecrConfEntry entry, AttItemSpecData attItemSpecData) {
        Map itemMap;
        LocalDate chainDate = context.getChainDate();
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(entry.getCurAttItemId(), chainDate);
        Map map = (Map)context.getVariable("INCR_DECR_ATT_ITEMS", VScope.LINE);
        if (MapUtils.isNotEmpty((Map)map) && WTCCollections.isNotEmpty((Map)(itemMap = (Map)map.get(chainDate)))) {
            return (AttItemInstance)itemMap.get(attItemSpec.getBid());
        }
        return null;
    }

    protected void updateCurrContinueItemValue(TieContextStd context, AttItemInstance zeroInstance) {
        Map itemMap;
        LocalDate chainDate = context.getChainDate();
        AttItemSpec attItemSpec = zeroInstance.getAttItemSpec();
        Map map = (Map)context.getVariable("INCR_DECR_ATT_ITEMS", VScope.LINE);
        if (MapUtils.isNotEmpty((Map)map) && WTCCollections.isNotEmpty((Map)(itemMap = (Map)map.get(chainDate)))) {
            AttItemInstance instance = (AttItemInstance)itemMap.get(attItemSpec.getBid());
            AttItemInstance resultInst = new AttItemInstance(instance.getAttItemSpec(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null);
            itemMap.put(attItemSpec.getBid(), resultInst);
        }
    }

    protected BigDecimal getAttItemValue(AttItemInstance instance) {
        AttItemSpec attItemSpec = instance.getAttItemSpec();
        DataType dataType = attItemSpec.getDataType();
        if (DataType.TIMES == dataType) {
            return instance.getItemValue();
        }
        return instance.getSecondDecimal();
    }

    protected BigDecimal getTriggerVal(AttItemInstance instance, IncrDecrConfEntry entry, ShiftSpec shiftSpec) {
        AttItemSpec attItemSpec = instance.getAttItemSpec();
        DataType dataType = attItemSpec.getDataType();
        BigDecimal attValue = entry.getTriggerVal();
        if (DataType.DURATION == dataType) {
            String unit = attItemSpec.getUnit();
            return this.getSecond(unit, attValue, shiftSpec);
        }
        if (DataType.TIMES == dataType) {
            return attValue;
        }
        return attValue;
    }

    protected AttItemInstance getTriggerAttItemInst(TieContextStd context, IncrDecrConfEntry entry, ShiftSpec shiftSpec, AttItemSpecData attItemSpecData) {
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(entry.getTriggerItemId(), context.getChainDate());
        DataType dataType = attItemSpec.getDataType();
        BigDecimal triggerResult = entry.getTriggerResult();
        if (DataType.DURATION == dataType) {
            String unit = attItemSpec.getUnit();
            triggerResult = this.getSecond(unit, triggerResult, shiftSpec);
            return new AttItemInstance(attItemSpec, BigDecimal.ZERO, shiftSpec.secondsToDays(triggerResult), triggerResult, null);
        }
        if (DataType.TIMES == dataType) {
            return new AttItemInstance(attItemSpec, triggerResult, BigDecimal.ZERO, BigDecimal.ZERO, null);
        }
        throw new WTCBizException(ResManager.loadKDString((String)"\u8003\u52e4\u9879\u76ee[{0}]\u7684\u5355\u4f4d\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"IncrDecrEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[]{attItemSpec.getNumber()}));
    }

    protected void exportTriggerAttItemResult(TieContextStd context, IncrDecrConfEntry entry, ShiftSpec shiftSpec, AttItemSpecData attItemSpecData, IncrDecrConf conf) {
        AttItemInstance inst = this.getTriggerAttItemInst(context, entry, shiftSpec, attItemSpecData);
        if ("B".equals(entry.getTriggerComp()) || "C".equals(entry.getTriggerComp())) {
            this.cacheAttItemInstanceMap(inst, context, false, entry.getTriggerResult(), null, inst.getAttItemSpec(), shiftSpec);
        }
        AttItemValue.Builder builder = (AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(inst)).evaluationRule(EvaluationRuleModel.of(conf.getId(), "wtp_incdecconf"))).parentDataNodes(Collections.emptyList())).addLabel((ILabel)Label.of((String)"labelRecord"))).matchedRule((IEntity)conf);
        this.tieAllDataNodeList.add((TieDataNode)builder.build());
    }

    protected void continueTriggerAttItem(TieContextStd context, IncrDecrConf conf, IncrDecrConfEntry entry, AttItemSpecData attItemSpecData, ShiftSpec shiftSpec) {
        if (entry.isTriggerItem()) {
            AttItemInstance instance = this.getCurrContinueItemValue(context, entry, attItemSpecData);
            if (null == instance || instance.getExtraLabels().containsKey("continue")) {
                return;
            }
            BigDecimal itemValue = this.getAttItemValue(instance);
            BigDecimal triggerVal = this.getTriggerVal(instance, entry, shiftSpec);
            if ("A".equals(entry.getTriggerComp())) {
                if (itemValue.compareTo(triggerVal) >= 0) {
                    this.exportTriggerAttItemResult(context, entry, shiftSpec, attItemSpecData, conf);
                    for (TieDataNode tieDataNode : this.tieAllDataNodeList) {
                        List<AttItemInstance> instances = tieDataNode.getAttItemInstances();
                        if (!WTCCollections.isNotEmpty(instances)) continue;
                        long bid = instances.get(0).getAttItemSpec().getBid();
                        if (instance.getAttItemSpec().getBid() != bid || !tieDataNode.getLabelSet().containsKey("labelIncrDecrRecord")) continue;
                        tieDataNode.getLabelSet().add((ILabel)Label.of((String)"labelIncrDecrReturnZero"));
                    }
                }
            } else if ("B".equals(entry.getTriggerComp())) {
                if (itemValue.compareTo(triggerVal) >= 0) {
                    this.exportTriggerAttItemResult(context, entry, shiftSpec, attItemSpecData, conf);
                }
            } else if ("C".equals(entry.getTriggerComp()) && itemValue.compareTo(triggerVal) > 0) {
                this.exportTriggerAttItemResult(context, entry, shiftSpec, attItemSpecData, conf);
            }
        }
    }
}

