/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlotcal;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.PolicyResultHelp;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.OtAttPackage;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.rlotcal.OtRulePackage;
import kd.wtc.wtes.business.model.rlotcal.TimeCut;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class OtCommonEvaluator {
    private static final Log logger = LogFactory.getLog(OtCommonEvaluator.class);
    protected TieDataResultStd otExclusion = TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u52a0\u73ed\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"OtCommonEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0])));
    protected LocalDate chainDate = null;
    protected long attPersonId = -1L;
    Set<String> otsceneSet = new HashSet<String>();
    protected ShiftTableSingle shiftTableSingle = null;
    protected ShiftSpec shiftSpec = null;
    protected AttFileModel attFileModel = null;
    protected OtAttPackage attOtPackage = null;
    protected OtRulePackage ruleConfig = null;
    protected TimeCut timeCut = null;
    protected AttItemSpecData attItemSpecData = null;
    protected List<TieDataNode> tieDataNodeList = new LinkedList<TieDataNode>();
    List<TieDataNodeStd> tieDataNodeStdList = null;
    protected boolean isDirectSetRule;
    protected TieContextStd context;

    protected TieDataResultStd evaluate(TieContextStd context, TieEvaluatorStd evaluator) {
        logger.debug("start otcal {} context.getAttPersonId():{} context.getRawTimeBuckets().isEmpty():{} ", new Object[]{this.getClass().getSimpleName(), context.getAttPersonId(), context.getRawTimeBuckets().isEmpty()});
        if (context.getDataNodesOfPrevStepExecutor().isEmpty()) {
            return this.otExclusion;
        }
        return evaluator.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    protected TieDataResultStd beforeEvaluator(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return this.otExclusion;
        }
        this.context = context;
        this.chainDate = context.getChainDate();
        this.attPersonId = context.getAttPersonId();
        this.shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        this.shiftSpec = this.shiftTableSingle.getShiftSpec(this.chainDate);
        this.attFileModel = ContextUtil.getCurrentAttFile(context);
        this.attOtPackage = this.attFileModel.getAttOtPackage(this.chainDate);
        if (Objects.isNull((Object)this.attOtPackage)) {
            return this.showMessage("attOtPackage");
        }
        this.attItemSpecData = ContextUtil.getAttItemSpecData(context);
        AttItemSpec invalidAttItem = this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate);
        this.tieDataNodeStdList = dataNodes.stream().filter(item -> {
            for (AttItemInstance attItemInstance : item.getAttItemInstances()) {
                if (!((Object)((Object)attItemInstance.getAttItemSpec())).equals((Object)invalidAttItem) && attItemInstance.getSecondDecimal().compareTo(BigDecimal.ZERO) != 0 && BigDecimal.ZERO.compareTo(attItemInstance.getDay()) != 0) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        this.ruleConfig = this.getRuleConfig(context);
        this.setOtSence();
        if (this.ruleConfig == null) {
            return this.showMessage("ruleConfig");
        }
        this.tieDataNodeList = new LinkedList<TieDataNode>();
        return null;
    }

    protected TieDataResultStd showMessage(String property) {
        logger.warn(String.format("There is no %s exists for attPersonId=%s, chainDate=%s", property, this.attPersonId, this.chainDate));
        return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format("There is no %s exists for attPersonId=%s, chainDate=%s", property, this.attPersonId, this.chainDate)));
    }

    private OtRulePackage getRuleConfig(TieContextStd context) {
        OtRulePackage otRulePackage = null;
        if ("1".equals(this.attOtPackage.getRuleWay())) {
            TimeSeqAvailableBo<OtRulePackage> rule = this.attOtPackage.getRuleList();
            if (!rule.isEmpty()) {
                otRulePackage = (OtRulePackage)rule.getVersionByDate(this.chainDate);
            }
            this.isDirectSetRule = true;
        } else {
            List list = null;
            if (RuleEngineEnum.otp.getSceneNumber().equals(this.attOtPackage.getSceneNumber())) {
                list = PolicyResultHelp.getRuleConfigByPolicyResult(RuleEngineEnum.otp, context, this.attOtPackage);
            } else if (RuleEngineEnum.otp3.getSceneNumber().equals(this.attOtPackage.getSceneNumber())) {
                list = PolicyResultHelp.getRuleConfigByPolicyResult(RuleEngineEnum.otp3, context, this.attOtPackage);
            }
            otRulePackage = list != null && list.size() > 0 ? (OtRulePackage)((Object)list.get(0)) : null;
            this.isDirectSetRule = false;
        }
        return otRulePackage;
    }

    private void setOtSence() {
        if ("2".equals(this.attOtPackage.getRuleWay())) {
            Set<Object> otscenes = Sets.newHashSet();
            Set<Object> ottimecut = Sets.newHashSet();
            if (RuleEngineEnum.otp.getSceneNumber().equals(this.attOtPackage.getSceneNumber())) {
                otscenes = PolicyResultHelp.getConfigByPolicyResult(RuleEngineEnum.otp, this.context, this.attOtPackage, "otscene");
            }
            if (RuleEngineEnum.otp3.getSceneNumber().equals(this.attOtPackage.getSceneNumber())) {
                ottimecut = PolicyResultHelp.getConfigByPolicyResult(RuleEngineEnum.otp3, this.context, this.attOtPackage, "timecut");
            }
            for (Object otscene : otscenes) {
                this.otsceneSet = Sets.newHashSet((Object[])otscene.toString().split(","));
            }
            for (Object obj : ottimecut) {
                Map map = (Map)this.context.getInitParam("TIME_CUT");
                this.timeCut = (TimeCut)map.get(((DynamicObject)obj).getLong("id"));
            }
        } else {
            this.otsceneSet = this.attOtPackage.getOtscenes();
            this.timeCut = this.attOtPackage.getTimeCut();
        }
    }

    public List<Long> getFilterList(Collection<Long> attItemList) {
        if (Objects.isNull(attItemList) || attItemList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<Long> effectAttItemId = attItemList.stream().filter(itemId -> this.attItemSpecData.getByBidAndDate((long)itemId, this.chainDate) != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(effectAttItemId)) {
            return Collections.EMPTY_LIST;
        }
        return effectAttItemId;
    }

    protected List<AttItemInstance> genAttItemInstances(Collection<Long> attItemList, BigDecimal timeSec) {
        ArrayList<AttItemInstance> instances = new ArrayList<AttItemInstance>(10);
        List<Long> dropAttItemIds = this.getFilterList(attItemList);
        for (Long dropAttItemId : dropAttItemIds) {
            AttItemInstance attItem = InitHelper.createAttItem(this.chainDate, timeSec, this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(dropAttItemId, this.chainDate));
            instances.add(attItem);
        }
        return instances;
    }

    protected List<AttItemValue> genAttItemValues(Collection<Long> attItemList, BigDecimal timeSec, EvaluationRuleModel evaluationRuleModel, Collection<TieDataNodeStd> parentDataNodes) {
        List<AttItemInstance> instances = this.genAttItemInstances(attItemList, timeSec);
        return instances.stream().map(attItemInstance -> (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(this.tieDataNodeStdList)).evaluationRule(evaluationRuleModel)).attItemInstance((AttItemInstance)attItemInstance)).build()).collect(Collectors.toList());
    }
}

