/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlotcal;

import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtbs.common.predata.wtbd.PreDataShiftPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.OtCommonEvaluator;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.RawTimeBucket;
import kd.wtc.wtes.business.model.rlotcal.OtDeductSubTimeItem;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalConfig;
import kd.wtc.wtes.business.model.rlotcal.OtSubConfig;
import kd.wtc.wtes.business.model.rlotcal.OtSubTimeItem;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.TimeBucketUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class OtSubEvaluator
extends OtCommonEvaluator
implements TieEvaluatorStd {
    private static final Log logger = LogFactory.getLog(OtSubEvaluator.class);
    private static final int ONE_HOUR_TO_SECOND = 3600;
    private static final long SECOND_IN_MIN = 60L;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return super.evaluate(context, this);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        TieDataResultStd tieDataNodeTieDataResult = super.beforeEvaluator(context, dataNodes);
        if (tieDataNodeTieDataResult != null) {
            return tieDataNodeTieDataResult;
        }
        Map<IEntity, List<TieDataNodeStd>> groupByMatchedRule = this.tieDataNodeStdList.stream().collect(Collectors.groupingBy(TieDataNodeStd::getMatchedRule));
        for (List<TieDataNodeStd> tieDataNodeStds : groupByMatchedRule.values()) {
            List<? extends TieDataNode> attItemValueList = this.doSub(RawTimeBucket.cast(tieDataNodeStds));
            attItemValueList.removeIf(Objects::isNull);
            attItemValueList.forEach(attItemValue -> attItemValue.setParentDataNodes(tieDataNodeStds));
            this.tieDataNodeList.addAll(attItemValueList);
        }
        return TieDataResultStd.success(this.tieDataNodeList);
    }

    private List<? extends TieDataNode> doSub(List<TimeBucketStd> timeBucketList) {
        String subType;
        OtRuleCalConfig matchedRule = timeBucketList.get(0).getMatchedRule(OtRuleCalConfig.class);
        TimeSeqAvailableBo<OtSubConfig> otSubConfig = matchedRule.getMatchOtRuleCalCompenConfig().getOtSubConfig();
        List<Long> attItemList = this.getFilterList(matchedRule.getMatchOtRuleCalCompenConfig().getSubPrjSet());
        LinkedList<AttItemValue> result = new LinkedList<AttItemValue>();
        if (Objects.isNull(otSubConfig) || Objects.isNull(otSubConfig.getVersionByDate(this.chainDate))) {
            logger.debug("Objects.isNull(otSubConfig): {}", otSubConfig);
            for (TimeBucketStd timeBucket : timeBucketList) {
                result.addAll(this.dropUserAttItem(attItemList, timeBucket.getDurationOfSecond(), Collections.singletonList(timeBucket)));
            }
            return result;
        }
        OtSubConfig overtimeSub = (OtSubConfig)otSubConfig.getVersionByDate(this.chainDate);
        switch (subType = overtimeSub.getSubType()) {
            case "B": {
                BigDecimal fixTimes = overtimeSub.getFixTimes().multiply(BigDecimal.valueOf(60L));
                BigDecimal subSeconds = fixTimes.multiply(BigDecimal.valueOf(60L));
                return this.getSubListTime(timeBucketList, attItemList, subSeconds);
            }
            case "C": {
                return this.deductRestTime(overtimeSub, timeBucketList, attItemList);
            }
            case "D": {
                int summary = timeBucketList.stream().map(TimeBucketStd::getDurationOfSecond).reduce(Integer::sum).orElse(0);
                List<OtDeductSubTimeItem> otDeductSubTimeItemList = overtimeSub.getOtDeductSubTimeItemList();
                if (CollectionUtils.isEmpty(otDeductSubTimeItemList)) {
                    return this.getSubList(timeBucketList, attItemList, 0);
                }
                Iterator<OtDeductSubTimeItem> iterator = otDeductSubTimeItemList.iterator();
                if (!iterator.hasNext()) break;
                OtDeductSubTimeItem otDeductSubTimeItem = iterator.next();
                int subSec = otDeductSubTimeItem.getSatisfyHours().multiply(BigDecimal.valueOf(3600L)).intValue();
                if (subSec <= summary) {
                    return this.getSubListTime(timeBucketList, attItemList, otDeductSubTimeItem.getDeductHours().multiply(BigDecimal.valueOf(3600L)));
                }
                return this.getSubListTime(timeBucketList, attItemList, BigDecimal.ZERO);
            }
            case "E": {
                List<OtSubTimeItem> otSubTimeItemList = overtimeSub.getOtSubTimeItemList();
                if (otSubTimeItemList == null) {
                    return Lists.newArrayList();
                }
                return this.subperiod(otSubTimeItemList, timeBucketList, attItemList);
            }
        }
        return result;
    }

    private List<? extends TieDataNode> subperiod(List<OtSubTimeItem> otSubTimeItemList, List<TimeBucketStd> timeBucketList, List<Long> attItemList) {
        ArrayList res = Lists.newArrayListWithCapacity((int)(otSubTimeItemList.size() * 2));
        for (TimeBucketStd timeBucketStd : timeBucketList) {
            if (timeBucketStd.getStartTime() == null || timeBucketStd.getEndTime() == null) {
                res.addAll(this.dropUserAttItem(attItemList, timeBucketStd.getDurationOfSecond(), Collections.singletonList(timeBucketStd)));
                continue;
            }
            List<TimeBucket> nointersections = TimeBucketUtil.noIntersection(otSubTimeItemList, timeBucketStd.unwrapAndCopy(), true, new HashMap<String, Boolean>());
            for (OtSubTimeItem item : otSubTimeItemList) {
                LocalTime end;
                LocalTime start = LocalTime.ofSecondOfDay(item.getBeginTime());
                if (!TimeBucketUtil.hasIntersection(start, end = LocalTime.ofSecondOfDay(item.getEndTime()), (ITimeBucket)timeBucketStd)) continue;
                List<TimeBucket> intersectionRes = TimeBucketUtil.intersectionLocalTime(start, end, timeBucketStd, true);
                if (WTCCollections.isNotEmpty(intersectionRes)) {
                    intersectionRes.forEach(tb -> this.invalTimeBucket((TimeBucket)tb));
                }
                res.addAll(intersectionRes);
            }
            this.subTimeB(nointersections, attItemList);
            res.addAll(nointersections);
        }
        return res;
    }

    private void invalTimeBucket(TimeBucket tb) {
        if (tb == null) {
            return;
        }
        tb.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(tb.getDurationOfSecond()), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate))));
    }

    private void subTimeB(List<TimeBucket> resList, List<Long> subList) {
        for (TimeBucket tb : resList) {
            tb.setAttItemInstances(subList.stream().map(sub -> {
                BigDecimal intervalInSeconds = BigDecimal.valueOf(tb.getDurationOfSecond());
                return InitHelper.createAttItem(this.chainDate, intervalInSeconds, this.shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)sub, this.chainDate));
            }).collect(Collectors.toList()));
        }
    }

    private List<? extends TieDataNode> deductRestTime(OtSubConfig overtimeSub, List<TimeBucketStd> timeBucketList, List<Long> attItemList) {
        ArrayList res = Lists.newArrayListWithCapacity((int)(timeBucketList.size() * 2));
        List collect = this.shiftSpec.getShiftSessions().stream().filter(item -> item.getOutWorkType() == OutWorkType.BREAK).collect(Collectors.toList());
        if (collect == null || collect.isEmpty()) {
            ArrayList<TimeBucket> resList = new ArrayList<TimeBucket>();
            timeBucketList.forEach(tb -> resList.add(tb.unwrapAndCopy()));
            this.subTimeB(resList, attItemList);
            return resList;
        }
        switch (overtimeSub.getSelectSub()) {
            case "1": {
                boolean hasIntersection = false;
                for (TimeBucketStd timeBucket : timeBucketList) {
                    if (!timeBucket.getShiftTimeBucketSeqId().equals(PreDataShiftPeriod.PD_1030_01_01_S)) continue;
                    hasIntersection = true;
                    break;
                }
                if (hasIntersection) {
                    BigDecimal deductTime = overtimeSub.getDesTimes().multiply(BigDecimal.valueOf(3600L));
                    return this.getSubListTime(timeBucketList, attItemList, deductTime);
                }
                return this.getSubListTime(timeBucketList, attItemList, BigDecimal.ZERO);
            }
            case "2": {
                for (TimeBucketStd timeBucket : timeBucketList) {
                    if (ShiftTimeBucketPropertyEnum.REST == timeBucket.getShiftTimeBucketProperty()) {
                        TimeBucket timeBucket1 = timeBucket.unwrapAndCopy();
                        timeBucket1.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(timeBucket1.getDurationOfSecond()), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate))));
                        res.add(timeBucket1);
                        continue;
                    }
                    TimeBucket tb2 = timeBucket.unwrapAndCopy();
                    tb2.setAttItemInstances(attItemList.stream().map(sub -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(tb2.getDurationOfSecond()), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)sub, this.chainDate))).collect(Collectors.toList()));
                    res.add(tb2);
                }
                return res;
            }
            case "4": {
                AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(this.context);
                for (TimeBucketStd timeBucket : timeBucketList) {
                    long otBillId = timeBucket.getAttendanceBillTag().getOtBillId();
                    AttBillTimeBucket attBillTimeBucket = attBillTimeBucketData.getBillTimeBucketById(otBillId);
                    if (attBillTimeBucket != null && ShiftTimeBucketPropertyEnum.REST == timeBucket.getShiftTimeBucketProperty() && TimeBucketUtil.contain(attBillTimeBucket.getStartTime(), attBillTimeBucket.getEndTime(), timeBucket.getStartTime(), timeBucket.getEndTime())) {
                        TimeBucket timeBucket1 = timeBucket.unwrapAndCopy();
                        timeBucket1.setAttItemInstances(Collections.singletonList(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(timeBucket1.getDurationOfSecond()), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate))));
                        res.add(timeBucket1);
                        continue;
                    }
                    TimeBucket tb3 = timeBucket.unwrapAndCopy();
                    tb3.setAttItemInstances(attItemList.stream().map(sub -> InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(tb3.getDurationOfSecond()), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate((long)sub, this.chainDate))).collect(Collectors.toList()));
                    res.add(tb3);
                }
                return res;
            }
        }
        return res;
    }

    private List<AttItemValue> getSubListTime(List<TimeBucketStd> timeBucketList, List<Long> subList, BigDecimal subSeconds) {
        LinkedList<AttItemValue> subBucket = new LinkedList<AttItemValue>();
        if (subSeconds.compareTo(BigDecimal.ZERO) > 0) {
            subBucket.add((AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(InitHelper.createAttItem(this.chainDate, subSeconds, this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate)))).parentDataNodes(timeBucketList.stream().map(TieDataNodeStd.class::cast).collect(Collectors.toList()))).matchedRule(timeBucketList.get(0).getMatchedRule())).evaluationRule(timeBucketList.get(0).getEvaluationRule())).build());
        }
        int duration = 0;
        for (TimeBucketStd tb : timeBucketList) {
            duration += tb.getDurationOfSecond();
        }
        for (Long id : subList) {
            AttItemInstance item = InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(duration).subtract(subSeconds), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(id, this.chainDate));
            subBucket.add((AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(item)).matchedRule(timeBucketList.get(0).getMatchedRule())).evaluationRule(timeBucketList.get(0).getEvaluationRule())).parentDataNodes(timeBucketList.stream().map(TieDataNodeStd.class::cast).collect(Collectors.toList()))).build());
        }
        return subBucket;
    }

    private List<AttItemValue> getSubList(List<TimeBucketStd> timeBucketList, List<Long> subList, int subSeconds) {
        LinkedList<AttItemValue> subBucket = new LinkedList<AttItemValue>();
        for (TimeBucketStd timeBucket : timeBucketList) {
            int duration = timeBucket.getDurationOfSecond();
            if (duration <= subSeconds) {
                subBucket.add((AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(duration), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate)))).parentDataNodes(Collections.singletonList(timeBucket))).matchedRule(timeBucket.getMatchedRule())).evaluationRule(timeBucket.getEvaluationRule())).build());
                subSeconds -= duration;
                continue;
            }
            if (subSeconds != 0) {
                subBucket.add((AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(subSeconds), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OT_INVALID.getBid(), this.chainDate)))).parentDataNodes(Collections.singletonList(timeBucket))).matchedRule(timeBucket.getMatchedRule())).evaluationRule(timeBucket.getEvaluationRule())).build());
            }
            subSeconds = 0;
            subBucket.addAll(this.dropUserAttItem(subList, duration -= subSeconds, Collections.singletonList(timeBucket)));
        }
        return subBucket;
    }

    private List<AttItemValue> dropUserAttItem(List<Long> subList, int seconds, List<TimeBucketStd> parentDateNodes) {
        LinkedList<AttItemValue> attItemInstanceList = new LinkedList<AttItemValue>();
        for (Long id : subList) {
            AttItemInstance item = InitHelper.createAttItem(this.chainDate, BigDecimal.valueOf(seconds), this.shiftTableSingle, this.attItemSpecData.getByBidAndDate(id, this.chainDate));
            attItemInstanceList.add((AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(item)).matchedRule(parentDateNodes.get(0).getMatchedRule())).evaluationRule(parentDateNodes.get(0).getEvaluationRule())).parentDataNodes(parentDateNodes.stream().map(TieDataNodeStd.class::cast).collect(Collectors.toList()))).build());
        }
        return attItemInstanceList;
    }
}

