/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlotcal;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.wtc.wtbs.business.ruleengine.RuleEngineQueryServiceImpl;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaRulePackage;
import kd.wtc.wtes.business.model.rlid.IncrDecrPlan;
import kd.wtc.wtes.business.model.rlid.IncrDecrRule;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class PolicyResultHelp {
    private static final Log logger = LogFactory.getLog(PolicyResultHelp.class);

    public static <T extends AbstractTimeSeqVersion> List<T> getRuleConfigByPolicyResult(RuleEngineEnum ruleEngineEnum, TieContextStd context, TimeSeqVersion planEnty) {
        return PolicyResultHelp.getRuleConfigByPolicyResult(ruleEngineEnum, context, planEnty, "rule");
    }

    public static <T extends AbstractTimeSeqVersion> List<T> getRuleConfigByPolicyResult(RuleEngineEnum ruleEngineEnum, TieContextStd context, TimeSeqVersion planEnty, String ruleKey) {
        RuleParam ruleParam = new RuleParam(ruleEngineEnum.getSceneNumber(), ruleEngineEnum.getBizApp(), planEnty.getId());
        ruleParam.setScenePlanName(ruleEngineEnum.getScenePlanName());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
        logger.debug("{}\u5339\u914d\u7684\u89c4\u5219\u5f15\u64ce\u7ed3\u679c{}", planEnty.getClass(), policyResults);
        Set<Long> ids = RuleEngineService.getRuleIdsByTag(policyResults, ruleKey);
        RuleEngineMetaData ruleEngineMetaData = ContextUtil.getRuleEngineMetaData(context);
        if (CollectionUtils.isEmpty(ids)) {
            logger.info("{}rule is empty", planEnty.getClass());
            return null;
        }
        List collect = ids.stream().map(id -> (AbstractTimeSeqVersion)((TimeSeqBo)ruleEngineMetaData.getBizRuleById((Long)id)).getVersionByDate(context.getChainDate())).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            logger.info("{}rule is empty", planEnty.getClass());
            return null;
        }
        return collect;
    }

    public static Set<Object> getConfigByPolicyResult(RuleEngineEnum ruleEngineEnum, TieContextStd context, TimeSeqVersion planEnty, String tag) {
        RuleParam ruleParam = new RuleParam(ruleEngineEnum.getSceneNumber(), ruleEngineEnum.getBizApp(), planEnty.getId());
        ruleParam.setScenePlanName(ruleEngineEnum.getScenePlanName());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
        logger.debug("{}\u5339\u914d\u7684\u89c4\u5219\u5f15\u64ce\u7ed3\u679c{}", planEnty.getClass(), policyResults);
        Set<Object> ids = RuleEngineService.getEnumsByTag(policyResults, tag);
        ids.remove(null);
        return ids;
    }

    public static boolean isRuleEngineByPlanID(long id) {
        Map ruleSetMap = RuleEngineQueryServiceImpl.getInstance().queryRuleEngineAssociation((List)Lists.newArrayList((Object[])new Long[]{id}));
        return "2".equals(ruleSetMap.get(id));
    }

    public static IncrDecrRule getIncrRuleEngineRule(TieAttPeriodContext tieAttPeriodContext, IncrDecrPlan incrDecrPlan, PerAttPeriod perAttPeriod) {
        RuleParam ruleParam = new RuleParam(RuleEngineEnum.idp.getSceneNumber(), RuleEngineEnum.idp.getBizApp(), incrDecrPlan.getId());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, tieAttPeriodContext, perAttPeriod);
        List<Long> ids = PolicyResultHelp.getIncrDecrRuleIds(policyResults, "wtp_incdecrules");
        RuleEngineMetaData ruleEngineMetaData = tieAttPeriodContext.getRuleEngineMetaData();
        for (Long id : ids) {
            TimeSeqBo bizRuleById = (TimeSeqBo)ruleEngineMetaData.getBizRuleById(id);
            if (null == bizRuleById) continue;
            return (IncrDecrRule)bizRuleById.getVersionByDate(tieAttPeriodContext.getPeriodData(perAttPeriod));
        }
        return null;
    }

    public static FormulaRulePackage getFormulaRuleEngineRule(TieContextStd context, FormulaPlanPackage formulaPlan, LocalDate chainDate) {
        RuleParam ruleParam = new RuleParam(RuleEngineEnum.formula.getSceneNumber(), RuleEngineEnum.formula.getBizApp(), formulaPlan.getTimeSeqInfo().getId());
        ruleParam.setScenePlanName(RuleEngineEnum.formula.getScenePlanName());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
        List<Long> ids = PolicyResultHelp.getIncrDecrRuleIds(policyResults, "wtp_formularule");
        RuleEngineMetaData ruleEngineMetaData = (RuleEngineMetaData)context.getInitParam("RULE_ENGINE");
        for (Long id : ids) {
            TimeSeqBo bizRuleById = (TimeSeqBo)ruleEngineMetaData.getBizRuleById(id);
            if (null == bizRuleById) continue;
            return (FormulaRulePackage)bizRuleById.getVersionByDate(chainDate);
        }
        return null;
    }

    public static FormulaRulePackage getFormulaRuleEngineRule(TieAttPeriodContext tieAttPeriodContext, FormulaPlanPackage formulaPlan, PerAttPeriod perAttPeriod) {
        RuleParam ruleParam = new RuleParam(RuleEngineEnum.formula.getSceneNumber(), RuleEngineEnum.formula.getBizApp(), formulaPlan.getTimeSeqInfo().getId());
        ruleParam.setScenePlanName(RuleEngineEnum.formula.getScenePlanName());
        List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, tieAttPeriodContext, perAttPeriod);
        List<Long> ids = PolicyResultHelp.getIncrDecrRuleIds(policyResults, "wtp_formularule");
        RuleEngineMetaData ruleEngineMetaData = tieAttPeriodContext.getRuleEngineMetaData();
        for (Long id : ids) {
            TimeSeqBo bizRuleById = (TimeSeqBo)ruleEngineMetaData.getBizRuleById(id);
            if (null == bizRuleById) continue;
            return (FormulaRulePackage)bizRuleById.getVersionByDate(tieAttPeriodContext.getPeriodData(perAttPeriod));
        }
        return null;
    }

    public static List<Long> getIncrDecrRuleIds(List<PolicyResult> policyResults, String ruleEntity) {
        LinkedList ruleIds = Lists.newLinkedList();
        for (PolicyResult policyResult : policyResults) {
            if (policyResult.getRuleResults().isEmpty()) {
                Object obj = policyResult.getDefaultResults().get(ruleEntity);
                PolicyResultHelp.parseResultObj(obj, ruleIds);
                continue;
            }
            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                Object obj = ruleResult.getMatchResults().get(ruleEntity);
                PolicyResultHelp.parseResultObj(obj, ruleIds);
            }
        }
        return ruleIds;
    }

    private static void parseResultObj(Object obj, List<Long> ids) {
        if (obj instanceof DynamicObject) {
            ids.add(((DynamicObject)obj).getLong("id"));
        } else if (obj instanceof DynamicObjectCollection) {
            ids.addAll(((DynamicObjectCollection)obj).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        } else if (obj instanceof DynamicObject[]) {
            ids.addAll(Arrays.stream((DynamicObject[])obj).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
    }
}

