/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.rlra.AttItemLabelConfigData;
import kd.wtc.wtes.business.model.rlra.AttItemLabelConfigEntity;
import kd.wtc.wtes.business.service.IAttItemLabelConfigService;
import kd.wtc.wtes.business.service.impl.AttItemLabelConfigServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitializerAttItemLabelRelation
implements TieParamInitializer {
    protected IAttItemLabelConfigService attItemLabelConfigService;

    public TieInitializerAttItemLabelRelation(IAttItemLabelConfigService attItemLabelConfigService) {
        this.attItemLabelConfigService = attItemLabelConfigService;
    }

    public TieInitializerAttItemLabelRelation() {
        this.attItemLabelConfigService = new AttItemLabelConfigServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        LinkedList<Long> warnInfoList = new LinkedList<Long>();
        Map<Long, List<AttItemLabelConfigEntity>> bo2His = this.getAttItemLabelConfigMap(initRequest);
        List<TimeSeqBo<AttItemLabelConfigEntity>> attItemLabelConfigBo = this.listTimeSeqBo(bo2His, warnInfoList);
        AttItemLabelConfigData attItemLabelConfigData = AttItemLabelConfigData.of(attItemLabelConfigBo);
        if (CollectionUtils.isNotEmpty(warnInfoList)) {
            String warnInfo = this.getWarnInfo(warnInfoList);
            return InitParamResult.partial(attItemLabelConfigData, new TieMessageStd(TieMsgLevel.WARNING, warnInfo));
        }
        return InitParamResult.success(attItemLabelConfigData);
    }

    @Override
    public String category() {
        return "ATT_LABEL_RELATION";
    }

    private Map<Long, List<AttItemLabelConfigEntity>> getAttItemLabelConfigMap(InitParam initRequest) {
        List<AttItemLabelConfigEntity> attItemLabelConfigEntityList = this.attItemLabelConfigService.listValidHisVersionsInRangeDate(initRequest.getStartDate(), initRequest.getEndDate());
        if (attItemLabelConfigEntityList.isEmpty()) {
            return Collections.emptyMap();
        }
        return attItemLabelConfigEntityList.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
    }

    private List<TimeSeqBo<AttItemLabelConfigEntity>> listTimeSeqBo(Map<Long, List<AttItemLabelConfigEntity>> bo2His, List<Long> warnInfoList) {
        ArrayList<TimeSeqBo<AttItemLabelConfigEntity>> attItemLabelConfigBo = new ArrayList<TimeSeqBo<AttItemLabelConfigEntity>>(bo2His.size());
        bo2His.forEach((bid, attItemLabelConfig) -> {
            try {
                AttItemLabelConfigEntity attItemLabelConfigEntity = (AttItemLabelConfigEntity)((Object)((Object)attItemLabelConfig.get(0)));
                TimeSeqBo timeSeqBo = attItemLabelConfigEntity.hasTimeSeqInfo() ? TimeSeqBo.ofMultiTimeSeq((Collection)attItemLabelConfig) : TimeSeqBo.ofNonTimeSeq((TimeSeqVersion)attItemLabelConfigEntity);
                attItemLabelConfigBo.add(timeSeqBo);
            }
            catch (Exception e) {
                warnInfoList.add((Long)bid);
            }
        });
        return attItemLabelConfigBo;
    }

    private String getWarnInfo(List<Long> warnInfoList) {
        return "attItemLabelConfigEntity happen exception, key:[" + StringUtils.join(warnInfoList, (String)",") + "]";
    }
}

