/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra.pairtime.core;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.AbstractSplitTimeBucket;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.RawPara;
import kd.wtc.wtes.business.executor.rlra.util.RawTimeUtils;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;
import kd.wtc.wtes.common.pairtime.PairTimeSplitWrapper;
import kd.wtc.wtes.common.pairtime.SourceCode;

public class NonFlexAndNormalPunchCard
extends AbstractSplitTimeBucket {
    @Override
    public void addCardPointCustom(PairTimeSplitWrapper pairTimeSplitWrapper, List<AbstractCardPoint> cardPointList, RawPara rawPara) {
        Date timePointStart = pairTimeSplitWrapper.getTimePointStart();
        Date timePointEnd = pairTimeSplitWrapper.getTimePointEnd();
        if (timePointStart == null && timePointEnd == null) {
            cardPointList.addAll(this.dealAbsent(pairTimeSplitWrapper, rawPara));
        } else if (timePointStart == null || timePointEnd == null) {
            cardPointList.addAll(this.dealAbsent(pairTimeSplitWrapper, rawPara));
        } else {
            cardPointList.addAll(this.dealNormal(pairTimeSplitWrapper, rawPara));
        }
    }

    @Override
    public List<AbstractCardPoint> getCardPointList(PairTimeSplitWrapper pairTimeSplitWrapper, RawPara rawPara) {
        ArrayList<AbstractCardPoint> cardPointList = new ArrayList<AbstractCardPoint>();
        this.addCardPointSupposed(cardPointList, pairTimeSplitWrapper);
        this.addEffectiveCardPoint(pairTimeSplitWrapper, cardPointList);
        return cardPointList;
    }

    @Override
    protected void afterCalculate(List<TimeBucket> timeBuckets, RawPara para) {
    }

    @Override
    protected void addShiftAndNonDutyCardPoint(List<AbstractCardPoint> cardPointList, RawPara rawPara) {
        List<ShiftSession> shiftSessionList = rawPara.roster.getShiftSpec().getShiftSessions();
        shiftSessionList.forEach(session -> {
            LocalDateTime absoluteShiftStartDate = session.getAbsoluteShiftStartDate(WTCDateUtils.toLocalDate((Date)rawPara.caculDate));
            LocalDateTime absoluteShiftEndDate = session.getAbsoluteShiftEndDate(WTCDateUtils.toLocalDate((Date)rawPara.caculDate));
            if (OutWorkType.CORE_TIME == session.getOutWorkType()) {
                this.addCoreTimeCardPoint(cardPointList, absoluteShiftStartDate, absoluteShiftEndDate);
            } else if (OutWorkType.BREAK == session.getOutWorkType()) {
                this.addRestCardPoints(cardPointList, absoluteShiftStartDate, absoluteShiftEndDate);
            } else if (OutWorkType.OT == session.getOutWorkType()) {
                this.addOverTimeCardPoint(cardPointList, absoluteShiftStartDate, absoluteShiftEndDate);
            } else if (OutWorkType.WORK == session.getOutWorkType()) {
                this.addWorkTimeCardPoint(cardPointList, absoluteShiftStartDate, absoluteShiftEndDate);
            }
        });
    }

    private void addWorkTimeCardPoint(List<AbstractCardPoint> cardPointList, LocalDateTime absoluteShiftStartDate, LocalDateTime absoluteShiftEndDate) {
        cardPointList.add(new AbstractCardPoint(49, WTCDateUtils.toDate((LocalDateTime)absoluteShiftStartDate), SourceCode.SHIFT_CARD));
    }

    private void addOverTimeCardPoint(List<AbstractCardPoint> cardPointList, LocalDateTime absoluteShiftStartDate, LocalDateTime absoluteShiftEndDate) {
        cardPointList.add(new AbstractCardPoint(43, WTCDateUtils.toDate((LocalDateTime)absoluteShiftStartDate), SourceCode.SHIFT_CARD));
        cardPointList.add(new AbstractCardPoint(44, WTCDateUtils.toDate((LocalDateTime)absoluteShiftEndDate), SourceCode.SHIFT_CARD));
    }

    private void addRestCardPoints(List<AbstractCardPoint> cardPointList, LocalDateTime absoluteShiftStartDate, LocalDateTime absoluteShiftEndDate) {
        cardPointList.add(new AbstractCardPoint(14, WTCDateUtils.toDate((LocalDateTime)absoluteShiftStartDate), SourceCode.SHIFT_CARD));
        cardPointList.add(new AbstractCardPoint(15, WTCDateUtils.toDate((LocalDateTime)absoluteShiftEndDate), SourceCode.SHIFT_CARD));
    }

    private void addCoreTimeCardPoint(List<AbstractCardPoint> cardPointList, LocalDateTime absoluteShiftStartDate, LocalDateTime absoluteShiftEndDate) {
        cardPointList.add(new AbstractCardPoint(17, WTCDateUtils.toDate((LocalDateTime)absoluteShiftStartDate), SourceCode.SHIFT_CARD));
        cardPointList.add(new AbstractCardPoint(18, WTCDateUtils.toDate((LocalDateTime)absoluteShiftEndDate), SourceCode.SHIFT_CARD));
    }

    private void addEffectiveCardPoint(PairTimeSplitWrapper pairTimeSplitWrapper, List<AbstractCardPoint> cardPointList) {
        Date timePointStart = pairTimeSplitWrapper.getTimePointStart();
        Date timePointEnd = pairTimeSplitWrapper.getTimePointEnd();
        cardPointList.add(new AbstractCardPoint(this.getPointType(timePointStart, pairTimeSplitWrapper, 1), timePointStart, SourceCode.EFFECT_CARD, 1));
        cardPointList.add(new AbstractCardPoint(this.getPointType(timePointEnd, pairTimeSplitWrapper, 2), timePointEnd, SourceCode.EFFECT_CARD, 2));
    }

    private void addCardPointSupposed(List<AbstractCardPoint> cardPointList, PairTimeSplitWrapper pairTimeSplitWrapper) {
        Date cardPointSupposedStart = pairTimeSplitWrapper.getCardPointSupposedStart();
        Date cardPointSupposedEnd = pairTimeSplitWrapper.getCardPointSupposedEnd();
        Date timePointStart = pairTimeSplitWrapper.getTimePointStart();
        Date timePointEnd = pairTimeSplitWrapper.getTimePointEnd();
        cardPointList.add(new AbstractCardPoint(this.getSupposedPointType(cardPointSupposedStart, timePointStart, 1), cardPointSupposedStart, SourceCode.CARD_SUPPOSED_IN));
        cardPointList.add(new AbstractCardPoint(this.getSupposedPointType(cardPointSupposedEnd, timePointEnd, 2), cardPointSupposedEnd, SourceCode.CARD_SUPPOSED_OUT));
    }

    @Override
    protected List<AbstractCardPoint> getCardPointListOfAbsent(PairTimeSplitWrapper pairTimeSplitWrapper, RawPara rawPara) {
        ArrayList<AbstractCardPoint> cardPointList = new ArrayList<AbstractCardPoint>();
        this.addCardPointSupposedAbsent(cardPointList, pairTimeSplitWrapper);
        this.addEffectiveCardPointAbsent(pairTimeSplitWrapper, cardPointList);
        return cardPointList;
    }

    private void addCardPointSupposedAbsent(List<AbstractCardPoint> cardPointList, PairTimeSplitWrapper pairTimeSplitWrapper) {
        Date cardPointSupposedStart = pairTimeSplitWrapper.getCardPointSupposedStart();
        Date cardPointSupposedEnd = pairTimeSplitWrapper.getCardPointSupposedEnd();
        Date timePointStart = pairTimeSplitWrapper.getTimePointStart();
        Date timePointEnd = pairTimeSplitWrapper.getTimePointEnd();
        cardPointList.add(new AbstractCardPoint(this.getSupposedPointTypeOfAbsent(timePointStart, timePointEnd, 1), cardPointSupposedStart, SourceCode.CARD_SUPPOSED_IN));
        cardPointList.add(new AbstractCardPoint(this.getSupposedPointTypeOfAbsent(timePointStart, timePointEnd, 2), cardPointSupposedEnd, SourceCode.CARD_SUPPOSED_OUT));
    }

    private void addEffectiveCardPointAbsent(PairTimeSplitWrapper pairTimeSplitWrapper, List<AbstractCardPoint> cardPointList) {
        int pointTypeOfAbsent;
        Date cardPointSupposedStart = pairTimeSplitWrapper.getCardPointSupposedStart();
        Date cardPointSupposedEnd = pairTimeSplitWrapper.getCardPointSupposedEnd();
        Date timePointStart = pairTimeSplitWrapper.getTimePointStart();
        Date timePointEnd = pairTimeSplitWrapper.getTimePointEnd();
        if (timePointStart != null) {
            pointTypeOfAbsent = this.getPointTypeOfAbsent(timePointStart, cardPointSupposedStart, 1);
            if (37 == pointTypeOfAbsent) {
                cardPointList.add(new AbstractCardPoint(pointTypeOfAbsent, timePointStart, SourceCode.CARD_AND_SHIFT));
            } else {
                cardPointList.add(new AbstractCardPoint(pointTypeOfAbsent, timePointStart, SourceCode.EFFECT_CARD));
            }
        }
        if (timePointEnd != null) {
            pointTypeOfAbsent = this.getPointTypeOfAbsent(timePointEnd, cardPointSupposedEnd, 2);
            if (38 == pointTypeOfAbsent) {
                cardPointList.add(new AbstractCardPoint(pointTypeOfAbsent, timePointEnd, SourceCode.CARD_AND_SHIFT));
            } else {
                cardPointList.add(new AbstractCardPoint(pointTypeOfAbsent, timePointEnd, SourceCode.EFFECT_CARD));
            }
        }
    }

    @Override
    public void dealNonTimeBill(List<AbstractCardPoint> cardPointList, AttBillTimeBucket bill) {
        throw new WtesBizException(ValiteKDStringUtil.notSupportNonTimeBill(RawTimeUtils.getBillTypeName(bill.getBillTypeBig()), bill.getNumber()));
    }
}

