/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra.pairtime.core;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.NonFlexAndNormalPunchCard;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.RawPara;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.LogicCard;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.model.rlra.CardExceptionTypeEnum;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPunchCardRelationEnum;
import kd.wtc.wtes.business.model.rlra.TimeSeqCounter;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.common.enums.BillNonPlanEnum;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;
import kd.wtc.wtes.common.pairtime.PairTimeSplitWrapper;
import kd.wtc.wtes.common.pairtime.SourceCode;

public class OffShift
extends NonFlexAndNormalPunchCard {
    private static final BigDecimal HOUR_SECONDS = BigDecimal.valueOf(3600L);

    @Override
    protected void addShiftAndDutyCardPoint(RawPara rawPara, List<PairTimeSplitWrapper> pairTimeSplitWrapperList, List<AbstractCardPoint> cardPointList) {
        if (rawPara.roster.getShiftSpec().getOffNonPlan()) {
            List<LogicCard> logicCardDataList = rawPara.logicCardDataList;
            cardPointList.addAll(this.getNonTimePoint(logicCardDataList));
        } else {
            super.addShiftAndDutyCardPoint(rawPara, pairTimeSplitWrapperList, cardPointList);
        }
    }

    private List<AbstractCardPoint> getNonTimePoint(List<LogicCard> logicCardDataList) {
        ArrayList<AbstractCardPoint> cardPointList = new ArrayList<AbstractCardPoint>(4);
        if (!logicCardDataList.isEmpty()) {
            if (logicCardDataList.size() == 1) {
                cardPointList.add(new AbstractCardPoint(48, WTCDateUtils.toDate((LocalDateTime)logicCardDataList.get(0).getEffectiveCardPoint()), SourceCode.EFFECT_CARD));
            } else if (logicCardDataList.size() == 2) {
                logicCardDataList.sort(Comparator.comparing(LogicCard::getEffectiveCardPoint));
                cardPointList.add(new AbstractCardPoint(29, WTCDateUtils.toDate((LocalDateTime)logicCardDataList.get(0).getEffectiveCardPoint()), SourceCode.EFFECT_CARD));
                cardPointList.add(new AbstractCardPoint(30, WTCDateUtils.toDate((LocalDateTime)logicCardDataList.get(1).getEffectiveCardPoint()), SourceCode.EFFECT_CARD));
            }
        }
        return cardPointList;
    }

    @Override
    public void dealNonTimeBill(List<AbstractCardPoint> cardPointList, AttBillTimeBucket bill) {
        AbstractCardPoint nonTimePoint = "OT".equals(bill.getBillTypeBig()) ? new AbstractCardPoint(45, NON_TIME_POINT, SourceCode.NONE) : ("VA".equals(bill.getBillTypeBig()) ? new AbstractCardPoint(46, NON_TIME_POINT, SourceCode.NONE) : new AbstractCardPoint(47, NON_TIME_POINT, SourceCode.NONE));
        nonTimePoint.setBillTime(bill.getDuration());
        nonTimePoint.setBillNonPlan(bill.getBillNonPlan());
        if ("OT".equals(bill.getBillTypeBig())) {
            nonTimePoint.setBillId(bill.getId());
        } else {
            nonTimePoint.setBillId(bill.getBillId());
        }
        nonTimePoint.setBillType(bill.getBillType());
        nonTimePoint.setBillEntryId(bill.getId());
        cardPointList.add(nonTimePoint);
    }

    @Override
    protected List<TimeBucket> dealNonTimePoint(List<AbstractCardPoint> allTimePoint, TieContextStd context, RawPara para) {
        ArrayList<TimeBucket> timeBucketList = new ArrayList<TimeBucket>(6);
        for (int i = allTimePoint.size() - 1; i >= 0; --i) {
            AbstractCardPoint cardPoint = allTimePoint.get(i);
            if (cardPoint.getTimePoint() != NON_TIME_POINT) continue;
            TimeBucket timeBucket = this.genNewNoneTimeBucket(cardPoint, context, para);
            timeBucketList.add(timeBucket);
            allTimePoint.remove(i);
        }
        return timeBucketList;
    }

    private TimeBucket genNewNoneTimeBucket(AbstractCardPoint cardPoint, TieContextStd context, RawPara para) {
        ShiftSpec shiftSpec = para.roster.getShiftSpec();
        int timeIntervalInSeconds = 0;
        if (cardPoint.getBillNonPlan() == BillNonPlanEnum.HALF_DAY) {
            timeIntervalInSeconds = shiftSpec.getAlldayhour().multiply(HOUR_SECONDS).intValue() / 2;
        } else if (cardPoint.getBillNonPlan() == BillNonPlanEnum.ALL_DAY) {
            timeIntervalInSeconds = shiftSpec.getAlldayhour().multiply(HOUR_SECONDS).intValue();
        } else if (cardPoint.getBillNonPlan() == BillNonPlanEnum.SELF_DURATION) {
            timeIntervalInSeconds = cardPoint.getBillTime().intValue();
        }
        CardExceptionTypeEnum cardExceptionType = this.getCardExceptionType(para);
        AttendanceBillTag attendanceBillTag = this.getAttendanceBillTag(cardPoint);
        return (TimeBucket)((CleanableBuilder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)TimeBucket.builder().shiftTimeBucketProperty(ShiftTimeBucketPropertyEnum.NON_PLAN_TIME)).timeBucketPosition(TimeBucketPositionEnum.NON_PLAN_TIME)).timeBucketPunchCardRelation(TimeBucketPunchCardRelationEnum.NON_TIME)).startTimePointSource(cardPoint.getSource().getSourceCode())).endTimePointSource(cardPoint.getSource().getSourceCode())).timeIntervalInSeconds(timeIntervalInSeconds)).shiftTimeBucketSeqId(TimeSeqCounter.NON_TIME_SEQ_ID)).originalDate(WTCDateUtils.toLocalDate((Date)para.caculDate))).roster(para.roster)).attMode(para.attMode)).attendanceBillTag(attendanceBillTag)).cardExceptionType(cardExceptionType)).build();
    }

    private AttendanceBillTag getAttendanceBillTag(AbstractCardPoint cardPoint) {
        AttendanceBillTag billTag = AttendanceBillTag.NOSTATUSTAG;
        if (45 == cardPoint.getPointType()) {
            billTag = billTag.addOverTimeStatus(cardPoint);
        } else if (46 == cardPoint.getPointType()) {
            billTag = billTag.addVacationStatus(cardPoint);
        } else if (47 == cardPoint.getPointType()) {
            billTag = billTag.addBusinessStatus(cardPoint);
        }
        return billTag;
    }

    private CardExceptionTypeEnum getCardExceptionType(RawPara para) {
        List<LogicCard> logicCardDataList = para.logicCardDataList;
        CardExceptionTypeEnum exceptionTypeEnum = CardExceptionTypeEnum.UNKNOWN;
        if (logicCardDataList.isEmpty()) {
            exceptionTypeEnum = CardExceptionTypeEnum.ABSENT;
        } else if (logicCardDataList.size() == 1) {
            exceptionTypeEnum = CardExceptionTypeEnum.OUT_ABSENT;
        } else if (logicCardDataList.size() == 2) {
            exceptionTypeEnum = CardExceptionTypeEnum.NORMAL;
        }
        return exceptionTypeEnum;
    }

    @Override
    protected void afterCalculate(List<TimeBucket> timeBuckets, RawPara para) {
        if (para.roster.getShiftSpec().getOffNonPlan()) {
            this.dealAllDayBillState(timeBuckets, para);
        }
    }

    private void dealAllDayBillState(List<TimeBucket> timeBuckets, RawPara para) {
        String vaState;
        int vaSeconds = 0;
        int tlSeconds = 0;
        for (TimeBucket timeBucket : timeBuckets) {
            AttendanceBillTag attendanceBillTag = timeBucket.getAttendanceBillTag();
            if (attendanceBillTag.isOnVacation()) {
                vaSeconds += timeBucket.getDurationOfSecond();
            }
            if (!attendanceBillTag.isOnBusiness()) continue;
            tlSeconds += timeBucket.getDurationOfSecond();
        }
        BigDecimal allDayHour = para.roster.getShiftSpec().getAlldayhour();
        int allDaySeconds = allDayHour.multiply(HOUR_SECONDS).intValue();
        if (vaSeconds == 0) {
            vaState = "0";
        } else {
            String string = vaState = vaSeconds >= allDaySeconds ? "2" : "1";
        }
        String tlState = tlSeconds == 0 ? "0" : (tlSeconds >= allDaySeconds ? "2" : "1");
        for (TimeBucket timeBucket : timeBuckets) {
            timeBucket.setAbsenceBillState(vaState);
            timeBucket.setTravelBillState(tlState);
        }
    }
}

