/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra.pairtime.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.AbstractSplitTimeBucket;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.RawPara;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.SplitStrategyFactory;
import kd.wtc.wtes.business.executor.rlra.util.RawTimeUtils;
import kd.wtc.wtes.business.init.LogicCardData;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.LogicCard;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.TimeZone;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;
import kd.wtc.wtes.common.lang.WtesException;

public class RawTimeBucketService {
    private static final Log logger = LogFactory.getLog(RawTimeBucketService.class);

    public List<TimeBucket> calculate(TieContextStd context, LocalDate shiftDate) {
        return this.dealCalculOfOneDay(context, shiftDate);
    }

    private List<TimeBucket> dealCalculOfOneDay(TieContextStd context, LocalDate shiftDate) {
        long attPersonId = context.getAttPersonId();
        ShiftTableSingle personalShiftTable = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shift = personalShiftTable.getShiftSpec(shiftDate);
        Roster roster = personalShiftTable.getRoster(shiftDate);
        AttFileModel attFile = ContextUtil.getAttFile(context, shiftDate);
        logger.debug("attFile-> {},attPersonId->{}", (Object)attFile, (Object)attPersonId);
        if (shift == null || attFile == null || attFile.getAttMode(shiftDate) == null) {
            if (this.isOutOfTimeRangeOneDay(context, shiftDate)) {
                return Collections.emptyList();
            }
            logger.warn("Could not find ShiftSpec of shiftDate [{}], roster={}, ShiftTableSingle={}", new Object[]{shiftDate, roster, personalShiftTable});
            if (shift == null) {
                throw new WtesException(ValiteKDStringUtil.noShift(shiftDate));
            }
            throw new WtesException(ValiteKDStringUtil.noAttMode(shiftDate));
        }
        String attModeNumber = attFile.getAttModeMust(shiftDate).getCode();
        logger.debug("shift->{},attMode->{}", (Object)shift, (Object)attModeNumber);
        LogicCardData logicCardData = ContextUtil.getLogicCardData(context);
        List<LogicCard> logicCardDataList = logicCardData.getByAttPersonIdAndDate(attPersonId, shiftDate);
        if (null != logicCardDataList) {
            if (logger.isDebugEnabled()) {
                logger.debug("shiftDate [{}],attPersonId [{}],logicCardDataList->{}", new Object[]{shiftDate, attPersonId, logicCardDataList});
            }
        } else {
            logicCardDataList = new ArrayList<LogicCard>();
            logger.info("logicCardDataList->null");
        }
        logicCardDataList = this.switchTimeZone(logicCardDataList, attFile.getTimeZone(shiftDate), shiftDate);
        AbstractSplitTimeBucket splitTimeBucket = SplitStrategyFactory.getSplitStrategy(shift.getShiftType().code, attModeNumber, shift.isOff());
        RawPara rawPara = new RawPara(WTCDateUtils.toDate((LocalDate)shiftDate), roster, logicCardDataList, attModeNumber);
        return splitTimeBucket.calculate(context, rawPara);
    }

    private List<LogicCard> switchTimeZone(List<LogicCard> logicCardDataList, TimeZone attFileTimeZone, LocalDate shiftDate) {
        if (attFileTimeZone == null) {
            throw new WtesException(ValiteKDStringUtil.noTimeZone(shiftDate));
        }
        if (logicCardDataList.isEmpty() || logicCardDataList.get(0).getTimeZoneId().equals(attFileTimeZone.getTimeZoneId())) {
            return logicCardDataList;
        }
        ArrayList switchTimeZoneList = Lists.newArrayListWithExpectedSize((int)logicCardDataList.size());
        int attFileTimeZoneDiff = attFileTimeZone.getTimeDiff();
        for (LogicCard logicCard : logicCardDataList) {
            int timeDiff = logicCard.getTimeDiff();
            LocalDateTime localDateTime = logicCard.getEffectiveCardPoint().minusHours(timeDiff - attFileTimeZoneDiff);
            switchTimeZoneList.add(new LogicCard(logicCard.getAttPersonId(), localDateTime, logicCard.getCardPointSupposed()));
        }
        return switchTimeZoneList;
    }

    private boolean isOutOfTimeRangeOneDay(TieContextStd context, LocalDate shiftDate) {
        LocalDate currentDate = context.getAttSubjectEntry().getCurrentDate();
        return RawTimeUtils.isBeginDate(context) && shiftDate.equals(currentDate.plusDays(-1L)) || RawTimeUtils.isEndDate(context) && shiftDate.equals(currentDate.plusDays(1L));
    }
}

