/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra.pairtime.core;

import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.AbstractSplitTimeBucket;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.FlexAndCoreTime;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.FlexAndNonCoreTime;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.NonFlexAndNormalPunchCard;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.OffShift;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.PunchCardFree;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.PunchCardFreeAndOffShift;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.PunchCardOnce;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.PunchCardOnceAndOffShift;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.ShiftSplitTrial;

public class SplitStrategyFactory {
    private static final Log logger = LogFactory.getLog(SplitStrategyFactory.class);

    public static AbstractSplitTimeBucket getSplitStrategy(String shiftType, String mode, boolean isOff) {
        if (isOff) {
            if (AttModeEnum.ONES_CARD.getCode().equals(mode)) {
                return SingletonPunchCardOnceAndOffShift.PUNCH_CARD_ONCE_AND_OFF_SHIFT_INSTANCE;
            }
            if (AttModeEnum.NO_CARD.getCode().equals(mode)) {
                return SingletonPunchCardFreeAndOffShift.PUNCH_CARD_FREE_AND_OFF_SHIFT_INSTANCE;
            }
            return SingletonOffShift.OFF_SHIFT_INSTANCE;
        }
        if (AttModeEnum.MANY_CARD.getCode().equals(mode)) {
            if ("A".equals(shiftType)) {
                return SingletonNonFlexAndNormalPunchCard.NON_FLEX_AND_NORMAL_PUNCH_CARD_INSTANCE;
            }
            if ("B".equals(shiftType)) {
                return SingletonFlexAndNonCoreTime.FLEX_AND_NON_CORE_TIME_INSTANCE;
            }
            if ("C".equals(shiftType)) {
                return SingletonFlexAndCoreTime.FLEX_AND_CORE_TIME_INSTANCE;
            }
        } else {
            if (AttModeEnum.ONES_CARD.getCode().equals(mode)) {
                return SingletonPunchCardOnce.PUNCH_CARD_ONCE_INSTANCE;
            }
            if (AttModeEnum.NO_CARD.getCode().equals(mode)) {
                return SingletonPunchCardFree.PUNCH_CARD_FREE_INSTANCE;
            }
            if ("4".equals(mode)) {
                return SingletonShiftSplitTrial.SHIFT_SPLIT_TRIAL_INSTANCE;
            }
        }
        logger.warn("wrong scene , shiftType:{},mode:{}", (Object)shiftType, (Object)mode);
        throw new KDBizException("wrong scene ");
    }

    private static class SingletonShiftSplitTrial {
        private static final ShiftSplitTrial SHIFT_SPLIT_TRIAL_INSTANCE = new ShiftSplitTrial();

        private SingletonShiftSplitTrial() {
        }
    }

    private static class SingletonPunchCardFree {
        private static final PunchCardFree PUNCH_CARD_FREE_INSTANCE = new PunchCardFree();

        private SingletonPunchCardFree() {
        }
    }

    private static class SingletonPunchCardFreeAndOffShift {
        private static final PunchCardFreeAndOffShift PUNCH_CARD_FREE_AND_OFF_SHIFT_INSTANCE = new PunchCardFreeAndOffShift();

        private SingletonPunchCardFreeAndOffShift() {
        }
    }

    private static class SingletonPunchCardOnceAndOffShift {
        private static final PunchCardOnceAndOffShift PUNCH_CARD_ONCE_AND_OFF_SHIFT_INSTANCE = new PunchCardOnceAndOffShift();

        private SingletonPunchCardOnceAndOffShift() {
        }
    }

    private static class SingletonPunchCardOnce {
        private static final PunchCardOnce PUNCH_CARD_ONCE_INSTANCE = new PunchCardOnce();

        private SingletonPunchCardOnce() {
        }
    }

    private static class SingletonFlexAndCoreTime {
        private static final FlexAndCoreTime FLEX_AND_CORE_TIME_INSTANCE = new FlexAndCoreTime();

        private SingletonFlexAndCoreTime() {
        }
    }

    private static class SingletonFlexAndNonCoreTime {
        private static final FlexAndNonCoreTime FLEX_AND_NON_CORE_TIME_INSTANCE = new FlexAndNonCoreTime();

        private SingletonFlexAndNonCoreTime() {
        }
    }

    private static class SingletonNonFlexAndNormalPunchCard {
        private static final NonFlexAndNormalPunchCard NON_FLEX_AND_NORMAL_PUNCH_CARD_INSTANCE = new NonFlexAndNormalPunchCard();

        private SingletonNonFlexAndNormalPunchCard() {
        }
    }

    private static class SingletonOffShift {
        private static final OffShift OFF_SHIFT_INSTANCE = new OffShift();

        private SingletonOffShift() {
        }
    }
}

