/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlra.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.ConfigMix;
import kd.wtc.wtes.business.model.rlra.AttItemLabelConfigData;
import kd.wtc.wtes.business.model.rlra.AttStatusConfigData;
import kd.wtc.wtes.business.model.rlra.PunchCardTagData;
import kd.wtc.wtes.business.model.rlra.TimeBucketLabelEnum;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;

public class AttendItemUtils {
    private static final char OFF_FLAG_TRUE = '1';
    private static final char OFF_FLAG_FALSE = '2';
    private static final String SPLIT_VERTICAL = "\\|";
    private static final char COLON = ':';

    public static List<TimeBucket> attendItemCalStd(TieContextStd context, List<TimeBucketStd> timeBucketStdList) {
        ArrayList<TimeBucket> timeBucketList = new ArrayList<TimeBucket>(timeBucketStdList.size());
        for (TimeBucketStd timeBucket : timeBucketStdList) {
            TimeBucket copy = (TimeBucket)((TimeBucket.Builder)timeBucket.unwrapAndCopy().toBuilder().appendParentDataNode(timeBucket)).build();
            timeBucketList.add(copy);
        }
        return AttendItemUtils.attendItemCal(context, timeBucketList);
    }

    public static List<TimeBucket> attendItemCal(TieContextStd context, List<TimeBucket> timeBucketList) {
        AttItemLabelConfigData attItemLabelConfigData = ContextUtil.getAttItemLabelConfigData(context);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        ConfigMix configMix = ContextUtil.getConfigMix(context);
        LocalDate chainDate = context.getChainDate();
        Long configVersion = configMix.getAttitemmap();
        for (TimeBucket timeBucket : timeBucketList) {
            AttendItemUtils.dealMappingByRawTimeBucket(timeBucket, context);
            StringBuilder dateTypeSb = new StringBuilder();
            if (null != timeBucket.getDateAttribute()) {
                dateTypeSb.append(timeBucket.getDateAttribute().code);
                dateTypeSb.append(':');
                if (null != timeBucket.getShiftSpec() && timeBucket.getShiftSpec().isOff()) {
                    dateTypeSb.append('1');
                } else {
                    dateTypeSb.append('2');
                }
            }
            List<String> attItemLableList = attItemLabelConfigData.getAttItemLabelListByParam(configVersion, chainDate, timeBucket.getAttendanceStatuses(), timeBucket.getShiftTimeBucketProperty().code, dateTypeSb.toString());
            AttendItemUtils.dealTimeBucketAttItemMapping(attItemLableList, chainDate, timeBucket, attItemSpecData);
        }
        return timeBucketList;
    }

    private static void dealTimeBucketAttItemMapping(List<String> attItemLableList, LocalDate chainDate, TimeBucket timeBucket, AttItemSpecData attItemSpecData) {
        ArrayList<AttItemInstance> attItemInstances = new ArrayList<AttItemInstance>(10);
        ArrayList<String> labelList = new ArrayList<String>(10);
        if (null != attItemLableList && !attItemLableList.isEmpty()) {
            HashSet<String> attItemSet = new HashSet<String>();
            HashSet<String> labelSet = new HashSet<String>();
            for (String str : attItemLableList) {
                String[] itemArr;
                String[] arr = str.split(SPLIT_VERTICAL);
                if (arr.length != 2) continue;
                for (String itemStr : itemArr = arr[0].split(",")) {
                    if (!attItemSet.add(itemStr)) continue;
                    attItemInstances.add(new AttItemInstance(null != attItemSpecData.getByNumberAndDate(itemStr, chainDate) ? attItemSpecData.getByNumberAndDate(itemStr, chainDate) : attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OTHER.getBid(), chainDate), null, timeBucket.getDurationOfDay(), BigDecimal.valueOf(timeBucket.getDurationOfSecond()), null));
                }
                labelSet.add(arr[1]);
            }
            labelList.addAll(labelSet);
        } else {
            attItemInstances.add(new AttItemInstance(attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.OTHER.getBid(), chainDate), null, timeBucket.getDurationOfDay(), BigDecimal.valueOf(timeBucket.getDurationOfSecond()), null));
            labelList.add(TimeBucketLabelEnum.OTHER.getNumber());
        }
        ((CleanableBuilder)((TimeBucket.Builder)timeBucket.toBuilder().timeBucketLabelList(labelList)).attItemInstances(attItemInstances)).build();
    }

    private static void dealMappingByRawTimeBucket(TimeBucket timeBucket, TieContextStd context) {
        ConfigMix configMix = ContextUtil.getConfigMix(context);
        PunchCardTagData punchCardTagData = ContextUtil.getPunchCardTagData(context);
        String punchCardTag = punchCardTagData.getPunchCardTagByParam(configMix.getTbpcrelcnf(), context.getChainDate(), timeBucket.getTimeBucketPunchCardRelation().code, timeBucket.getShiftTimeBucketProperty().code, timeBucket.getCardExceptionType().code);
        timeBucket.toBuilder().punchCardTag(punchCardTag);
        AttStatusConfigData attStatusConfigData = ContextUtil.getAttStatusConfigData(context);
        timeBucket.toBuilder().attendanceStatusList(attStatusConfigData.getAttStatusListByTags(configMix.getAttstsmap(), context.getChainDate(), punchCardTag, timeBucket.getAttendanceBillTag().toNumberList()));
    }
}

