/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rltl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.sdk.wtc.wtes.business.tie.exexutor.tvl.TvlCustomTimeBucket;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlotcal.PolicyResultHelp;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.TbAttPackage;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEnum;
import kd.wtc.wtes.business.model.rltl.TravelEntry;
import kd.wtc.wtes.business.model.rltl.TravelRule;
import kd.wtc.wtes.business.service.impl.AccessServiceImpl;
import kd.wtc.wtes.business.service.impl.DateRangeServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.enums.CardViewDesignerEnum;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TravelParamEvaluator
implements TieEvaluatorStd {
    private static final Log logger = LogFactory.getLog(TravelParamEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, null);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        logger.debug("travel evaluator start,personId=[{}],chainDate=[{}]", (Object)attPersonId, (Object)chainDate);
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        TbAttPackage travelPlan = attFileModel.getAttTbPackage(chainDate);
        if (travelPlan == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format("There is no travelPlan exists for attPersonId=%s, chainDate=%s", attPersonId, chainDate)));
        }
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        List<TravelRule> efficientTravelRuleList = this.getEfficientTravelRuleList(chainDate, travelPlan, context);
        if (efficientTravelRuleList == null || efficientTravelRuleList.isEmpty()) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format("There is no travelRule exists for attPersonId=%s, chainDate=%s", attPersonId, chainDate)));
        }
        List<TimeBucket> dataNodesCluster = this.getTimeBucketStdClusterByRule(context, efficientTravelRuleList, chainDate, shiftTableSingle, attItemSpecData);
        List<TimeBucket> timeBucketList = this.customTime(context, dataNodesCluster, shiftTableSingle, chainDate);
        dataNodesCluster.addAll(timeBucketList);
        return TieDataResultStd.success(dataNodesCluster);
    }

    private List<TimeBucket> customTime(TieContextStd context, List<TimeBucket> dataNodesCluster, ShiftTableSingle shiftTableSingle, LocalDate chainDate) {
        ArrayList<TimeBucket> timeBucketList = new ArrayList<TimeBucket>(dataNodesCluster.size());
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        for (TimeBucket timeBucket : dataNodesCluster) {
            AttItemSpec tvlCustomAttItemSpec;
            boolean startDateIsHoliDay;
            LocalDateTime startTime = timeBucket.getStartTime();
            LocalDateTime endTime = timeBucket.getEndTime();
            boolean bl = startTime == null ? DateAttribute.HOLIDAY == shiftTableSingle.getDateAttribute(chainDate) : (startDateIsHoliDay = DateAttribute.HOLIDAY == shiftTableSingle.getDateAttribute(startTime.toLocalDate()));
            boolean endDateIsHoliDay = endTime == null ? DateAttribute.HOLIDAY == shiftTableSingle.getDateAttribute(chainDate) : DateAttribute.HOLIDAY == shiftTableSingle.getDateAttribute(endTime.toLocalDate());
            TvlCustomTimeBucket tvlCustomTimeBucket = new TvlCustomTimeBucket(startTime, endTime, startDateIsHoliDay, endDateIsHoliDay);
            tvlCustomTimeBucket.setAttItemId(0L);
            WTCPluginProxy pluginProxy = (WTCPluginProxy)ContextExtUtil.getExtPlugin(context, "kd.sdk.wtc.wtes.business.tie.exexutor.tvl.TvlEvaluatorExpService");
            pluginProxy.invokeReplace(tvlEvaluatorExpService -> tvlEvaluatorExpService.tvlCustomTime(tvlCustomTimeBucket));
            if (Objects.isNull(tvlCustomTimeBucket) || Objects.isNull(tvlCustomTimeBucket.getAttItemId())) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("tvlCustomTimeBucket is null");
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("tvlCustomTimeBucket startTime:{},endTime:{},attItemId:{}", new Object[]{tvlCustomTimeBucket.getStartTime(), tvlCustomTimeBucket.getEndTime(), tvlCustomTimeBucket.getAttItemId()});
            }
            if (tvlCustomTimeBucket.getAttItemId() == 0L || (tvlCustomAttItemSpec = attItemSpecData.getByBidAndDate(tvlCustomTimeBucket.getAttItemId(), chainDate)) == null) continue;
            TimeBucket bucket = timeBucket.clone();
            bucket.setStartTime(tvlCustomTimeBucket.getStartTime());
            bucket.setEndTime(tvlCustomTimeBucket.getEndTime());
            bucket.setTimeIntervalInSeconds(tvlCustomTimeBucket.getTbSecond().intValue());
            AttItemInstance attItem = InitHelper.createAttItem(chainDate, BigDecimal.valueOf(bucket.getDurationOfSecond()), shiftTableSingle, tvlCustomAttItemSpec);
            bucket.setAttItemInstances(Collections.singletonList(attItem));
            timeBucketList.add(bucket);
        }
        return timeBucketList;
    }

    private List<TravelRule> getEfficientTravelRuleList(LocalDate chainDate, TbAttPackage travelPlan, TieContextStd context) {
        if (!CollectionUtils.isEmpty(travelPlan.getTravelRuleBoList())) {
            ArrayList<TravelRule> result = new ArrayList<TravelRule>(travelPlan.getTravelRuleBoList().size());
            for (TimeSeqBo<TravelRule> ruleTimeSeqBo : travelPlan.getTravelRuleBoList()) {
                TravelRule rule = ruleTimeSeqBo != null ? (TravelRule)ruleTimeSeqBo.getVersionByDate(chainDate) : null;
                if (null == rule) continue;
                result.add(rule);
            }
            if (CollectionUtils.isNotEmpty(result)) {
                return result;
            }
        }
        return PolicyResultHelp.getRuleConfigByPolicyResult(RuleEngineEnum.tp, context, travelPlan);
    }

    private List<TimeBucket> getTimeBucketStdClusterByRule(TieContextStd context, List<TravelRule> efficientTravelRuleList, LocalDate chainDate, ShiftTableSingle shiftTableSingle, AttItemSpecData specData) {
        LinkedList<TimeBucket> result = new LinkedList<TimeBucket>();
        AccessServiceImpl accessService = (AccessServiceImpl)WTCAppContextHelper.getBean(AccessServiceImpl.class);
        List<TieDataNodeStd> timeBucketStdList = context.getRawTimeBuckets();
        BizDataSource travelDataSource = ContextUtil.getConfigMix(context).getDataSource(BizTypeEnum.BUSINESS);
        if (travelDataSource == null) {
            logger.debug("TravelParamEvaluator.getTimeBucketStdClusterByRule travelDataSource is null");
            return Collections.emptyList();
        }
        List<TieDataNodeStd> matchedRuleDNSList = accessService.accessFilterByCondition(timeBucketStdList, travelDataSource.getCondition());
        if (logger.isDebugEnabled()) {
            logger.debug("\u901a\u8fc7\u6570\u636e\u6e90\u8fc7\u6ee4\u540e\u7684\u65f6\u95f4\u5bf9{}", (Object)matchedRuleDNSList.size());
        }
        Map<Long, List<TieDataNodeStd>> map = matchedRuleDNSList.stream().collect(Collectors.groupingBy(tbs -> ((TimeBucketStd)tbs).getAttendanceBillTag().getTlBillTypeId()));
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        if (CollectionUtils.isNotEmpty(efficientTravelRuleList)) {
            TravelRule rule = efficientTravelRuleList.get(0);
            context.setVariable("WTES_TVL_RULE_PARAM", rule, VScope.CHAIN);
            Map<Long, AttfileLimitScope> limitScopeMap = ContextUtil.getLimitScopeMap(context);
            AttfileLimitScopeServiceImpl attfileLimitScopeService = new AttfileLimitScopeServiceImpl();
            List legalRuleEntrys = rule.getTravelEntries().stream().filter(entry -> attfileLimitScopeService.matchLimit((AttfileLimitScope)limitScopeMap.get(context.getAttSubjectEntry().getAttFileVid()), entry.getLimitScope())).collect(Collectors.toList());
            for (TravelEntry travelEntry : legalRuleEntrys) {
                Long tarTravelTypeId = travelEntry.getTravelType().getId();
                List<TieDataNodeStd> filterDataNodes = map.get(tarTravelTypeId);
                if (CollectionUtils.isEmpty(filterDataNodes)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u901a\u8fc7\u51fa\u5dee\u7c7b\u578b\u8fc7\u6ee4\u540e\u7684\u65f6\u95f4\u5bf9{}", (Object)filterDataNodes.size());
                }
                filterDataNodes = filterDataNodes.stream().filter(tieDataNodeStd -> TravelParamEvaluator.filter(travelEntry.getTimeSource(), (ITimeBucket)((Object)tieDataNodeStd))).collect(Collectors.toList());
                List timeBuckets = dateRangeService.filterDataNodes(WTCDateRangeSource.TP, context, filterDataNodes.stream().map(TimeBucketStd.class::cast).collect(Collectors.toList()), travelEntry.getDateConditionAccessDto()).stream().peek(timeBucket -> {
                    timeBucket.setMatchedRule((IEntity)travelEntry);
                    LinkedList<AttItemInstance> attItemInstances = new LinkedList<AttItemInstance>();
                    AttItemInstance attItem = InitHelper.createAttItem(chainDate, BigDecimal.valueOf(timeBucket.getDurationOfSecond()), shiftTableSingle, attItemSpecData.getByBidAndDate(travelEntry.getOriAtt(), chainDate));
                    attItemInstances.add(attItem);
                    timeBucket.setAttItemInstances(attItemInstances);
                }).collect(Collectors.toList());
                result.addAll(timeBuckets);
            }
        }
        return result;
    }

    private static boolean filter(Long dataSource, ITimeBucket next) {
        CardViewDesignerEnum cardViewEnum = CardViewDesignerEnum.from((Long)dataSource);
        switch (cardViewEnum) {
            case WORKBILL: {
                return next.getAttendanceBillTag().isOnBusiness();
            }
            case CARDPOINT: {
                return next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code);
            }
            case WORKMIXEDCARD: {
                return next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code) && next.getAttendanceBillTag().isOnBusiness();
            }
            case WORKUNIONOFF: {
                return next.getPunchCardTag().contains(PunchCardTagEnum.NORMAL.code) || next.getAttendanceBillTag().isOnBusiness();
            }
        }
        return false;
    }
}

