/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rltl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rltl.TravelExtHelper;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.RawTimeBucket;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.rltl.TravelEntry;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.RoundRuleService;

public class TravelRoundEvaluator
implements TieEvaluatorStd {
    private static final Log logger = LogFactory.getLog(TravelRoundEvaluator.class);
    private static final BigDecimal INVALID = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final int SECOND_IN_MIN = 60;

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        return this.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        long attPersonId = context.getAttPersonId();
        LocalDate chainDate = context.getChainDate();
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        Map<Long, RoundWrapper> roundWrapperMap = ContextUtil.getRoundWrapperMap(context);
        Map<TravelEntry, List<TimeBucketStd>> timeBucketCluster = RawTimeBucket.sorted(dataNodes).getTimeBuckets().stream().collect(Collectors.groupingBy(std -> (TravelEntry)std.getMatchedRule()));
        if (timeBucketCluster.isEmpty()) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u65f6\u95f4\u5bf9,attPersonId=%1$s, chainDate=%2$s", (String)"OtCommonEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[]{attPersonId, chainDate})));
        }
        ShiftSpec shiftSpec = ContextUtil.getShiftSpec(context);
        ArrayList<AttItemValue> result = new ArrayList<AttItemValue>(timeBucketCluster.size());
        if (logger.isDebugEnabled()) {
            logger.debug("\u820d\u5165\u7b2c\u4e00\u6b65\u6570\u636e{}", JSON.toJSON(timeBucketCluster));
        }
        for (Map.Entry<TravelEntry, List<TimeBucketStd>> entry : timeBucketCluster.entrySet()) {
            TravelEntry travelEntry = entry.getKey();
            int sumValue = entry.getValue().stream().map(TimeBucketStd::getDurationOfSecond).reduce(Integer::sum).orElse(0);
            BigDecimal effectTime = BigDecimal.valueOf(sumValue);
            RoundWrapper roundWrapper = roundWrapperMap.get(travelEntry.getRoundWrapper());
            if (roundWrapper != null) {
                AttItemSpec roundSpec = attItemSpecData.getByBidAndDate(travelEntry.getRoundAtt(), chainDate);
                logger.debug("\u820d\u5165\u524d\u7684\u503c\uff1a{}\uff0c\u820d\u5165\u7684\u9879\u76ee\uff1a{}\uff0c\u73ed\u6b21\uff1a{}", new Object[]{effectTime, roundSpec.getId(), shiftSpec.getId()});
                effectTime = RoundRuleService.roundValue(roundWrapper, effectTime, roundSpec, shiftSpec);
            }
            logger.debug("\u8ba1\u7b97\u89c4\u5219{};\u820d\u5165\u540e\u7684\u503c{}", (Object)travelEntry.getId(), (Object)effectTime);
            if (INVALID.compareTo(effectTime) == 0) continue;
            AttItemValue effectAttItemValue = (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(context.getDataNodesOfPrevStepExecutor())).attItemInstance(InitHelper.createAttItem(chainDate, effectTime, shiftTableSingle, attItemSpecData.getByBidAndDate(travelEntry.getRoundAtt(), chainDate)))).build();
            result.add(effectAttItemValue);
            AttItemValue invalidAttItemValue = (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(context.getDataNodesOfPrevStepExecutor())).attItemInstance(InitHelper.createAttItem(chainDate, BigDecimal.valueOf(sumValue).subtract(effectTime), shiftTableSingle, attItemSpecData.getByBidAndDate(OverworkAttendanceEnum.TL_INVALID.getBid(), chainDate)))).build();
            result.add(invalidAttItemValue);
        }
        List<AttItemValue> attItemValues = TravelExtHelper.afterExecBusinessTrip(context, result);
        result.addAll(attItemValues);
        return TieDataResultStd.success(result);
    }
}

