/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlva;

import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.executor.rlva.VaCalHelper;
import kd.wtc.wtes.business.executor.rlva.VaExtHelper;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlva.VaCalculateRule;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.AttItemValueStd;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class VaDeductEvaluator
implements TieEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(VaDeductEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        LOG.debug("\u8fdb\u5165\u4f11\u5047\u62b5\u6263\u8ba1\u7b97\u903b\u8f91{}", (Object)context.getRawTimeBuckets().size());
        if (VaCalHelper.checkEmpty(context)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaDeductEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        return this.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaDeductEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        List attStd = dataNodes.stream().map(AttItemValueStd.class::cast).collect(Collectors.toList());
        LinkedList<AttItemValue> result = new LinkedList<AttItemValue>();
        LocalDate chainDate = context.getChainDate();
        List dropResultStdList = attStd.stream().filter(std -> {
            VaCalculateRule vaCalculateRule = std.getMatchedRule(VaCalculateRule.class);
            return vaCalculateRule != null && !Objects.equals((Object)ContextUtil.getAttItemSpecData(context).getByBidAndDate(OverworkAttendanceEnum.VA_ROUNDED_DIFF.getBid(), chainDate), (Object)std.getAttItemInstance().getAttItemSpec());
        }).collect(Collectors.toList());
        for (AttItemValueStd std2 : dropResultStdList) {
            AttItemValue value = std2.unwrapAndCopy();
            AttItemValue attItemValue = (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(new AttItemInstance(ContextUtil.getAttItemSpecData(context).getByBidAndDate(value.getMatchedRule(VaCalculateRule.class).getResultId(), context.getChainDate()), value.getAttItemInstance().getItemValue(), value.getAttItemInstance().getDay(), value.getAttItemInstance().getSecondDecimal(), null))).evaluationRule(EvaluationRuleModel.of(value.getMatchedRule(VaCalculateRule.class).getId(), "wtp_varule"))).parentDataNodes(Collections.singletonList(std2))).build();
            result.add(attItemValue);
        }
        List<AttItemValue> attItemValues = VaExtHelper.afterExecVacation(context, result);
        result.addAll(attItemValues);
        return TieDataResultStd.success(result);
    }
}

