/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlva;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.bill.IAttfileLimitScopeService;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.executor.rlva.VaCalHelper;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.RawTimeBucket;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.VaAttPackage;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.model.rlva.VaCalculateRule;
import kd.wtc.wtes.business.model.rlva.VaRulePackage;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.business.service.impl.AccessServiceImpl;
import kd.wtc.wtes.business.service.impl.DateRangeServiceImpl;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class VaParamEvaluator
implements TieEvaluatorStd {
    private static final TieDataResultStd VA_EXCLUSION = TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, VaParamEvaluator.getWarnMsg1()));
    private static final TieDataResultStd VA_NO_PLAN_EXCLUSION = TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, VaParamEvaluator.getWarnMsg2()));
    private static final Log LOG = LogFactory.getLog(VaParamEvaluator.class);

    private static String getWarnMsg1() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaParamEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
    }

    private static String getWarnMsg2() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u65e5\u671f\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u6709\u6548\u65b9\u6848\u3002", (String)"VaParamEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        LOG.debug("\u8fdb\u5165\u4f11\u5047\u53c2\u6570\u8ba1\u7b97\u903b\u8f91{}", (Object)context.getRawTimeBuckets().size());
        if (VaCalHelper.checkEmpty(context)) {
            return VA_EXCLUSION;
        }
        List<TieDataNodeStd> rawTimeBuckets = context.getRawTimeBuckets();
        return this.doEvaluate(context, rawTimeBuckets);
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return VA_EXCLUSION;
        }
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        AttFileModel attFileModel = ContextUtil.getCurrentAttFile(context);
        VaAttPackage attVaPackage = attFileModel.getAttVaPackage(chainDate);
        if (attVaPackage == null) {
            return VA_NO_PLAN_EXCLUSION;
        }
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        RawTimeBucket rawTimeBucket = RawTimeBucket.sorted(dataNodes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u4f11\u5047\u53c2\u6570\u8ba1\u7b97\u903b\u8f91,\u5165\u53c2\u65f6\u95f4\u5bf9{},\u6838\u7b97\u4eba{},\u6838\u7b97\u65f6\u95f4{}", new Object[]{rawTimeBucket.getTimeBuckets().toString(), attPersonId, chainDate});
        }
        try {
            List<TimeBucket> timeBuckets = this.dealParam(context, attVaPackage, rawTimeBucket, attItemSpecData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u4f11\u5047\u53c2\u6570\u8ba1\u7b97\u903b\u8f91\u7ed3\u675f\uff0c\u8fd4\u56de\u65f6\u95f4\u5bf9{},\u6838\u7b97\u4eba{},\u6838\u7b97\u65f6\u95f4{}", new Object[]{timeBuckets.toString(), attPersonId, chainDate});
            }
            return TieDataResultStd.success(timeBuckets);
        }
        catch (Exception ex) {
            if (ex instanceof WtesBizException) {
                throw ex;
            }
            LOG.warn("\u8003\u52e4\u6838\u7b97\u5f02\u5e38\uff0c \u5f02\u5e38\u4fe1\u606f", (Throwable)ex);
            throw new WtesBizException(ex.getMessage());
        }
    }

    public List<TimeBucket> dealParam(TieContextStd context, VaAttPackage attVaPackage, RawTimeBucket rawTimeBucket, AttItemSpecData attItemSpecData) {
        List<TimeBucket> tieDataNodeStdList = this.filterDatasource(context, attVaPackage, rawTimeBucket);
        for (TimeBucket timeBucket : tieDataNodeStdList) {
            AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(timeBucket.getMatchedRule(VaCalculateRule.class).getOriginId(), context.getChainDate());
            ArrayList<AttItemInstance> attItemInstances = new ArrayList<AttItemInstance>(16);
            attItemInstances.add(InitHelper.createAttItem(context.getChainDate(), timeBucket.getDurationOfSecond(), ContextUtil.getCurrentShiftTable(context), attItemSpec));
            timeBucket.setAttItemInstances(attItemInstances);
        }
        return tieDataNodeStdList;
    }

    private List<TimeBucket> filterDatasource(TieContextStd context, VaAttPackage attVaPackage, RawTimeBucket rawTimeBucket) {
        LocalDate chainDate = context.getChainDate();
        TimeSeqBo<VaRulePackage> vaRuleTimeBo = attVaPackage.getVaRule();
        VaRulePackage vaRule = null;
        if (vaRuleTimeBo != null) {
            vaRule = (VaRulePackage)vaRuleTimeBo.getVersionByDate(chainDate);
        }
        if (HRStringUtils.equalsIgnoreCase((String)"2", (String)attVaPackage.getRuleWay())) {
            RuleParam ruleParam = new RuleParam(RuleEngineEnum.vp.getSceneNumber(), RuleEngineEnum.vp.getBizApp(), attVaPackage.getId());
            ruleParam.setScenePlanName(RuleEngineEnum.vp.getScenePlanName());
            List<PolicyResult> policyResults = RuleEngineService.callRuleEngine(ruleParam, context);
            List<Long> ids = this.getRuleIds(policyResults, "rule");
            RuleEngineMetaData ruleEngineMetaData = ContextUtil.getRuleEngineMetaData(context);
            Optional<VaRulePackage> optionRule = ids.stream().map(id -> (VaRulePackage)((TimeSeqBo)ruleEngineMetaData.getBizRuleById((Long)id)).getVersionByDate(chainDate)).filter(Objects::nonNull).findFirst();
            if (optionRule.isPresent()) {
                vaRule = optionRule.get();
            }
        }
        if (vaRule == null) {
            String errorMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f11\u5047\u89c4\u5219\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaParamEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]);
            throw new WtesBizException(errorMsg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("vaRule:{} number:{}", (Object)vaRule.getId(), (Object)vaRule.getNumber());
        }
        context.setVariable("WTES_VA_RULE_PARAM", vaRule, VScope.CHAIN);
        ArrayList<TimeBucket> allDataNodes = new ArrayList<TimeBucket>(10);
        List<TieDataNodeStd> dataNodeStdList = rawTimeBucket.getTimeBuckets().stream().map(TieDataNodeStd.class::cast).collect(Collectors.toList());
        BizDataSource dataSource = ContextUtil.getConfigMix(context).getDataSource(BizTypeEnum.VA);
        List<TimeBucketStd> vaStdDateNodes = null;
        if (Objects.nonNull(dataSource)) {
            AccessServiceImpl accessService = (AccessServiceImpl)WTCAppContextHelper.getBean(AccessServiceImpl.class);
            vaStdDateNodes = accessService.accessFilterByCondition(dataNodeStdList, dataSource.getCondition()).stream().map(TimeBucketStd.class::cast).collect(Collectors.toList());
        } else {
            vaStdDateNodes = rawTimeBucket.getTimeBuckets();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u901a\u8fc7\u6570\u636e\u6e90\u8fc7\u6ee4\u540e\u7684\u65f6\u95f4\u5bf9{}", vaStdDateNodes);
        }
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        Map<Long, AttfileLimitScope> limitScopeMap = ContextUtil.getLimitScopeMap(context);
        AttfileLimitScopeServiceImpl attfileLimitScopeService = new AttfileLimitScopeServiceImpl();
        List<VaCalculateRule> vaCalculateRules = vaRule.getVaCalculateRules();
        if (LOG.isDebugEnabled()) {
            LOG.debug("before matchLimit.vaCalculateRules is :{}", (Object)vaCalculateRules.size());
        }
        vaCalculateRules = vaCalculateRules.stream().filter(arg_0 -> VaParamEvaluator.lambda$filterDatasource$1((IAttfileLimitScopeService)attfileLimitScopeService, limitScopeMap, context, arg_0)).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("after matchLimit.vaCalculateRules is :{}", (Object)vaCalculateRules.size());
        }
        for (VaCalculateRule ruleEntry : vaCalculateRules) {
            List<TimeBucket> timeBuckets = dateRangeService.filterDataNodes(WTCDateRangeSource.VP, context, vaStdDateNodes, ruleEntry.getDateConditionAccessDto());
            if (LOG.isDebugEnabled()) {
                LOG.debug("filter by dateRangeService result {}", timeBuckets);
            }
            for (TimeBucket timeBucket : timeBuckets) {
                if (TimeBucketPositionEnum.IN_SHIFT != timeBucket.getTimeBucketPosition() && TimeBucketPositionEnum.NON_PLAN_TIME != timeBucket.getTimeBucketPosition() || !Long.valueOf(ruleEntry.getVaTypeId()).equals(timeBucket.getAttendanceBillTag().getVaBillTypeId())) continue;
                timeBucket.setMatchedRule(ruleEntry);
                allDataNodes.add(timeBucket);
            }
        }
        return allDataNodes;
    }

    private List<Long> getRuleIds(List<PolicyResult> policyResults, String ruleEntity) {
        LinkedList ruleIds = Lists.newLinkedList();
        for (PolicyResult policyResult : policyResults) {
            if (policyResult.getRuleResults().isEmpty()) {
                Object obj = policyResult.getDefaultResults().get(ruleEntity);
                this.parseResultObj(obj, ruleIds);
                continue;
            }
            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                Object obj = ruleResult.getMatchResults().get(ruleEntity);
                this.parseResultObj(obj, ruleIds);
            }
        }
        return ruleIds;
    }

    private void parseResultObj(Object obj, List<Long> ids) {
        if (obj instanceof DynamicObject) {
            ids.add(((DynamicObject)obj).getLong("id"));
        } else if (obj instanceof DynamicObjectCollection) {
            ids.addAll(((DynamicObjectCollection)obj).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        } else if (obj instanceof DynamicObject[]) {
            ids.addAll(Arrays.stream((DynamicObject[])obj).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
    }

    private static /* synthetic */ boolean lambda$filterDatasource$1(IAttfileLimitScopeService attfileLimitScopeService, Map limitScopeMap, TieContextStd context, VaCalculateRule varuleEntry) {
        return attfileLimitScopeService.matchLimit((AttfileLimitScope)limitScopeMap.get(context.getAttSubjectEntry().getAttFileVid()), varuleEntry.getLimitJson());
    }
}

