/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.rlva;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.executor.rlva.VaCalHelper;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.RawTimeBucket;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.rlva.VaBaseSetPackage;
import kd.wtc.wtes.business.model.rlva.VaCalculateRule;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.chain.TieEvaluatorStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.constants.TimeConstants;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class VaShiftCalendarEvaluator
implements TieEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(VaShiftCalendarEvaluator.class);

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context) {
        LOG.debug("\u8fdb\u5165\u4f11\u5047\u73ed\u6b21/\u65e5\u5386\u5929\u8f6c\u6362\u8ba1\u7b97\u903b\u8f91{}", (Object)context.getRawTimeBuckets().size());
        if (VaCalHelper.checkEmpty(context)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaRoundEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        return this.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    @Override
    public TieDataResultStd doEvaluate(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4f11\u5047\u76f8\u5173\u7684\u65f6\u95f4\u5bf9\u3002", (String)"VaRoundEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        LOG.debug("context.getVersion:{}", (Object)context.getVersion());
        List<TieDataNode> result = this.dealShiftCalendar(context, dataNodes);
        return TieDataResultStd.success(result);
    }

    private List<TieDataNode> dealShiftCalendar(TieContextStd context, List<TieDataNodeStd> dataNodes) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        List<TimeBucketStd> rawTimeBuckets = RawTimeBucket.cast(dataNodes);
        AttBillTimeBucketData attBillTimeBucketData = ContextUtil.getAttBillTimeBucketData(context);
        for (TimeBucketStd timeBucketStd : rawTimeBuckets) {
            long entryId = timeBucketStd.getAttendanceBillTag().getVaBillEntryId();
            AttBillTimeBucket billTimeBucketById = attBillTimeBucketData.getBillTimeBucketById(entryId);
            DynamicObject vaBillDyn = billTimeBucketById.getVaBillDyn();
            if (vaBillDyn == null) {
                LOG.warn("[dealShiftCalendar]\u672a\u83b7\u53d6\u5230\u4f11\u5047\u5355\uff0c\u8df3\u8fc7\u6b65\u9aa4\uff1a{}", (Object)JSON.toJSONString((Object)billTimeBucketById));
                continue;
            }
            AttItemValue tieDataNodes = this.calBillTimes(context, timeBucketStd, vaBillDyn, entryId);
            result.add(tieDataNodes);
        }
        return result;
    }

    private AttItemValue calBillTimes(TieContextStd context, TimeBucketStd timeBucketStd, DynamicObject vaApplyDyn, long entryId) {
        VaCalculateRule rule = timeBucketStd.getMatchedRule(VaCalculateRule.class);
        LocalDate chainDate = context.getChainDate();
        if (rule == null) {
            LOG.warn("\u672a\u627e\u5230\u4f11\u5047\u65f6\u95f4\u5bf9\u5bf9\u5e94\u7684\u4f11\u5047\u89c4\u5219\u4fe1\u606f\uff0cchainDate:{}", (Object)chainDate);
            String errorMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f11\u5047\u65f6\u95f4\u5bf9\u5bf9\u5e94\u7684\u4f11\u5047\u89c4\u5219\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaShiftCalendarEvaluator_4", (String)"wtc-wtes-business", (Object[])new Object[0]);
            throw new WtesBizException(new ErrorCode("EX_VA_006", errorMsg), new Object[0]);
        }
        TimeSeqBo<VaBaseSetPackage> vaBaseSetPackageTimeSeqBo = rule.getVaBaseSetPackageTimeSeqBo();
        VaBaseSetPackage vaBaseSetVersion = (VaBaseSetPackage)vaBaseSetPackageTimeSeqBo.getVersionByDate(chainDate);
        if (vaBaseSetVersion == null) {
            LOG.warn("\u672a\u627e\u5230\u4f11\u5047\u65f6\u95f4\u5bf9\u5bf9\u5e94\u7684\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u4fe1\u606f\uff0cchainDate:{}, rule:{}", (Object)chainDate, (Object)rule.getNumber());
            String errorMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f11\u5047\u65f6\u95f4\u5bf9\u5bf9\u5e94\u7684\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaShiftCalendarEvaluator_5", (String)"wtc-wtes-business", (Object[])new Object[0]);
            throw new WtesBizException(new ErrorCode("EX_VA_007", errorMsg), new Object[0]);
        }
        String timeCalcType = vaBaseSetVersion.getTimeCalcType();
        DynamicObject entry = this.getEntryDyn(vaApplyDyn, entryId);
        long attItemId = rule.getTimeByShiftItemId();
        LocalDate shiftDate = timeBucketStd.getShiftDate();
        ShiftTableSingle currentShiftTable = ContextUtil.getCurrentShiftTable(context);
        ShiftSpec shiftSpec = currentShiftTable.getShiftSpec(shiftDate);
        BigDecimal secondDecimal = shiftSpec.getOffNonPlan() ? BigDecimal.valueOf(timeBucketStd.getDurationOfSecond()) : (StringUtils.equals((CharSequence)"A", (CharSequence)timeCalcType) ? this.calcShiftBillTime(shiftDate, shiftSpec, entry, vaBaseSetVersion, timeBucketStd) : this.calcCalendarTime(shiftDate, shiftSpec, entry, vaBaseSetVersion, timeBucketStd));
        AttItemValue attItemValue = (AttItemValue)((AttItemValue.Builder)((AttItemValue.Builder)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(new AttItemInstance(ContextUtil.getAttItemSpecData(context).getByBidAndDate(attItemId, chainDate), secondDecimal, shiftSpec.secondsToDays(secondDecimal), secondDecimal, null))).evaluationRule(EvaluationRuleModel.of(rule.getId(), "wtp_varule"))).parentDataNodes(Lists.newArrayList((Object[])new TieDataNodeStd[]{timeBucketStd}))).matchedRule(rule)).build();
        return attItemValue;
    }

    private BigDecimal calcShiftBillTime(LocalDate shiftDate, ShiftSpec shiftSpec, DynamicObject entry, VaBaseSetPackage vaBaseSet, TimeBucketStd timeBucketStd) {
        String specialVaType = entry.getString("specialvatype");
        boolean wholeDay = this.isWholeDay(entry, shiftDate);
        boolean isCustom = StringUtils.equals((CharSequence)entry.getString("entrystartmethod"), (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value);
        boolean isLactation = StringUtils.equals((CharSequence)specialVaType, (CharSequence)"A");
        if (isLactation || isCustom || wholeDay) {
            int durationOfSecond = timeBucketStd.getDurationOfSecond();
            return BigDecimal.valueOf(durationOfSecond);
        }
        LocalDate endLocalDate = WTCDateUtils.toLocalDate((Date)entry.getDate("entryenddate"));
        boolean isHalfUp = endLocalDate.equals(shiftDate) && StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (CharSequence)entry.getString("entryendmethod"));
        return this.calcShiftHalf(shiftDate, timeBucketStd, shiftSpec, isHalfUp, vaBaseSet);
    }

    private BigDecimal calcShiftHalf(LocalDate shiftDate, TimeBucketStd timeBucketStd, ShiftSpec shiftSpec, boolean isHalfUp, VaBaseSetPackage vaBaseSet) {
        String halfDayType = vaBaseSet.getHalfDayType();
        boolean halfTypeSplitTime = StringUtils.equals((CharSequence)halfDayType, (CharSequence)"A");
        int durationOfSecond = timeBucketStd.getDurationOfSecond();
        if (halfTypeSplitTime) {
            return BigDecimal.valueOf(durationOfSecond);
        }
        long standardHalfSeconds = this.getStandardHalfSeconds(shiftDate, shiftSpec, isHalfUp, vaBaseSet.isContainOverTime());
        if (standardHalfSeconds == 0L) {
            return BigDecimal.ZERO;
        }
        Integer standardTime = shiftSpec.getStandardTime();
        if (!vaBaseSet.isContainOverTime()) {
            standardTime = standardTime - shiftSpec.getOtTime();
        }
        LOG.debug("calcShiftHalf.shiftDate:{}, oTtime:{}, standartTime:{}, durationOfSecond:{}, standardHalfSeconds:{}", new Object[]{shiftDate, shiftSpec.getOtTime(), shiftSpec.getStandardTime(), durationOfSecond, standardHalfSeconds});
        return BigDecimal.valueOf(durationOfSecond).multiply(BigDecimal.valueOf(standardTime.intValue())).divide(BigDecimal.valueOf(standardHalfSeconds * 2L), 10, RoundingMode.HALF_UP);
    }

    private long getStandardHalfSeconds(LocalDate shiftDate, ShiftSpec shiftSpec, boolean halfUp, boolean containOvertime) {
        List<ShiftSession> shiftSessions = shiftSpec.getShiftSessions();
        ShiftMiddleRule shiftMiddleRule = shiftSpec.getShiftMiddleRule();
        int middlepoint = shiftMiddleRule.getMiddlepoint();
        RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
        LocalDateTime middleDate = LocalDateTime.of(shiftDate, LocalTime.ofSecondOfDay(middlepoint));
        if (middleRefDate == RefDateType.NEXTDAY) {
            middleDate = middleDate.plusDays(1L);
        } else if (middleRefDate == RefDateType.LASTDAY) {
            middleDate = middleDate.plusDays(-1L);
        }
        long durationInSeconds = 0L;
        for (ShiftSession shiftSession : shiftSessions) {
            OutWorkType outWorkType = shiftSession.getOutWorkType();
            if (OutWorkType.BREAK == outWorkType || !containOvertime && OutWorkType.OT == outWorkType) continue;
            LocalDateTime absoluteShiftStartDate = shiftSession.getAbsoluteShiftStartDate(shiftDate);
            LocalDateTime absoluteShiftEndDate = shiftSession.getAbsoluteShiftEndDate(shiftDate);
            if (halfUp) {
                if (!absoluteShiftEndDate.isAfter(middleDate)) {
                    durationInSeconds += (long)shiftSession.getDurationInSeconds();
                    continue;
                }
                if (!absoluteShiftStartDate.isBefore(middleDate)) break;
                durationInSeconds += (long)WTCDateUtils.calcDuringSecond((LocalDateTime)absoluteShiftStartDate, (LocalDateTime)middleDate);
                continue;
            }
            if (!absoluteShiftStartDate.isBefore(middleDate)) {
                durationInSeconds += (long)shiftSession.getDurationInSeconds();
                continue;
            }
            if (!absoluteShiftEndDate.isAfter(middleDate)) continue;
            durationInSeconds += (long)WTCDateUtils.calcDuringSecond((LocalDateTime)middleDate, (LocalDateTime)absoluteShiftEndDate);
        }
        return durationInSeconds;
    }

    private BigDecimal calcCalendarTime(LocalDate shiftDate, ShiftSpec shiftSpec, DynamicObject entry, VaBaseSetPackage vaBaseSet, TimeBucketStd timeBucketStd) {
        boolean isCustom = StringUtils.equals((CharSequence)entry.getString("entrystartmethod"), (CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value);
        String specialVaType = entry.getString("specialvatype");
        boolean isLactation = StringUtils.equals((CharSequence)specialVaType, (CharSequence)"A");
        int durationOfSecond = timeBucketStd.getDurationOfSecond();
        boolean isWholeDay = this.isWholeDay(entry, shiftDate);
        BigDecimal allDayHour = shiftSpec.getShiftMiddleRule().getAlldayhour();
        BigDecimal allDaySeconds = allDayHour.multiply(TimeConstants.SECOND_OF_ONE_HOUR_DECIMAL);
        if (isWholeDay || isLactation || isCustom) {
            Integer standardTime = shiftSpec.getStandardTime();
            return BigDecimal.valueOf(durationOfSecond).multiply(allDaySeconds).divide(BigDecimal.valueOf(standardTime.intValue()), 10, RoundingMode.HALF_UP);
        }
        LocalDate endLocalDate = WTCDateUtils.toLocalDate((Date)entry.getDate("entryenddate"));
        boolean isHalfUp = endLocalDate.equals(shiftDate) && StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (CharSequence)entry.getString("entryendmethod"));
        long standardHalfSeconds = this.getStandardHalfSeconds(shiftDate, shiftSpec, isHalfUp, true);
        if (standardHalfSeconds == 0L) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(durationOfSecond).multiply(allDaySeconds).divide(BigDecimal.valueOf(standardHalfSeconds * 2L), 10, RoundingMode.HALF_UP);
    }

    private boolean isWholeDay(DynamicObject entry, LocalDate shiftDate) {
        Date entryStartDate = entry.getDate("entrystartdate");
        Date entryEndDate = entry.getDate("entryenddate");
        String startMethod = entry.getString("entrystartmethod");
        String endMethod = entry.getString("entryendmethod");
        LocalDate startLocalDate = WTCDateUtils.toLocalDate((Date)entryStartDate);
        LocalDate endLocalDate = WTCDateUtils.toLocalDate((Date)entryEndDate);
        String specialVaType = entry.getString("specialvatype");
        if (StringUtils.equals((CharSequence)specialVaType, (CharSequence)"A")) {
            return false;
        }
        if (StringUtils.equalsAny((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence[])new CharSequence[]{startMethod, endMethod})) {
            return false;
        }
        if (shiftDate.isAfter(endLocalDate) || shiftDate.isBefore(startLocalDate)) {
            return false;
        }
        if (shiftDate.equals(startLocalDate) && StringUtils.equals((CharSequence)startMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
            return false;
        }
        return !shiftDate.equals(endLocalDate) || !StringUtils.equals((CharSequence)endMethod, (CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value);
    }

    private DynamicObject getEntryDyn(DynamicObject vaApplyDyn, long entryId) {
        DynamicObjectCollection vaApplyEntryDyns = vaApplyDyn.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> billEntryMap = vaApplyEntryDyns.stream().collect(Collectors.toMap(dynamicObject -> (Long)dynamicObject.getPkValue(), dyn -> dyn));
        DynamicObject entry = billEntryMap.get(entryId);
        if (entry == null) {
            List entrys = vaApplyEntryDyns.stream().filter(vaApplyEntryDyn -> {
                DynamicObjectCollection detailEntry = vaApplyEntryDyn.getDynamicObjectCollection("vadetailentry");
                List detailIds = detailEntry.stream().map(detail -> (Long)detail.getPkValue()).collect(Collectors.toList());
                return detailIds.contains(entryId);
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(entrys)) {
                entry = (DynamicObject)entrys.get(0);
            } else {
                LOG.warn("\u672a\u627e\u5230\u4f11\u5047\u65f6\u95f4\u5bf9\u5bf9\u5e94\u7684\u4f11\u5047\u5355\u636e\u4fe1\u606f\uff0centryId:{}", (Object)entryId);
                String errorMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f11\u5047\u65f6\u95f4\u5bf9\u5bf9\u5e94\u7684\u4f11\u5047\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VaShiftCalendarEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0]);
                throw new WtesBizException(new ErrorCode("EX_VA_005", errorMsg), new Object[0]);
            }
        }
        return entry;
    }
}

