/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.timeaffiliation.stragegy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.AscriptionStrategy;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.SliceMode;
import kd.wtc.wtes.business.executor.timeaffiliation.stragegy.SplitLine;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.common.pairtime.SourceCode;
import kd.wtc.wtes.common.util.Assert;

public class AscriptionActuator {
    private static final Log LOGGER = LogFactory.getLog(AscriptionActuator.class);
    private static final String BEGIN_STAMP = "begin_stamp";

    public static void preProcessAscription(LocalDate date, List<TimeBucket> timeBucketList, AscriptionStrategy preStrategy, AscriptionStrategy prePreStrategy, TieContextStd context, ShiftTableSingle shiftTableSingle) {
        LocalDateTime splitTime = LocalDateTime.of(date, LocalTime.of(0, 0, 0));
        LocalDate preDate = date.plusDays(-1L);
        Roster roster = shiftTableSingle.getRoster(preDate);
        if (roster == null) {
            context.setVariable(BEGIN_STAMP, splitTime, VScope.LINE);
            return;
        }
        ShiftSpec preShiftSpec = roster.getShiftSpec();
        if (preShiftSpec == null) {
            context.setVariable(BEGIN_STAMP, splitTime, VScope.LINE);
            return;
        }
        ArrayList<TimeBucket> filterTimeBuckets = new ArrayList<TimeBucket>(timeBucketList.size());
        for (TimeBucket timeBucket : timeBucketList) {
            if (timeBucket.isNonTime()) continue;
            filterTimeBuckets.add(timeBucket);
        }
        filterTimeBuckets.sort(AscriptionActuator.sortTimeBucket());
        List<TimeBucket> preDateTimeBuckets = AscriptionActuator.makePreDateTimeBuckets(filterTimeBuckets, preDate, prePreStrategy);
        SplitLine preDateSplitLine = preStrategy.getSplitLineBetweenDateAndNextDate(preDate);
        splitTime = AscriptionActuator.makeSplitTimeBySliceMode(preDateTimeBuckets, preDateSplitLine, preShiftSpec, preDate, splitTime);
        context.setVariable(BEGIN_STAMP, splitTime, VScope.LINE);
    }

    private static LocalDateTime makeSplitTimeBySliceMode(List<TimeBucket> preDateTimeBuckets, SplitLine preDateSplitLine, ShiftSpec preShiftSpec, LocalDate preDate, LocalDateTime splitTime) {
        boolean offNonPlanFlag;
        LocalDateTime preShiftStartTime = preShiftSpec.generateShiftStartTime(preDate);
        LocalDateTime preShiftEndTime = preShiftSpec.generateShiftEndTime(preDate);
        LocalDateTime preDateSplitPoint = preDateSplitLine.getSplitPoint();
        SliceMode preDateSliceMode = preDateSplitLine.getSliceMode();
        boolean bl = offNonPlanFlag = preShiftSpec.isOff() && preShiftSpec.getOffNonPlan();
        if (preDateSliceMode == SliceMode.NO) {
            if (preDateTimeBuckets.isEmpty()) {
                if (!offNonPlanFlag) {
                    splitTime = !AscriptionActuator.isTimePairAcrossSplitPoint(preShiftStartTime, preShiftEndTime, preDateSplitPoint) ? preShiftEndTime : (preDateSplitLine.isAscriptionPreDay() ? preShiftEndTime : preShiftStartTime);
                }
            } else {
                if (offNonPlanFlag) {
                    preShiftStartTime = AscriptionActuator.getFirst(preDateTimeBuckets).getStartTime();
                    preShiftEndTime = AscriptionActuator.getLast(preDateTimeBuckets).getEndTime();
                }
                splitTime = !AscriptionActuator.isTimePairAcrossSplitPoint(preShiftStartTime, preShiftEndTime, preDateSplitPoint) ? AscriptionActuator.getLast(preDateTimeBuckets).getEndTime() : (preDateSplitLine.isAscriptionPreDay() ? AscriptionActuator.getLast(preDateTimeBuckets).getEndTime() : AscriptionActuator.getFirst(preDateTimeBuckets).getStartTime());
            }
        }
        if (preDateSliceMode == SliceMode.FORCE) {
            splitTime = preDateSplitPoint;
        }
        if (preDateSliceMode == SliceMode.JUST_CUR_DATE) {
            if (preDateTimeBuckets.isEmpty()) {
                splitTime = preShiftEndTime;
                if (AscriptionActuator.isTimePairAcrossSplitPoint(preShiftStartTime, preShiftEndTime, preDateSplitPoint)) {
                    splitTime = preDateSplitPoint;
                }
            } else {
                splitTime = AscriptionActuator.getLast(preDateTimeBuckets).getEndTime();
                if (AscriptionActuator.isTimePairAcrossSplitPoint(preShiftStartTime, preShiftEndTime, preDateSplitPoint)) {
                    splitTime = preDateSplitPoint;
                }
            }
        }
        return splitTime;
    }

    private static List<TimeBucket> makePreDateTimeBuckets(List<TimeBucket> timeBuckets, LocalDate preDate, AscriptionStrategy prePreStrategy) {
        ArrayList<TimeBucket> preDateTimeBuckets = new ArrayList<TimeBucket>(timeBuckets.size());
        for (TimeBucket timeBucket : timeBuckets) {
            LocalDate shiftDate = timeBucket.getShiftDate();
            if (!shiftDate.equals(preDate)) continue;
            preDateTimeBuckets.add(timeBucket);
        }
        TimeBucket specificTimeBucket = null;
        LocalDate prePreDate = preDate.plusDays(-1L);
        SplitLine prePreDateSplitLine = prePreStrategy.getSplitLineBetweenDateAndNextDate(prePreDate);
        LocalDateTime prePreDateSplitPoint = prePreDateSplitLine.getSplitPoint();
        if (prePreDateSplitLine.getSliceMode() == SliceMode.FORCE) {
            Iterator iterator = preDateTimeBuckets.iterator();
            while (iterator.hasNext()) {
                TimeBucket timeBucket = (TimeBucket)iterator.next();
                if (AscriptionActuator.isTimeBucketEndTimeAfter(timeBucket, prePreDateSplitPoint)) {
                    specificTimeBucket = AscriptionActuator.isTimeBucketAcrossSplitPoint(timeBucket, prePreDateSplitPoint) ? timeBucket : null;
                    break;
                }
                iterator.remove();
            }
            if (specificTimeBucket != null) {
                SplitResult splitResult = AscriptionActuator.splitTimeBucket(specificTimeBucket, prePreDateSplitPoint);
                preDateTimeBuckets.remove(0);
                preDateTimeBuckets.add(0, splitResult.rightHalf);
            }
        }
        return preDateTimeBuckets;
    }

    public static List<TimeBucket> getTimeBucketsByDate(LocalDate date, List<TimeBucket> timeBucketList, AscriptionStrategy strategy, TieContextStd context, ShiftTableSingle shiftTableSingle) {
        ArrayList<TimeBucket> result = new ArrayList<TimeBucket>();
        if (timeBucketList.isEmpty()) {
            return result;
        }
        LocalDateTime splitTime = (LocalDateTime)context.getVariable(BEGIN_STAMP, VScope.LINE);
        Assert.nonNull((Object)splitTime, (String)ResManager.loadKDString((String)"\u9519\u8bef\uff1a\u672a\u8c03\u7528\u65e5\u671f\u5f52\u5c5e\u9884\u5904\u7406\u903b\u8f91\u3002", (String)"AscriptionActuator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        LocalDate preDate = date.plusDays(-1L);
        LocalDate curDate = date;
        LocalDate nextDate = date.plusDays(1L);
        boolean beginCollect = false;
        ArrayList<TimeBucket> filterTimeBuckets = new ArrayList<TimeBucket>();
        ArrayList<TimeBucket> curDateTimeBuckets = new ArrayList<TimeBucket>();
        ArrayList<TimeBucket> nextDateTimeBuckets = new ArrayList<TimeBucket>();
        for (TimeBucket timeBucket : timeBucketList) {
            if (timeBucket.isNonTime()) {
                if (!curDate.isEqual(timeBucket.getOriginalDate())) continue;
                result.add(timeBucket);
                continue;
            }
            filterTimeBuckets.add(timeBucket);
        }
        filterTimeBuckets.sort(AscriptionActuator.sortTimeBucket());
        for (TimeBucket timeBucket : filterTimeBuckets) {
            LocalDateTime endTime = timeBucket.getEndTime();
            if (!beginCollect) {
                if (endTime.isBefore(splitTime)) continue;
                beginCollect = true;
                if (endTime.isEqual(splitTime)) {
                    timeBucket = null;
                } else if (AscriptionActuator.isTimeBucketAcrossSplitPoint(timeBucket, splitTime)) {
                    SplitResult splitResult = AscriptionActuator.splitTimeBucket(timeBucket, splitTime);
                    timeBucket = splitResult.rightHalf;
                }
            }
            if (timeBucket == null) continue;
            LocalDate shiftDate = timeBucket.getShiftDate();
            if (shiftDate.equals(preDate)) {
                result.add(timeBucket);
                continue;
            }
            if (shiftDate.equals(curDate)) {
                curDateTimeBuckets.add(timeBucket);
                continue;
            }
            if (!shiftDate.equals(nextDate)) continue;
            nextDateTimeBuckets.add(timeBucket);
        }
        LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{}\u73ed\u6b21\u4f46\u5f52\u5c5e\u4e8e{}\u65f6\u95f4\u5bf9\u6709{}\u4e2a\uff1a{}\u3002", (String)"AscriptionActuator_1", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{preDate, curDate, result.size(), result});
        LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{}\u73ed\u6b21\u7684\u65f6\u95f4\u5bf9\u6709{}\u4e2a\uff1a{}\u3002", (String)"AscriptionActuator_2", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{curDate, curDateTimeBuckets.size(), curDateTimeBuckets});
        LOGGER.debug(ResManager.loadKDString((String)"\u6765\u81ea\u4e8e{}\u73ed\u6b21\u7684\u65f6\u95f4\u5bf9\u6709{}\u4e2a\uff1a{}\u3002", (String)"AscriptionActuator_2", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{nextDate, nextDateTimeBuckets.size(), nextDateTimeBuckets});
        ArrayList<TimeBucket> curDateHasTimeBuckets = new ArrayList<TimeBucket>(10);
        if (!curDateTimeBuckets.isEmpty()) {
            ArrayList<TimeBucket> curDateNonTimeBuckets = new ArrayList<TimeBucket>(10);
            for (TimeBucket timeBucket : curDateTimeBuckets) {
                if (timeBucket.isNonTime()) {
                    curDateNonTimeBuckets.add(timeBucket);
                    continue;
                }
                curDateHasTimeBuckets.add(timeBucket);
            }
            result.addAll(curDateNonTimeBuckets);
        }
        ShiftSpec shiftSpec = shiftTableSingle.getRoster(curDate).getShiftSpec();
        LocalDateTime newSplitTime = AscriptionActuator.makeNewSplitTimeBySliceMode(strategy, shiftSpec, curDate, curDateHasTimeBuckets, nextDateTimeBuckets, result);
        context.setVariable(BEGIN_STAMP, newSplitTime, VScope.LINE);
        return result;
    }

    private static LocalDateTime makeNewSplitTimeBySliceMode(AscriptionStrategy strategy, ShiftSpec shiftSpec, LocalDate curDate, List<TimeBucket> curDateTimeBuckets, List<TimeBucket> nextDateTimeBuckets, List<TimeBucket> result) {
        LocalDateTime newSplitTime = LocalDateTime.of(curDate.plusDays(1L), LocalTime.of(0, 0, 0));
        LocalDateTime shiftStartTime = shiftSpec.generateShiftStartTime(curDate);
        LocalDateTime shiftEndTime = shiftSpec.generateShiftEndTime(curDate);
        boolean offNonPlanFlag = shiftSpec.isOff() && shiftSpec.getOffNonPlan();
        SplitLine curDateSplitLine = strategy.getSplitLineBetweenDateAndNextDate(curDate);
        LocalDateTime curDateSplitPoint = curDateSplitLine.getSplitPoint();
        SliceMode curDateSliceMode = curDateSplitLine.getSliceMode();
        if (curDateSliceMode == SliceMode.NO) {
            if (curDateTimeBuckets.isEmpty()) {
                if (!offNonPlanFlag) {
                    newSplitTime = !AscriptionActuator.isTimePairAcrossSplitPoint(shiftStartTime, shiftEndTime, curDateSplitPoint) ? shiftEndTime : (curDateSplitLine.isAscriptionPreDay() ? shiftEndTime : shiftStartTime);
                }
            } else {
                if (offNonPlanFlag) {
                    shiftStartTime = AscriptionActuator.getFirst(curDateTimeBuckets).getStartTime();
                    shiftEndTime = AscriptionActuator.getLast(curDateTimeBuckets).getEndTime();
                }
                if (!AscriptionActuator.isTimePairAcrossSplitPoint(shiftStartTime, shiftEndTime, curDateSplitPoint)) {
                    result.addAll(curDateTimeBuckets);
                    newSplitTime = AscriptionActuator.getLast(curDateTimeBuckets).getEndTime();
                } else if (curDateSplitLine.isAscriptionPreDay()) {
                    result.addAll(curDateTimeBuckets);
                    newSplitTime = AscriptionActuator.getLast(curDateTimeBuckets).getEndTime();
                } else {
                    newSplitTime = AscriptionActuator.getFirst(curDateTimeBuckets).getStartTime();
                }
            }
        }
        if (curDateSliceMode == SliceMode.FORCE) {
            TimeBucket specificTimeBucket;
            newSplitTime = curDateSplitPoint;
            if (!curDateTimeBuckets.isEmpty()) {
                specificTimeBucket = AscriptionActuator.getLast(curDateTimeBuckets);
                if (AscriptionActuator.isTimeBucketEndTimeAfter(specificTimeBucket, curDateSplitPoint)) {
                    AscriptionActuator.drainVestInNextDateTimeBucket(curDateTimeBuckets, curDateSplitPoint);
                }
                result.addAll(curDateTimeBuckets);
            }
            if (!nextDateTimeBuckets.isEmpty() && AscriptionActuator.isTimeBucketStartTimeBefore(specificTimeBucket = AscriptionActuator.getFirst(nextDateTimeBuckets), curDateSplitPoint)) {
                List<TimeBucket> vestInCurDateTimeBuckets = AscriptionActuator.stealTimeBucketFromTheHead(nextDateTimeBuckets, curDateSplitPoint);
                result.addAll(vestInCurDateTimeBuckets);
            }
        }
        if (curDateSliceMode == SliceMode.JUST_CUR_DATE) {
            if (curDateTimeBuckets.isEmpty()) {
                if (!offNonPlanFlag) {
                    newSplitTime = shiftEndTime;
                    if (AscriptionActuator.isTimePairAcrossSplitPoint(shiftStartTime, shiftEndTime, curDateSplitPoint)) {
                        newSplitTime = curDateSplitPoint;
                    }
                }
            } else {
                if (offNonPlanFlag) {
                    shiftStartTime = AscriptionActuator.getFirst(curDateTimeBuckets).getStartTime();
                    shiftEndTime = AscriptionActuator.getLast(curDateTimeBuckets).getEndTime();
                }
                newSplitTime = AscriptionActuator.getLast(curDateTimeBuckets).getEndTime();
                if (AscriptionActuator.isTimePairAcrossSplitPoint(shiftStartTime, shiftEndTime, curDateSplitPoint)) {
                    AscriptionActuator.drainVestInNextDateTimeBucket(curDateTimeBuckets, curDateSplitPoint);
                    newSplitTime = curDateSplitPoint;
                }
                result.addAll(curDateTimeBuckets);
            }
        }
        LOGGER.debug(ResManager.loadKDString((String)"{}\u4e0e\u4e0b\u4e00\u5929\u7684\u5206\u754c\u65f6\u95f4\u4e3a{}\uff0c\u903b\u8f91\u5207\u5272\u7ebf\u4e3a\uff1a{}\u3002", (String)"AscriptionActuator_3", (String)"wtc-wtes-business", (Object[])new Object[0]), new Object[]{curDate, newSplitTime, curDateSplitLine});
        return newSplitTime;
    }

    private static void drainVestInNextDateTimeBucket(List<TimeBucket> timeBuckets, LocalDateTime splitPoint) {
        AscriptionActuator.stealTimeBucketFromTheTail(timeBuckets, splitPoint);
    }

    private static List<TimeBucket> stealTimeBucketFromTheHead(List<TimeBucket> timeBuckets, LocalDateTime splitPoint) {
        TimeBucket timeBucket;
        ArrayList<TimeBucket> result = new ArrayList<TimeBucket>();
        if (timeBuckets.isEmpty() || !AscriptionActuator.isTimeBucketStartTimeBefore(AscriptionActuator.getFirst(timeBuckets), splitPoint)) {
            return result;
        }
        Iterator<TimeBucket> iterator = timeBuckets.iterator();
        while (iterator.hasNext() && !(timeBucket = iterator.next()).getEndTime().isAfter(splitPoint)) {
            result.add(timeBucket);
            iterator.remove();
        }
        if (timeBuckets.isEmpty()) {
            return result;
        }
        timeBucket = timeBuckets.get(0);
        if (AscriptionActuator.isTimeBucketAcrossSplitPoint(timeBucket, splitPoint)) {
            SplitResult splitResult = AscriptionActuator.splitTimeBucket(timeBucket, splitPoint);
            result.add(splitResult.leftHalf);
            timeBuckets.remove(0);
            timeBuckets.add(0, splitResult.rightHalf);
        }
        return result;
    }

    private static List<TimeBucket> stealTimeBucketFromTheTail(List<TimeBucket> timeBuckets, LocalDateTime splitPoint) {
        TimeBucket timeBucket;
        int idx;
        if (timeBuckets.isEmpty() || !AscriptionActuator.isTimeBucketEndTimeAfter(AscriptionActuator.getLast(timeBuckets), splitPoint)) {
            return new ArrayList<TimeBucket>();
        }
        int size = timeBuckets.size();
        ArrayList<TimeBucket> result = new ArrayList<TimeBucket>(size);
        for (idx = 0; idx < size && !AscriptionActuator.isTimeBucketEndTimeAfter(timeBucket = timeBuckets.get(idx), splitPoint); ++idx) {
        }
        timeBucket = timeBuckets.get(idx);
        if (AscriptionActuator.isTimeBucketAcrossSplitPoint(timeBucket, splitPoint)) {
            SplitResult splitResult = AscriptionActuator.splitTimeBucket(timeBucket, splitPoint);
            result.add(splitResult.rightHalf);
            timeBuckets.remove(idx);
            timeBuckets.add(idx, splitResult.leftHalf);
            ++idx;
        }
        while (idx < size) {
            TimeBucket remove = timeBuckets.remove(idx);
            result.add(remove);
            --size;
        }
        return result;
    }

    private static TimeBucket getLast(List<TimeBucket> list) {
        return list.get(list.size() - 1);
    }

    private static TimeBucket getFirst(List<TimeBucket> list) {
        return list.get(0);
    }

    private static boolean isTimeBucketStartTimeBefore(TimeBucket timeBucket, LocalDateTime dateTime) {
        return timeBucket.getStartTime().isBefore(dateTime);
    }

    private static boolean isTimeBucketEndTimeAfter(TimeBucket timeBucket, LocalDateTime dateTime) {
        return timeBucket.getEndTime().isAfter(dateTime);
    }

    private static boolean isTimePairAcrossSplitPoint(LocalDateTime startTime, LocalDateTime endTime, LocalDateTime splitPoint) {
        return startTime.isBefore(splitPoint) && endTime.isAfter(splitPoint);
    }

    private static boolean isTimeBucketAcrossSplitPoint(TimeBucket timeBucket, LocalDateTime splitPoint) {
        return timeBucket.getStartTime().isBefore(splitPoint) && timeBucket.getEndTime().isAfter(splitPoint);
    }

    private static SplitResult splitTimeBucket(TimeBucket timeBucket, LocalDateTime splitDateTime) {
        TimeBucket preTimeBucket = (TimeBucket)((CleanableBuilder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)timeBucket.clone().toBuilder().parentDataNodes(timeBucket.parentDataNodes())).startTime(timeBucket.getStartTime())).endTime(splitDateTime)).endTimePointSource(SourceCode.TIME_AFFILIATION)).build();
        TimeBucket postTimeBucket = (TimeBucket)((CleanableBuilder)((TimeBucket.Builder)((TimeBucket.Builder)((TimeBucket.Builder)timeBucket.clone().toBuilder().parentDataNodes(timeBucket.parentDataNodes())).startTime(splitDateTime)).startTimePointSource(SourceCode.TIME_AFFILIATION)).endTime(timeBucket.getEndTime())).build();
        return new SplitResult(preTimeBucket, postTimeBucket);
    }

    private static Comparator<TimeBucket> sortTimeBucket() {
        return Comparator.comparing(TimeBucket::getShiftDate).thenComparing(TimeBucket::getStartTime);
    }

    private static class SplitResult {
        TimeBucket leftHalf;
        TimeBucket rightHalf;

        public SplitResult(TimeBucket leftHalf, TimeBucket rightHalf) {
            this.leftHalf = leftHalf;
            this.rightHalf = rightHalf;
        }
    }
}

