/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.executor.timeaffiliation.util;

import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.executor.timeaffiliation.model.Holiday;
import kd.wtc.wtes.business.executor.timeaffiliation.model.SecondPeriod;

public class HolidayUtils {
    private static final Log logger = LogFactory.getLog(HolidayUtils.class);

    public static Map<Long, Holiday> getAllHoliday() {
        DynamicObject[] dateTypeDyns;
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        HRBaseServiceHelper holidayServiceHelper = new HRBaseServiceHelper("wtbd_holiday");
        DynamicObject[] holidayDyns = holidayServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashSet<Long> dateTypeIdSet = new HashSet<Long>(16);
        for (DynamicObject dyn : holidayDyns) {
            DynamicObject dateTypeDyn = dyn.getDynamicObject("datetype");
            if (null == dateTypeDyn) continue;
            long id = dateTypeDyn.getLong("id");
            dateTypeIdSet.add(id);
        }
        HashMap<Long, DateType> dateTypeMap = new HashMap<Long, DateType>(dateTypeIdSet.size());
        QFilter qFilter1 = new QFilter("id", "in", dateTypeIdSet);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        HRBaseServiceHelper dateTypeServiceHelper = new HRBaseServiceHelper("wtbd_datetype");
        for (DynamicObject dyn : dateTypeDyns = dateTypeServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter1, qFilter2})) {
            long id = dyn.getLong("id");
            String number = dyn.getString("number");
            DateAttribute dateAttribute = DateAttribute.from((String)dyn.getString("dateproperty.number"));
            DateType date = DateType.of((Long)id, (String)number, (DateAttribute)dateAttribute);
            dateTypeMap.put(id, date);
        }
        HashMap<Long, Holiday> result = new HashMap<Long, Holiday>(holidayDyns.length);
        for (DynamicObject dyn : holidayDyns) {
            long id = dyn.getLong("id");
            String number = dyn.getString("number");
            Holiday.Builder builder = Holiday.of(id, number);
            long dateTypeId = dyn.getLong("datetype.id");
            DateType dateType = (DateType)dateTypeMap.get(dateTypeId);
            builder.dateType(dateType);
            String holidayType = dyn.getString("holidaytype");
            builder.holidayType(holidayType);
            if ("A".equals(holidayType)) {
                String fixedType = dyn.getString("fixedtype");
                builder.fixedType(fixedType);
                if ("A".equals(fixedType)) {
                    int startTime = dyn.getInt("starttime");
                    int endTime = dyn.getInt("endtime");
                    builder.startTime(startTime);
                    builder.endTime(endTime);
                } else if ("B".equals(fixedType)) {
                    int dyStartTime = dyn.getInt("dystarttime");
                    int dyEndTime = dyn.getInt("dyendtime");
                    builder.dyStartTime(dyStartTime);
                    builder.dyEndTime(dyEndTime);
                }
            } else if ("B".equals(holidayType)) {
                DynamicObjectCollection entities = dyn.getDynamicObjectCollection("unfixentry");
                HashMap<LocalDate, SecondPeriod> unFixEntry = new HashMap<LocalDate, SecondPeriod>(16);
                for (DynamicObject entity : entities) {
                    Date date = entity.getDate("ufstartdate");
                    int ufStartTime = entity.getInt("ufstarttime");
                    int ufEndTime = entity.getInt("ufendtime");
                    LocalDate localDate = WTCDateUtils.toLocalDate((Date)date);
                    SecondPeriod secondPeriod = (SecondPeriod)unFixEntry.get(localDate);
                    if (secondPeriod != null) {
                        logger.warn("\u975e\u56fa\u5b9a\u5047\u671f[id={}\uff0cnumber={}]\u4e2d\uff0c\u5bf9\u4e8e[\u5f00\u59cb\u65f6\u95f4={}]\u8fd9\u5929\u5b9a\u4e49\u4e86\u591a\u4e2a\u65f6\u6bb5\u3002\u6b64\u5904\u8fdb\u884c\u8986\u76d6\u5904\u7406\uff0c\u53ea\u53d6\u5b9a\u4e49\u987a\u5e8f\u4e2d\u7684\u6700\u540e\u4e00\u4e2a\u65f6\u6bb5\u3002", new Object[]{id, number, localDate});
                    }
                    unFixEntry.put(localDate, new SecondPeriod(ufStartTime, ufEndTime));
                }
                builder.unFixEntry(unFixEntry);
            }
            result.put(id, builder.build());
        }
        return result;
    }
}

