/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.exporter;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.tie.TieCalTaskDetail;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.subject.AttExcludeSubject;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.exporter.ITieLineExporter;
import kd.wtc.wtes.business.exporter.TieLineExporterStdImpl;
import kd.wtc.wtes.business.model.TieEngineState;
import kd.wtc.wtes.business.model.TieLineState;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.std.AbstractTieExporter;

public class TieExporterStdImpl
extends AbstractTieExporter {
    private static final Log LOGGER = LogFactory.getLog(TieExporterStdImpl.class);
    private final AtomicInteger succeedAttSubjectCount = new AtomicInteger(0);
    private final AtomicInteger failAttSubjectCount = new AtomicInteger(0);
    private int excludeAttSubjectCount;
    private final AtomicInteger waitRunAttSubjectCount = new AtomicInteger(0);
    private final AtomicInteger succeedAttFileBoCount = new AtomicInteger(0);
    private final AtomicInteger failAttFileBoCount = new AtomicInteger(0);
    private int excludeAttFileBoCount;
    private final AtomicInteger waitRunAttFileBoCount = new AtomicInteger(0);
    private List<AttSubject> attSubjects;
    private List<AttExcludeSubject> excludeBoList;
    private Map<Long, List<AttPersonRange>> personRangeMap;
    private final Map<Long, TieLineState> cacheMap = new ConcurrentHashMap<Long, TieLineState>(16);
    private final Map<AttSubject.AttFileBo, LocalDate> lastTieDateMap = new ConcurrentHashMap<AttSubject.AttFileBo, LocalDate>(16);
    private final Map<AttSubject.AttFileBo, LocalDate> errorDateMap = new ConcurrentHashMap<AttSubject.AttFileBo, LocalDate>(16);
    private final Map<Long, List<WTCCalTaskDetailEntity>> detailAccumulator = new ConcurrentHashMap<Long, List<WTCCalTaskDetailEntity>>(16);
    private final Map<Long, String> personErrorMsg = new ConcurrentHashMap<Long, String>(16);
    private static final int MAX_EXPORT_SIZE = 200;
    private final StringBuffer alarmsBuffer = new StringBuffer();
    private boolean isStop = false;
    private final TieEngineState engineState = new TieEngineState();
    private TieMsgLevel level = TieMsgLevel.INFO;

    @Override
    public void pushSubjectErrorMsg(Long attPersonId, String msg) {
        String emdWithStr = WTCSymbolMultiLanguageUtil.getSemicolonSymbol();
        if (msg.endsWith(emdWithStr)) {
            msg = msg.substring(0, msg.length() - emdWithStr.length());
        }
        this.personErrorMsg.put(attPersonId, WTCStringUtils.trim((String)msg));
    }

    @Override
    public TieEngineState getEngineState() {
        return this.engineState;
    }

    @Override
    public void setTieRequest(TieRequest request) {
        this.engineState.setTaskid(request.getTaskId());
        this.engineState.setSubTaskId(request.getSubTaskId());
        this.engineState.setVersion(request.getVersion());
    }

    public void setPersonRangeMap(Map<Long, List<AttPersonRange>> personRangeMap) {
        this.personRangeMap = personRangeMap;
    }

    public Map<Long, List<AttPersonRange>> getPersonRangeMap() {
        return this.personRangeMap;
    }

    @Override
    public void setAttSubjects(List<AttSubject> attSubjects) {
        super.setAttSubjects(attSubjects);
        this.attSubjects = attSubjects;
        this.tryInitStaticsInfo();
    }

    @Override
    public void setAttExcludeSubjects(List<AttExcludeSubject> attExcludeSubjects) {
        this.excludeBoList = attExcludeSubjects;
        this.tryInitStaticsInfo();
    }

    private void tryInitStaticsInfo() {
        if (this.excludeBoList == null || this.attSubjects == null) {
            return;
        }
        Map<Long, List<AttExcludeSubject>> excludeSubjectMap = this.excludeBoList.stream().collect(Collectors.groupingBy(excludeBo -> excludeBo.getAttPersonId()));
        Map<Long, AttSubject> allSubjectMap = this.attSubjects.stream().collect(Collectors.toMap(ele -> ele.getAttPersonId(), ele -> ele));
        HashSet<Long> excludeSubjectId = new HashSet<Long>(16);
        for (Map.Entry<Long, List<AttExcludeSubject>> entry : excludeSubjectMap.entrySet()) {
            Long attPersonId = entry.getKey();
            if (allSubjectMap.containsKey(attPersonId)) continue;
            excludeSubjectId.add(attPersonId);
            ++this.excludeAttSubjectCount;
        }
        this.waitRunAttSubjectCount.addAndGet(this.attSubjects.size());
        this.excludeAttFileBoCount = this.excludeBoList.size();
        this.waitRunAttFileBoCount.addAndGet((int)this.attSubjects.stream().flatMap(ele -> ele.getAttFileBos().stream()).count());
        LOGGER.debug(ResManager.loadKDString((String)"\u5f15\u64ce\u4e0a\u62a5\u5668\u521d\u59cb\u5316\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u7684BO\u6570\u91cf={}\uff1b\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u7684bo\u96c6\u5408excludeBoList={}\u3002", (String)"TieExporterStdImpl_0", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)this.excludeAttFileBoCount, this.excludeBoList);
        LOGGER.debug(ResManager.loadKDString((String)"\u5f15\u64ce\u4e0a\u62a5\u5668\u521d\u59cb\u5316\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e3b\u4f53\u6570\u91cf={}\uff1b\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e3b\u4f53ID\u96c6\u5408excludeSubjectId={}\u3002", (String)"TieExporterStdImpl_1", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)this.excludeAttSubjectCount, excludeSubjectId);
        LOGGER.debug(ResManager.loadKDString((String)"\u5f15\u64ce\u4e0a\u62a5\u5668\u521d\u59cb\u5316\uff0c\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e3b\u4f53\u6570\u91cf={}\uff1b\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e3b\u4f53\u96c6\u5408excludeSubjectId={}", (String)"TieExporterStdImpl_2", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)this.waitRunAttSubjectCount.get(), this.attSubjects);
    }

    private void pushAllExcludeDetail2Accumulator() {
        if (null != this.excludeBoList) {
            for (AttExcludeSubject exBo : this.excludeBoList) {
                List detailList = this.detailAccumulator.computeIfAbsent(exBo.getAttPersonId(), key -> new ArrayList(16));
                TieCalTaskDetail detail = this.newTaskDetail();
                detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
                detail.setAttFileBoId(exBo.getAttFileBoid());
                detail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT);
                detail.setExCode(exBo.getExCode());
                detail.setExInfo(exBo.getExMsg());
                this.buildDate(detail);
                detailList.add(detail);
            }
        }
    }

    private TieCalTaskDetail newTaskDetail() {
        return new TieCalTaskDetail();
    }

    private void buildDate(TieCalTaskDetail taskDetail) {
        List<AttPersonRange> attPersonRanges;
        Map<AttSubject.AttFileBo, LocalDate> errorDateMap;
        HashMap accountDateMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<AttSubject.AttFileBo, LocalDate> successDateMap = this.getLastTieDateMap();
        if (WTCCollections.isNotEmpty(successDateMap)) {
            successDateMap.forEach((attFileBo, localDate) -> accountDateMap.put(attFileBo.getAttFileBoid(), localDate));
        }
        if (WTCCollections.isNotEmpty(errorDateMap = this.getErrorDateMap())) {
            errorDateMap.forEach((attFileBo, localDate) -> accountDateMap.put(attFileBo.getAttFileBoid(), localDate));
        }
        if (WTCCollections.isNotEmpty(attPersonRanges = this.personRangeMap.get(taskDetail.getAttFileBoId()))) {
            AttPersonRange personRange = attPersonRanges.get(0);
            Date accountDate = WTCDateUtils.toDate((LocalDate)((LocalDate)accountDateMap.get(taskDetail.getAttFileBoId())));
            if (null == accountDate) {
                taskDetail.setAccountTo(personRange.getCalculateTo());
            } else if (personRange.getAttFileStartDate() != null && personRange.getAttFileStartDate().compareTo(accountDate) >= 0) {
                taskDetail.setAccountTo(null);
            } else {
                taskDetail.setAccountTo(accountDate);
            }
            taskDetail.setLockTo(personRange.getLockTo());
            taskDetail.setAttFileStartDate(personRange.getAttFileStartDate());
            taskDetail.setAttFileEndDate(personRange.getAttFileEndDate());
            taskDetail.setAllowReAccountTime(personRange.getReCalDate());
        }
    }

    public List<AttExcludeSubject> getAttExcludeSubjects() {
        return this.excludeBoList;
    }

    @Override
    public void finishOneSubject(AttSubject attSubject) {
        LOGGER.debug(ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u7684\u6d41\u6c34\u7ebf\u6267\u884c\u6210\u529f\uff0cattSubject={}\u3002", (String)"TieExporterStdImpl_3", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)attSubject);
        this.succeedAttSubjectCount.incrementAndGet();
        this.waitRunAttSubjectCount.decrementAndGet();
        this.pushOne2LastTieDateMap(attSubject, false);
        long attPersonId = attSubject.getAttPersonId();
        List attFileBos = attSubject.getAttFileBos();
        List detailList = this.detailAccumulator.computeIfAbsent(attPersonId, key -> new ArrayList(16));
        for (AttSubject.AttFileBo attFileBo : attFileBos) {
            TieCalTaskDetail detail = this.newTaskDetail();
            detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
            detail.setAttFileBoId(attFileBo.getAttFileBoid());
            detail.setAttPersonId(attFileBo.getAttSubject().getAttPersonId());
            detail.setTaskDetailState(WTCTaskDetailStatus.SUCCESS);
            detail.setRealCalStartDate(WTCDateUtils.toDate((LocalDate)attFileBo.getStartDate()));
            detail.setRealCalEndDate(WTCDateUtils.toDate((LocalDate)attFileBo.getEndDate()));
            if (this.getEpRelDiscardAttFileBoIds().contains(attFileBo.getAttFileBoid())) {
                detail.setExInfo(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u529f\uff0c\u4f46\u662f\u8003\u52e4\u6863\u6848\u5bf9\u5e94\u7684\u6838\u5fc3\u4eba\u529b\u7684\u4efb\u804c\u7ecf\u5386\u5df2\u5220\u9664\uff0c\u8003\u52e4\u6863\u6848\u5173\u8054\u7684\u5c97\u4f4d\u4fe1\u606f\u4e0d\u51c6\u786e\uff0c\u5efa\u8bae\u8c03\u6574\u8003\u52e4\u6863\u6848\u7684\u5c97\u4f4d\u4fe1\u606f\u3002", (String)"TieExporterStdImpl_16", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            this.buildDate(detail);
            detailList.add(detail);
            this.waitRunAttFileBoCount.decrementAndGet();
            this.succeedAttFileBoCount.incrementAndGet();
        }
    }

    @Override
    public void errorOneSubject(AttSubject attSubject) {
        LOGGER.debug(ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u7684\u6d41\u6c34\u7ebf\u6267\u884c\u5931\u8d25\uff0cerrorOneLine={}\u3002", (String)"TieExporterStdImpl_4", (String)"wtc-wtes-business", (Object[])new Object[0]), (Object)attSubject);
        this.failAttSubjectCount.incrementAndGet();
        this.waitRunAttSubjectCount.decrementAndGet();
        this.pushOne2LastTieDateMap(attSubject, true);
        long attPersonId = attSubject.getAttPersonId();
        TieLineState tieLineState = this.cacheMap.get(attSubject.getAttPersonId());
        LocalDate lastSuccessDate = tieLineState.$getTieToDate();
        List attFileBos = attSubject.getAttFileBos();
        List detailList = this.detailAccumulator.computeIfAbsent(attPersonId, key -> new ArrayList(16));
        for (AttSubject.AttFileBo attFileBo : attFileBos) {
            boolean error;
            TieCalTaskDetail detail = this.newTaskDetail();
            detail.setAttPersonId(attPersonId);
            detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
            detail.setAttFileBoId(attFileBo.getAttFileBoid());
            this.buildDate(detail);
            boolean bl = error = lastSuccessDate == null ? true : attFileBo.getEndDate().isAfter(lastSuccessDate);
            if (error) {
                this.failAttFileBoCount.incrementAndGet();
                detail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
                if (lastSuccessDate == null || !attFileBo.getStartDate().isBefore(lastSuccessDate)) {
                    detail.setRealCalStartDate(null);
                    detail.setRealCalEndDate(null);
                } else {
                    detail.setRealCalStartDate(WTCDateUtils.toDate((LocalDate)attFileBo.getStartDate()));
                    detail.setRealCalEndDate(WTCDateUtils.toDate((LocalDate)lastSuccessDate));
                }
                detail.setExCode(null);
                String exInfo = this.personErrorMsg.get(attSubject.getAttPersonId());
                if (lastSuccessDate == null) {
                    detail.setExInfo(exInfo);
                    if (exInfo == null) {
                        detail.setExInfo(ResManager.loadKDString((String)"{0}\u65e5\u8ba1\u7b97\u51fa\u9519\u3002", (String)"TieExporterStdImpl_5", (String)"wtc-wtes-business", (Object[])new Object[]{WTCDateUtils.date2Str((Date)tieLineState.getLineBeginDate(), (String)"yyyy-MM-dd")}));
                    }
                } else {
                    detail.setExInfo(exInfo);
                    if (exInfo == null) {
                        detail.setExInfo(ResManager.loadKDString((String)"{0}\u65e5\u8ba1\u7b97\u51fa\u9519\u3002", (String)"TieExporterStdImpl_5", (String)"wtc-wtes-business", (Object[])new Object[]{WTCDateUtils.date2Str((Date)WTCDateUtils.toDate((LocalDate)lastSuccessDate.plusDays(1L)), (String)"yyyy-MM-dd")}));
                    }
                }
            } else {
                this.succeedAttFileBoCount.incrementAndGet();
                detail.setTaskDetailState(WTCTaskDetailStatus.SUCCESS);
                detail.setRealCalStartDate(WTCDateUtils.toDate((LocalDate)attFileBo.getStartDate()));
                detail.setRealCalEndDate(WTCDateUtils.toDate((LocalDate)attFileBo.getEndDate()));
            }
            detailList.add(detail);
            this.waitRunAttFileBoCount.decrementAndGet();
        }
    }

    @Override
    public ITieLineExporter newLineExporter(AttSubject attSubject) {
        return new TieLineExporterStdImpl(this, attSubject);
    }

    private void pushOne2LastTieDateMap(AttSubject attSubject, boolean isError) {
        long attPersonId = attSubject.getAttPersonId();
        TieLineState tieLineState = this.cacheMap.get(attPersonId);
        LocalDate lastSuccessDate = tieLineState.$getTieToDate();
        if (lastSuccessDate == null) {
            this.pushErrorDateMap(attSubject, WTCDateUtils.toLocalDate((Date)WTCDateUtils.addDays((Date)tieLineState.getLineBeginDate(), (int)-1)));
            return;
        }
        List attFileBos = attSubject.getAttFileBos();
        for (AttSubject.AttFileBo attFileBo : attFileBos) {
            LocalDate endDate = attFileBo.getEndDate();
            LocalDate lastTieDate = endDate.isAfter(lastSuccessDate) ? lastSuccessDate : endDate;
            this.lastTieDateMap.put(attFileBo, lastTieDate);
            if (!isError) continue;
            this.errorDateMap.put(attFileBo, lastTieDate);
        }
    }

    private void pushErrorDateMap(AttSubject attSubject, LocalDate beforeErrorDate) {
        List attFileBos = attSubject.getAttFileBos();
        for (AttSubject.AttFileBo attFileBo : attFileBos) {
            this.errorDateMap.put(attFileBo, beforeErrorDate);
        }
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getLastTieDateMap() {
        return this.lastTieDateMap;
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getErrorDateMap() {
        return this.errorDateMap;
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        this.alarmsBuffer.append((Object)msgLevel).append(':').append(msg).append(';');
        if (TieMsgLevel.ERROR == msgLevel) {
            this.level = msgLevel;
        }
        if (TieMsgLevel.WARNING == msgLevel && TieMsgLevel.INFO == this.level) {
            this.level = msgLevel;
        }
    }

    @Override
    public List<WTCCalTaskDetailEntity> getResult() {
        return this.detailAccumulator.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
    }

    @Override
    public void updateSubErrorResult(Set<Long> personIds, String msg) {
        for (Long personId : personIds) {
            List<WTCCalTaskDetailEntity> wtcCalTaskDetailEntities = this.detailAccumulator.get(personId);
            if (wtcCalTaskDetailEntities == null) continue;
            this.failAttSubjectCount.incrementAndGet();
            this.succeedAttSubjectCount.decrementAndGet();
            for (WTCCalTaskDetailEntity entity : wtcCalTaskDetailEntities) {
                this.failAttFileBoCount.incrementAndGet();
                this.succeedAttFileBoCount.decrementAndGet();
                entity.setTaskDetailState(WTCTaskDetailStatus.FAIL);
                entity.setExInfo(msg);
            }
        }
    }

    @Override
    public void afterStateChanged(TieState oldState, TieState newState) {
        if (newState == TieState.SUCCESS || newState == TieState.ERROR || newState == TieState.TERMINATED) {
            List<WTCCalTaskDetailEntity> engineCauseFailDetailList;
            this.pushAllExcludeDetail2Accumulator();
            List<WTCCalTaskDetailEntity> detailList = this.getResult();
            WTCSubTaskStatus subTaskStatus = null;
            if (newState == TieState.SUCCESS) {
                subTaskStatus = WTCSubTaskStatus.FINISHED;
            } else if (newState == TieState.ERROR) {
                subTaskStatus = WTCSubTaskStatus.ERROR;
                this.failAttFileBoCount.addAndGet(this.waitRunAttFileBoCount.get());
                this.waitRunAttFileBoCount.set(0);
                this.failAttSubjectCount.addAndGet(this.waitRunAttSubjectCount.get());
                this.waitRunAttSubjectCount.set(0);
                engineCauseFailDetailList = this.getEngineCauseFailDetailList(WTCTaskDetailStatus.FAIL);
                detailList.addAll(engineCauseFailDetailList);
                LOGGER.debug(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f15\u64ce\u63a8\u8fdb\u5230\u9519\u8bef\u72b6\u6001\uff0c\u7531\u4e8e\u5f15\u64ce\u9519\u8bef\u5bfc\u81f4\u7b49\u5f85\u8ba1\u7b97\u5931\u8d25\u7684\u660e\u7ec6\uff1a{}\u3002", (String)"TieExporterStdImpl_6", (String)"wtc-wtes-business", (Object[])new Object[0]), engineCauseFailDetailList);
            } else if (newState == TieState.TERMINATED) {
                subTaskStatus = WTCSubTaskStatus.TERMINATED;
                this.failAttFileBoCount.addAndGet(this.waitRunAttFileBoCount.get());
                this.waitRunAttFileBoCount.set(0);
                this.failAttSubjectCount.addAndGet(this.waitRunAttSubjectCount.get());
                this.waitRunAttSubjectCount.set(0);
                engineCauseFailDetailList = this.getEngineCauseFailDetailList(WTCTaskDetailStatus.NOT_ACCOUNT);
                detailList.addAll(engineCauseFailDetailList);
                LOGGER.debug(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f15\u64ce\u63a8\u8fdb\u5230\u7ec8\u6b62\u72b6\u6001\uff0c\u7531\u4e8e\u5f15\u64ce\u9519\u8bef\u5bfc\u81f4\u7b49\u5f85\u8ba1\u7b97\u5931\u8d25\u7684\u660e\u7ec6\uff1a{}\u3002", (String)"TieExporterStdImpl_7", (String)"wtc-wtes-business", (Object[])new Object[0]), engineCauseFailDetailList);
            }
            WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId(detailList, (String)"wtte_tie");
            QFilter countingStatus = new QFilter("taskdetailstate", "=", (Object)WTCTaskDetailStatus.ACCOUNTING.code);
            List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtte_tie", (long)this.engineState.getTaskid(), (long)this.engineState.getSubTaskId(), (QFilter)countingStatus);
            wtcCalTaskDetailEntities.forEach(detail -> {
                detail.setTaskDetailState(WTCTaskDetailStatus.NOT_ACCOUNT);
                detail.setExInfo(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5728\u6838\u7b97\u8303\u56f4\u5185\u4e0d\u5904\u4e8e\u201c\u6b63\u5e38\u8003\u52e4\u201d\u72b6\u6001\uff0c\u65e0\u6cd5\u6838\u7b97\uff0c\u8bf7\u68c0\u67e5\u8003\u52e4\u6863\u6848\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u3002", (String)"TieExporterStdImpl_12", (String)"wtc-wtes-business", (Object[])new Object[0]));
            });
            WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId((List)wtcCalTaskDetailEntities, (String)"wtte_tie");
            Map stateMap = WTCTaskServiceHelper.taskDetailStateCount((String)"wtte_tie", (long)0L, (long)this.engineState.getSubTaskId());
            WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
            subTask.setId(this.engineState.getSubTaskId().longValue());
            subTask.setTaskId(this.engineState.getTaskid());
            subTask.setSubTaskStatus(subTaskStatus);
            subTask.setStartDate(this.engineState.getBeginTime());
            subTask.setEndDate(this.engineState.getEndTime());
            subTask.setRefreshTime(this.engineState.getTaskStatusRefreshTime());
            subTask.setSucceedAttFile(((Integer)stateMap.get("succeedattfile")).intValue());
            subTask.setFailedAttFile(((Integer)stateMap.get("failedattfile")).intValue());
            subTask.setRunAttFile(subTask.getSucceedAttFile() + subTask.getFailedAttFile());
            subTask.setNotRunAttFile(((Integer)stateMap.get("notrunattfile")).intValue());
            subTask.setSucceedAttPerson(((Integer)stateMap.get("succeedattperson")).intValue());
            subTask.setFailedAttPerson(((Integer)stateMap.get("failedattperson")).intValue());
            subTask.setRunAttPerson(subTask.getSucceedAttPerson() + subTask.getFailedAttPerson());
            subTask.setNotRunAttPerson(((Integer)stateMap.get("notrunattperson")).intValue());
            boolean success = WTCTaskStateTransfer.transferToSpecialStateSub((Long)subTask.getId(), (Long)subTask.getTaskId(), (WTCSubTaskEntity)subTask, (String)"wtte_tie");
            if (!success) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\u3002", (String)"TieExporterStdImpl_8", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            this.cacheMap.clear();
            LOGGER.debug(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f15\u64ce\u5237\u65b0\u5b50\u4efb\u52a1\u4e0e\u660e\u7ec6\u5b8c\u6210\u3002", (String)"TieExporterStdImpl_9", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        if (newState == TieState.TERMINATING || newState == TieState.TERMINATED) {
            this.cacheMap.clear();
        }
    }

    private List<WTCCalTaskDetailEntity> getEngineCauseFailDetailList(WTCTaskDetailStatus status) {
        if (this.attSubjects == null) {
            LOGGER.debug(ResManager.loadKDString((String)"\u4e0a\u62a5\u5668\u4e2d\u7684\u8003\u52e4\u4e3b\u4f53\u672a\u88ab\u521d\u59cb\u5316\uff0c\u5f15\u64ce\u53ef\u80fd\u5728\u521d\u59cb\u5316\u524d\u51fa\u73b0\u9519\u8bef\u3002", (String)"TieExporterStdImpl_10", (String)"wtc-wtes-business", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        List<WTCCalTaskDetailEntity> engineCauseFailDetailList = this.attSubjects.stream().filter(attSubject -> !this.detailAccumulator.containsKey(attSubject.getAttPersonId())).flatMap(attSubject -> attSubject.getAttFileBos().stream().map(attFileBo -> {
            TieCalTaskDetail detail = this.newTaskDetail();
            detail.setSubTaskId(this.engineState.getSubTaskId().longValue());
            detail.setAttFileBoId(attFileBo.getAttFileBoid());
            this.buildDate(detail);
            detail.setTaskDetailState(status);
            detail.setRealCalStartDate(null);
            detail.setRealCalEndDate(null);
            detail.setExCode(null);
            this.genExInfo((WTCCalTaskDetailEntity)detail, status);
            return detail;
        })).collect(Collectors.toList());
        return engineCauseFailDetailList;
    }

    private void genExInfo(WTCCalTaskDetailEntity detail, WTCTaskDetailStatus status) {
        String exInfo;
        if (status == WTCTaskDetailStatus.NOT_ACCOUNT) {
            detail.setExInfo(ResManager.loadKDString((String)"\u6838\u7b97\u8d85\u65f6\u4e2d\u6b62\u3002", (String)"TieExporterStdImpl_13", (String)"wtc-wtes-business", (Object[])new Object[0]));
            return;
        }
        if (this.alarmsBuffer.length() > 200) {
            detail.setExInfo(this.alarmsBuffer.substring(0, 200) + "...");
        } else {
            exInfo = this.alarmsBuffer.toString();
            if (exInfo.charAt(exInfo.length() - 1) == ';') {
                exInfo = exInfo.substring(0, exInfo.length() - 1);
            }
            detail.setExInfo(exInfo);
        }
        if (detail.getExInfo() == null) {
            detail.setExInfo(ResManager.loadKDString((String)"\u5f15\u64ce\u51fa\u9519\u3002", (String)"TieExporterStdImpl_11", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        if (!HRStringUtils.isEmpty((String)(exInfo = detail.getExInfo()))) {
            detail.setExInfo(exInfo.replaceFirst("ERROR:", ""));
        }
    }

    @Override
    public void addCacheLine(TieLineState tieLineState, TieState lineState) {
        if (TieMsgLevel.ERROR.name().equals(tieLineState.getMessageLevel())) {
            this.alarmsBuffer.append("pserson:").append(tieLineState.getAttPersonId()).append(' ');
            this.alarmsBuffer.append(tieLineState.getMessage());
        }
        if (lineState == TieState.TERMINATING || lineState == TieState.TERMINATED || this.isStop) {
            this.isStop = true;
            this.cacheMap.clear();
            return;
        }
        this.cacheMap.put(tieLineState.getAttPersonId(), tieLineState);
    }
}

