/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.exporter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.exporter.ITieLineExporter;
import kd.wtc.wtes.business.exporter.ITieLineStateDataPackage;
import kd.wtc.wtes.business.model.TieLineState;

public class TieLineExporterImpl
implements ITieLineExporter {
    private final TieLineState tieLineState;
    private final ITieLineStateDataPackage iTieLineStateDataPackage;

    public TieLineExporterImpl(TieLineState tieLineState, ITieLineStateDataPackage lineStateDataPackage) {
        this.tieLineState = tieLineState;
        this.iTieLineStateDataPackage = lineStateDataPackage;
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        msg = msg.length() > 200 ? msg.substring(0, 200) : msg;
        this.tieLineState.setMessage(msg);
        this.tieLineState.setMessageLevel(msgLevel.name());
    }

    @Override
    public void stateChanged(TieState oldState, TieState newState) {
        String name = newState.name();
        this.tieLineState.setStatus(name);
        if (TieState.SUCCESS.name().equals(name) || TieState.ERROR.name().equals(name) || TieState.TERMINATED.name().equals(name)) {
            this.tieLineState.setEndTime(LocalDateTime.now());
            this.tieLineState.setTaskStatusRefreshTime(LocalDateTime.now());
            this.iTieLineStateDataPackage.saveTieLineState(this.tieLineState);
        }
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getLastTieDateMap() {
        return null;
    }

    @Override
    public void finishOneChain(LocalDate chainDate) {
        this.tieLineState.setChainFinish(this.tieLineState.getChainFinish() + 1);
        LocalDate tieToDate = this.tieLineState.$getTieToDate();
        if (tieToDate == null || chainDate.isAfter(this.tieLineState.$getTieToDate())) {
            this.tieLineState.setTieToDate(chainDate);
        }
    }
}

