/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ext.model.ex;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtes.business.tie.model.ex.ExConfigExt;
import kd.sdk.wtc.wtes.business.tie.model.ex.ExRuleEntryExt;
import kd.sdk.wtc.wtes.business.tie.model.ex.ExRulePackageExt;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.ext.model.ex.ExConfigExtImpl;
import kd.wtc.wtes.business.ext.model.ex.ExRuleEntryExtImpl;
import kd.wtc.wtes.business.ext.timeseq.AbstractTimeSeqVersionExt;
import kd.wtc.wtes.business.model.rlex.ExConfig;
import kd.wtc.wtes.business.model.rlex.ExRuleEntry;
import kd.wtc.wtes.business.model.rlex.ExRulePackage;
import kd.wtc.wtes.common.util.CollectionUtils;

public class ExRulePackageExtImpl
extends AbstractTimeSeqVersionExt
implements ExRulePackageExt {
    private final ExRulePackage exRulePackage;
    private final long exProcessId;

    public ExRulePackageExtImpl(ExRulePackage exRulePackage, long exProcessId) {
        super(exRulePackage.getTimeSeqInfo());
        this.exRulePackage = exRulePackage;
        this.exProcessId = exProcessId;
    }

    public List<ExConfigExt> getConfigList(LocalDate chainDate) {
        List<TimeSeqAvailableBo<ExConfig>> configList = this.exRulePackage.getConfigList();
        List configExts = null;
        if (WTCCollections.isNotEmpty(configList)) {
            configExts = configList.stream().map(exConfigTimeSeqAvailableBo -> new ExConfigExtImpl((ExConfig)exConfigTimeSeqAvailableBo.getVersionByDate(chainDate))).collect(Collectors.toList());
        }
        return WTCCollections.unmodifiableList(configExts);
    }

    public List<ExRuleEntryExt> getEntryPackageList() {
        List ruleEntryExts = null;
        List<ExRuleEntry> entryPackageList = this.exRulePackage.getEntryPackageList();
        if (CollectionUtils.isNotEmpty(entryPackageList)) {
            ruleEntryExts = entryPackageList.stream().map(exRuleEntry -> new ExRuleEntryExtImpl((ExRuleEntry)exRuleEntry)).collect(Collectors.toList());
        }
        return WTCCollections.unmodifiableList(ruleEntryExts);
    }

    public long getExProcessId() {
        return this.exProcessId;
    }
}

