/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.quota.NewCalEffectiveDateUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.model.EmployeeDateRecorder;

public class DateRecorderInitializer {
    private static final Log log = LogFactory.getLog(DateRecorderInitializer.class);
    public static final Double precision = 1.0;
    public static final int batchSize = 1000;

    public static Map<Long, EmployeeDateRecorder> queryEmployeeDateRecorder(InitParam initRequest, Collection<Long> employeeIds) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        return DateRecorderInitializer.queryEmployeeDateRecorder(employeeIds, startDate, endDate);
    }

    public static Map<Long, EmployeeDateRecorder> queryEmployeeDateRecorder(Collection<Long> employeeIds, LocalDate startDate, LocalDate endDate) {
        LocalDate algorithmSplitDate = NewCalEffectiveDateUtils.algorithmSplitDate();
        Map<Long, EmployeeDateRecorder> newAlgorithmRecorderMap = DateRecorderInitializer.queryEmployeeDateRecorderNewAlgorithm(employeeIds, startDate, endDate, algorithmSplitDate);
        Map<Long, EmployeeDateRecorder> oldAlgorithmRecorderMap = DateRecorderInitializer.queryEmployeeDateRecorderOldAlgorithm(employeeIds, startDate, endDate, algorithmSplitDate);
        for (Map.Entry<Long, EmployeeDateRecorder> newAlEntry : newAlgorithmRecorderMap.entrySet()) {
            EmployeeDateRecorder newAlRecorder = newAlEntry.getValue();
            EmployeeDateRecorder oldAlRecorder = oldAlgorithmRecorderMap.remove(newAlEntry.getKey());
            if (oldAlRecorder == null) continue;
            newAlRecorder.setOtherAlgorithmRecorder(oldAlRecorder);
            oldAlRecorder.setOtherAlgorithmRecorder(newAlRecorder);
        }
        for (Map.Entry<Long, EmployeeDateRecorder> oldAlEntry : oldAlgorithmRecorderMap.entrySet()) {
            EmployeeDateRecorder value = oldAlEntry.getValue();
            if (value == null) continue;
            newAlgorithmRecorderMap.put(oldAlEntry.getKey(), oldAlEntry.getValue());
        }
        return newAlgorithmRecorderMap;
    }

    private static Map<Long, EmployeeDateRecorder> queryEmployeeDateRecorderOldAlgorithm(Collection<Long> employeeIds, LocalDate startDate, LocalDate endDate, LocalDate algorithmSplitDate) {
        Date expandStart = WTCDateUtils.addDays((Date)WTCDateUtils.toDate((LocalDate)startDate), (int)-1);
        Date expandEnd = WTCDateUtils.addDays((Date)WTCDateUtils.toDate((LocalDate)endDate), (int)1);
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("employeeids", new ArrayList<Long>(employeeIds));
        req.put("startdate", expandStart);
        req.put("enddate", expandEnd);
        req.put("precision", precision);
        HashMap<Long, EmployeeDateRecorder> recorderMap = new HashMap<Long, EmployeeDateRecorder>(employeeIds.size());
        Map res = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("listPersonServiceLenByDateRange success. req={}", req);
            }
            res = (Map)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listPersonServiceLenByDateRange", (Object[])new Object[]{req});
            log.info("listPersonServiceLenByDateRange success. res={}", (Object)res);
        }
        catch (Exception exp) {
            log.warn("listPersonServiceLenByDateRange error. req={}", req);
            log.warn("listPersonServiceLenByDateRange error. exp=", (Throwable)exp);
            return recorderMap;
        }
        Boolean success = (Boolean)res.get("success");
        if (success != null && success.booleanValue()) {
            Map data = (Map)res.get("data");
            if (data != null) {
                for (Map.Entry entry : data.entrySet()) {
                    Long employeeId = (Long)entry.getKey();
                    Map dateMap = (Map)entry.getValue();
                    EmployeeDateRecorder recorder = new EmployeeDateRecorder(false, algorithmSplitDate, employeeId, startDate, endDate);
                    recorder.setSocialWorkDPListAsc(DateRecorderInitializer.convertPointList("socialWork", dateMap));
                    recorder.setCompanyWorkDPListAsc(DateRecorderInitializer.convertPointList("companyWork", dateMap));
                    recorder.setComSerCountDPListAsc(DateRecorderInitializer.convertPointList("comSerCount", dateMap));
                    recorderMap.put(employeeId, recorder);
                }
            }
        } else {
            log.warn("DateRecorderInitializer call interface fail, request={}", req);
            log.warn("DateRecorderInitializer call interface fail, response={}", (Object)res);
        }
        if (log.isDebugEnabled()) {
            log.debug("DateRecorderInitializer recorderMap={}", recorderMap);
        }
        return recorderMap;
    }

    private static Map<Long, EmployeeDateRecorder> queryEmployeeDateRecorderNewAlgorithm(Collection<Long> employeeIds, LocalDate startDate, LocalDate endDate, LocalDate algorithmSplitDate) {
        Date expandStart = WTCDateUtils.addDays((Date)WTCDateUtils.toDate((LocalDate)startDate), (int)-1);
        Date expandEnd = WTCDateUtils.addDays((Date)WTCDateUtils.toDate((LocalDate)endDate), (int)1);
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("employeeids", new ArrayList<Long>(employeeIds));
        req.put("startdate", expandStart);
        req.put("enddate", expandEnd);
        req.put("precision", precision);
        HashMap<Long, EmployeeDateRecorder> recorderMap = new HashMap<Long, EmployeeDateRecorder>(employeeIds.size());
        Map res = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u65b0\u7b97\u6cd5\u63a5\u53e3listPersonServiceLenByDateRangeNew begin. req={}", req);
            }
            res = (Map)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listPersonServiceLenByDateRangeNew", (Object[])new Object[]{req});
            log.info("\u65b0\u7b97\u6cd5\u63a5\u53e3listPersonServiceLenByDateRangeNew success. res={}", (Object)res);
        }
        catch (Exception exp) {
            log.warn("\u65b0\u7b97\u6cd5\u63a5\u53e3listPersonServiceLenByDateRangeNew error. req={}", req);
            log.warn("\u65b0\u7b97\u6cd5\u63a5\u53e3listPersonServiceLenByDateRangeNew error. exp=", (Throwable)exp);
            return recorderMap;
        }
        Boolean success = (Boolean)res.get("success");
        if (success != null && success.booleanValue()) {
            Map data = (Map)res.get("data");
            if (data != null) {
                for (Map.Entry entry : data.entrySet()) {
                    Long employeeId = (Long)entry.getKey();
                    Map dateMap = (Map)entry.getValue();
                    EmployeeDateRecorder recorder = new EmployeeDateRecorder(true, algorithmSplitDate, employeeId, startDate, endDate);
                    recorder.setSocialWorkDPListAsc(DateRecorderInitializer.convertPointList("socialWork", dateMap));
                    recorder.setCompanyWorkDPListAsc(DateRecorderInitializer.convertPointList("companyWork", dateMap));
                    recorder.setComSerCountDPListAsc(DateRecorderInitializer.convertPointList("comSerCount", dateMap));
                    recorderMap.put(employeeId, recorder);
                }
            }
        } else {
            log.warn("listPersonServiceLenByDateRangeOldAlgorithm call interface fail, request={}", req);
            log.warn("listPersonServiceLenByDateRangeOldAlgorithm call interface fail, response={}", (Object)res);
        }
        if (log.isDebugEnabled()) {
            log.debug("listPersonServiceLenByDateRangeOldAlgorithm recorderMap={}", recorderMap);
        }
        return recorderMap;
    }

    private static void fillNewAlgorithmRes() {
    }

    private static List<EmployeeDateRecorder.DatePoint> convertPointList(String type, Map<String, Map<String, Double>> dateMap) {
        Map<String, Double> dateCountMap = dateMap.get(type);
        if (WTCCollections.isNotEmpty(dateCountMap)) {
            ArrayList<ZeroTimeDateRange> rangeList = new ArrayList<ZeroTimeDateRange>(dateCountMap.size());
            for (Map.Entry<String, Double> entry : dateCountMap.entrySet()) {
                String dateRange = entry.getKey();
                Double value = entry.getValue();
                if (dateRange == null || value == null) continue;
                if (precision == 1.0) {
                    int tmp = (int)value.doubleValue();
                    value = tmp;
                } else if (precision == 0.5) {
                    int tmpInt1 = (int)value.doubleValue();
                    int tmpInt2 = (int)(value + 0.5);
                    value = tmpInt1;
                    if (tmpInt1 != tmpInt2) {
                        value = value + 0.5;
                    }
                }
                String[] split = dateRange.split("~");
                Date start = WTCDateUtils.str2Date((String)split[0], (String)"yyyy-MM-dd");
                Date end = WTCDateUtils.str2Date((String)split[1], (String)"yyyy-MM-dd");
                rangeList.add(new ZeroTimeDateRange(start, end, value));
            }
            rangeList.sort(new DateAscComparator());
            ArrayList<EmployeeDateRecorder.DatePoint> pointList = new ArrayList<EmployeeDateRecorder.DatePoint>(16);
            if (WTCCollections.isNotEmpty(rangeList)) {
                ZeroTimeDateRange preRange = null;
                for (ZeroTimeDateRange dateRange : rangeList) {
                    if (preRange != null) {
                        if (!dateRange.start.equals(WTCDateUtils.addDays((Date)preRange.end, (int)1))) {
                            log.warn("DateType[{}] is not smoothly, dateCountMap={}, rangeList={}", new Object[]{type, dateCountMap, rangeList});
                            return Collections.emptyList();
                        }
                        EmployeeDateRecorder.DatePoint datePoint = new EmployeeDateRecorder.DatePoint(dateRange.start, preRange.cnt, dateRange.cnt);
                        pointList.add(datePoint);
                    } else {
                        pointList.add(new EmployeeDateRecorder.DatePoint(dateRange.start, dateRange.cnt, dateRange.cnt));
                    }
                    preRange = dateRange;
                }
            }
            return pointList;
        }
        return Collections.emptyList();
    }

    private static class ZeroTimeDateRange {
        private final Date start;
        private final Date end;
        private final Double cnt;

        public ZeroTimeDateRange(Date start, Date end, Double cnt) {
            this.start = WTCDateUtils.getZeroDate((Date)start);
            this.end = WTCDateUtils.getZeroDate((Date)end);
            this.cnt = cnt;
        }

        public String toString() {
            return "ZeroTimeDateRange{start=" + this.start + ", end=" + this.end + ", cnt=" + this.cnt + '}';
        }
    }

    private static class DateAscComparator
    implements Comparator<ZeroTimeDateRange> {
        private DateAscComparator() {
        }

        @Override
        public int compare(ZeroTimeDateRange o1, ZeroTimeDateRange o2) {
            long end2;
            long start2;
            long start1 = o1.start.getTime();
            long l = start1 - (start2 = o2.start.getTime());
            if (l != 0L) {
                return l < 0L ? -1 : 1;
            }
            long end1 = o1.end.getTime();
            l = end1 - (end2 = o2.end.getTime());
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }
    }
}

