/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountStageType;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.model.AccountPlanData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;
import kd.wtc.wtes.business.service.IAccountPlanService;
import kd.wtc.wtes.business.service.impl.AccountPlanServiceImpl;

public class QTBillInitializerAccountPlan
implements TieParamInitializer {
    protected IAccountPlanService accountPlanService;
    private static final Set<Long> excludeTiePhaseSet = Sets.newHashSetWithExpectedSize((int)16);

    public QTBillInitializerAccountPlan(IAccountPlanService accountPlanService) {
        this.accountPlanService = accountPlanService;
    }

    public QTBillInitializerAccountPlan() {
        this.accountPlanService = new AccountPlanServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        long planId;
        if (initRequest instanceof QuotaInitParamRequest) {
            QuotaRequestStd request = (QuotaRequestStd)initRequest.getRequest();
            planId = request.getPlanId();
        } else {
            TieRequest tieRequest = (TieRequest)initRequest.getRequest();
            planId = tieRequest.getPlanId();
        }
        AttPeriodTable attPeriodTable = (AttPeriodTable)initRequest.getInitParams().get("ATT_PERIOD");
        List<TieScheme> tieSchemeList = this.accountPlanService.listByAttPersonIdAndRangeDate(initRequest.getStartDate(), initRequest.getEndDate(), planId, attPeriodTable);
        List<TieScheme> newTieSchemeList = this.removeTieSchemePhase(tieSchemeList);
        AccountPlanData accountPlanData = AccountPlanData.of(newTieSchemeList);
        return InitParamResult.success(accountPlanData);
    }

    private List<TieScheme> removeTieSchemePhase(List<TieScheme> tieSchemeList) {
        for (TieScheme scheme : tieSchemeList) {
            List<TiePhaseConfig> phaseProperties = scheme.getPhaseProperties();
            ArrayList newPhaseProperties = Lists.newArrayListWithExpectedSize((int)phaseProperties.size());
            for (TiePhaseConfig phaseProperty : phaseProperties) {
                Long phaseTypeId = phaseProperty.getPhaseTypeId();
                if (excludeTiePhaseSet.contains(phaseTypeId)) continue;
                newPhaseProperties.add(phaseProperty);
            }
            scheme.setPhaseProperties(newPhaseProperties);
            List<DecisionConfig> list = scheme.getPhaseDecisions();
        }
        return tieSchemeList;
    }

    @Override
    public String category() {
        return "ACCOUNT_PLAN";
    }

    public void setAccountPlanService(IAccountPlanService accountPlanService) {
        this.accountPlanService = accountPlanService;
    }

    static {
        excludeTiePhaseSet.add(PreDataAccountStageType.PD_1080_S);
        excludeTiePhaseSet.add(PreDataAccountStageType.PD_1050_S);
        excludeTiePhaseSet.add(PreDataAccountStageType.PD_1120_S);
        excludeTiePhaseSet.add(PreDataAccountStageType.PD_1020_S);
        excludeTiePhaseSet.add(PreDataAccountStageType.PD_1040_S);
        excludeTiePhaseSet.add(PreDataAccountStageType.PD_1060_S);
        excludeTiePhaseSet.add(PreDataAccountStageType.PD_1130_S);
    }
}

