/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.util.List;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.model.AccountPlanData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;
import kd.wtc.wtes.business.service.IAccountPlanService;
import kd.wtc.wtes.business.service.impl.AccountPlanServiceImpl;

public class TieInitializerAccountPlan
implements TieParamInitializer {
    protected IAccountPlanService accountPlanService;

    public TieInitializerAccountPlan(IAccountPlanService accountPlanService) {
        this.accountPlanService = accountPlanService;
    }

    public TieInitializerAccountPlan() {
        this.accountPlanService = new AccountPlanServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        long planId;
        if (initRequest instanceof QuotaInitParamRequest) {
            QuotaRequestStd request = (QuotaRequestStd)initRequest.getRequest();
            planId = request.getPlanId();
        } else {
            TieRequest tieRequest = (TieRequest)initRequest.getRequest();
            planId = tieRequest.getPlanId();
        }
        AttPeriodTable attPeriodTable = (AttPeriodTable)initRequest.getInitParams().get("ATT_PERIOD");
        List<TieScheme> tieSchemeList = this.accountPlanService.listByAttPersonIdAndRangeDate(initRequest.getStartDate(), initRequest.getEndDate(), planId, attPeriodTable);
        AccountPlanData accountPlanData = AccountPlanData.of(tieSchemeList);
        return InitParamResult.success(accountPlanData);
    }

    @Override
    public String category() {
        return "ACCOUNT_PLAN";
    }

    public void setAccountPlanService(IAccountPlanService accountPlanService) {
        this.accountPlanService = accountPlanService;
    }
}

