/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtes.business.tie.init.attfile.AttFileQueryParamExt;
import kd.sdk.wtc.wtes.business.tie.init.attfile.OnQueryInitParamOfAttFileEvent;
import kd.sdk.wtc.wtes.business.tie.init.attfile.TieInitAttFileExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.ext.model.attfile.AttFileQueryParamExtImpl;
import kd.wtc.wtes.business.ext.utils.TieInitExtUtil;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttFilePlanPackage;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.ExAttPackage;
import kd.wtc.wtes.business.model.OtAttPackage;
import kd.wtc.wtes.business.model.TbAttPackage;
import kd.wtc.wtes.business.model.TimeZone;
import kd.wtc.wtes.business.model.VaAttPackage;
import kd.wtc.wtes.business.model.attconfig.AttPlan;
import kd.wtc.wtes.business.model.rlad.AdPlanPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.rlid.IncrDecrPlan;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.service.AttFileAttPlanImpl;
import kd.wtc.wtes.business.service.AttFileExPlanImpl;
import kd.wtc.wtes.business.service.AttFileFormulaPlanImpl;
import kd.wtc.wtes.business.service.AttFileIncrDecrPlanImpl;
import kd.wtc.wtes.business.service.AttFileOtPlanImpl;
import kd.wtc.wtes.business.service.AttFileQtPlanImpl;
import kd.wtc.wtes.business.service.AttFileTbPlanImpl;
import kd.wtc.wtes.business.service.AttFileVaPlanImpl;
import kd.wtc.wtes.business.service.impl.AttFileAdPlanImpl;

public class TieInitializerAttFile
implements TieParamInitializer {
    private static final Log logger = LogFactory.getLog(TieInitializerAttFile.class);
    private Set<AttFilePlanEnum> planEnumSet;
    private Set<String> extKeys;

    public TieInitializerAttFile() {
        this.planEnumSet = new HashSet<AttFilePlanEnum>(16);
        this.planEnumSet.add(AttFilePlanEnum.VP);
        this.planEnumSet.add(AttFilePlanEnum.TP);
        this.planEnumSet.add(AttFilePlanEnum.OTP);
        this.planEnumSet.add(AttFilePlanEnum.IDP);
        this.planEnumSet.add(AttFilePlanEnum.EXS);
        this.planEnumSet.add(AttFilePlanEnum.ATT);
        this.planEnumSet.add(AttFilePlanEnum.AD);
        if (WTCGrayscaleUtils.isFormulaOpen().booleanValue()) {
            this.planEnumSet.add(AttFilePlanEnum.FM);
        }
    }

    public TieInitializerAttFile(Set<AttFilePlanEnum> planEnumSet) {
        this.planEnumSet = planEnumSet;
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        List<Long> attPersonIds = initRequest.getAttPersonIds();
        LocalDate startDate = initRequest.getStartDate();
        AttPeriodTable attPeriodTable = (AttPeriodTable)initRequest.getInitParams().get("ATT_PERIOD");
        Optional<PerAttPeriod> minPeriod = attPeriodTable.getAccountMinAttPeriodBeginDate();
        if (minPeriod.isPresent()) {
            LocalDate minPeriodDate = WTCDateUtils.toLocalDate((Date)minPeriod.get().getPerAttBeginDate());
            startDate = minPeriodDate.isBefore(startDate) ? minPeriodDate : startDate;
        }
        LocalDate endDate = initRequest.getEndDate();
        Optional<PerAttPeriod> maxAttPeriodEndDate = attPeriodTable.getAccountMaxAttPeriodEndDate();
        if (maxAttPeriodEndDate.isPresent()) {
            LocalDate maxPeriodDate = WTCDateUtils.toLocalDate((Date)maxAttPeriodEndDate.get().getPerAttEndDate());
            endDate = maxPeriodDate.isAfter(endDate) ? maxPeriodDate : endDate;
        }
        logger.debug("init attFile initRequest attPersonIds {},startDate{},endDate{}", new Object[]{attPersonIds, startDate, initRequest.getEndDate()});
        AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
        ArrayList attFileQueryParamList = Lists.newArrayListWithExpectedSize((int)2);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(WTCDateUtils.toDate((LocalDate)startDate), WTCDateUtils.toDate((LocalDate)endDate));
        attFileQueryParam.setAttPersonSetIds(new HashSet<Long>(attPersonIds));
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        String properties = "atttag.attendstatus,id,boid,attperson.id,bsed,bsled,number,startdate,enddate,dependency.name,dependency.id,org.id,empposorgrel.id,empposorgrel.datastatus,cmpemp.id,empposorgrel.adminorg.id,cmpemp.company.id,empposorgrel.job.id,empposorgrel.position.id,affiliateadminorg.id,empgroup.id,dependencytype.id,workplace.id,ismanaged,atttag.id,org.number,dependency.number,affiliateadminorg.number,dependencytype.number,workplace.number,atttag.number,empgroup.number,employee.id,depemp.id,person.id,company.id";
        attFileQueryParam.setProperties(properties);
        this.extKeys = Sets.newHashSet();
        this.invokeAttFileInitExtPlugin(attFileQueryParam, this.extKeys);
        attFileQueryParamList.add(attFileQueryParam);
        List attFileDyCollection = queryService.queryAttFiles((List)attFileQueryParamList);
        if (attFileDyCollection.isEmpty()) {
            return InitParamResult.success(new AttFileCabinet(Collections.emptyMap()));
        }
        Map<Long, List<DynamicObject>> affiliateAdminOrgVidMap = this.queryAffiliateAdminOrgVid(attFileDyCollection);
        List<Long> attFileIds = attFileDyCollection.stream().map(attFileDy -> attFileDy.getLong("boid")).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.debug("init attFile attFileIds {}", attFileIds);
        }
        List planList = this.planEnumSet.stream().map(AttFilePlanEnum::getSign).collect(Collectors.toList());
        planList.addAll(Arrays.asList(AttFileScheduleEnum.CARD.getKey(), AttFileScheduleEnum.MODE.getKey(), AttFileScheduleEnum.PERIOD.getKey()));
        AttFileScheduleServiceImpl instance = AttFileScheduleServiceImpl.getInstance();
        Map scheduleMap = instance.queryAttFileSchedule(planList, attFileIds);
        this.loadTimeZone(scheduleMap, attFileIds);
        AttFilePlanPackage attFilePlanPackage = this.setAttFilePlanMap(initRequest, attFileDyCollection, scheduleMap);
        Map<Long, List<DynamicObject>> attFileDyMap = attFileDyCollection.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("attperson.id")));
        HashMap attFileTimeSeqBoMap = Maps.newHashMapWithExpectedSize((int)attFileDyMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entries : attFileDyMap.entrySet()) {
            Long attPersonId = entries.getKey();
            List<DynamicObject> attFileOnePersonDyList = entries.getValue();
            Map<Long, List<DynamicObject>> attFileOneBoDyMap = attFileOnePersonDyList.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("boid")));
            ArrayList attFileOnePersonTimeSeqBoList = Lists.newArrayListWithExpectedSize((int)attFileOneBoDyMap.size());
            for (Map.Entry<Long, List<DynamicObject>> attFileEntries : attFileOneBoDyMap.entrySet()) {
                List<DynamicObject> boFileDyList = attFileEntries.getValue();
                ArrayList oneBoAttFileModelList = Lists.newArrayListWithExpectedSize((int)boFileDyList.size());
                for (DynamicObject file : boFileDyList) {
                    this.getOneAttFileTimeSeqBo(oneBoAttFileModelList, file, attFilePlanPackage, scheduleMap, affiliateAdminOrgVidMap);
                }
                TimeSeqBo attFileOneTimeSeqBo = TimeSeqBo.ofMultiTimeSeq((Collection)oneBoAttFileModelList);
                attFileOnePersonTimeSeqBoList.add(attFileOneTimeSeqBo);
            }
            attFileTimeSeqBoMap.put(attPersonId, attFileOnePersonTimeSeqBoList);
        }
        return InitParamResult.success(new AttFileCabinet(attFileTimeSeqBoMap));
    }

    private void loadTimeZone(Map<String, Map<Long, List<DynamicObject>>> scheduleMap, List<Long> attFileIds) {
        Map timeZoneListMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(attFileIds, AttFileScheduleEnum.TZ, true);
        scheduleMap.put(AttFileScheduleEnum.TZ.getKey(), timeZoneListMap);
    }

    private Map<Long, List<DynamicObject>> queryAffiliateAdminOrgVid(List<DynamicObject> attFileDyCollection) {
        QFilter qFilter = WTCHisServiceHelper.validQFilter();
        List ids = attFileDyCollection.stream().map(attFileDy -> attFileDy.getLong("affiliateadminorg.id")).collect(Collectors.toList());
        qFilter.and("boid", "in", ids);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject[] dys = helper.queryOriginalArray("id, boid, bsed, bsled", new QFilter[]{qFilter});
        return Arrays.stream(dys).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    private AttFilePlanPackage setAttFilePlanMap(InitParam initRequest, List<DynamicObject> attFileDyCollection, Map<String, Map<Long, List<DynamicObject>>> scheduleMap) {
        AttFilePlanPackage attFilePlanPackage = new AttFilePlanPackage();
        for (AttFilePlanEnum attFilePlanEnum : this.planEnumSet) {
            HashSet planSetIds = Sets.newHashSetWithExpectedSize((int)16);
            planSetIds.add(attFilePlanEnum.getDefaultPlanId());
            attFileDyCollection.forEach(dynamicObject -> {
                List scheduleList = (List)((Map)scheduleMap.get(attFilePlanEnum.getSign())).get(dynamicObject.getLong("boid"));
                if (scheduleList == null) {
                    return;
                }
                planSetIds.addAll(scheduleList.stream().map(object -> object.getLong(attFilePlanEnum.getEntityId())).collect(Collectors.toSet()));
            });
            if (planSetIds.isEmpty()) continue;
            switch (attFilePlanEnum) {
                case VP: {
                    AttFileVaPlanImpl vaPlanImpl = new AttFileVaPlanImpl();
                    Map<Long, TimeSeqAvailableBo<VaAttPackage>> attFileVaSeqMap = vaPlanImpl.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileVpMap(attFileVaSeqMap);
                    break;
                }
                case TP: {
                    AttFileTbPlanImpl tbPlanImpl = new AttFileTbPlanImpl();
                    Map<Long, TimeSeqBo<TbAttPackage>> attFileTbSeqMap = tbPlanImpl.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileTpMap(attFileTbSeqMap);
                    break;
                }
                case OTP: {
                    AttFileOtPlanImpl otPlanImpl = new AttFileOtPlanImpl();
                    Map<Long, TimeSeqBo<OtAttPackage>> attFileOtSeqMap = otPlanImpl.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileOtpMap(attFileOtSeqMap);
                    break;
                }
                case EXS: {
                    AttFileExPlanImpl exPlanImpl = new AttFileExPlanImpl();
                    Map<Long, TimeSeqAvailableBo<ExAttPackage>> attFileExSeqMap = exPlanImpl.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileExpMap(attFileExSeqMap);
                    break;
                }
                case IDP: {
                    AttFileIncrDecrPlanImpl incrDecrPlanImpl = new AttFileIncrDecrPlanImpl();
                    Map<Long, TimeSeqBo<IncrDecrPlan>> attFileIncrDecrSeqMap = incrDecrPlanImpl.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileIdpMap(attFileIncrDecrSeqMap);
                    break;
                }
                case ATT: {
                    AttFileAttPlanImpl attFileAttPlan = new AttFileAttPlanImpl();
                    Map<Long, TimeSeqBo<AttPlan>> attFilePlanSeqMap = attFileAttPlan.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileAttMap(attFilePlanSeqMap);
                    break;
                }
                case QT: {
                    long startTime = System.currentTimeMillis();
                    AttFileQtPlanImpl attFileQTPlan = new AttFileQtPlanImpl();
                    Map<Long, TimeSeqAvailableBo<QTScheme>> qtFilePlanSeqMap = attFileQTPlan.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileQtMap(qtFilePlanSeqMap);
                    long endTime = System.currentTimeMillis();
                    logger.debug("init qtPlan info useTime{}", (Object)(endTime - startTime));
                    break;
                }
                case AD: {
                    AttFileAdPlanImpl attFileAdPlanImpl = new AttFileAdPlanImpl();
                    Map<Long, TimeSeqBo<AdPlanPackage>> attFileAdPlanSeqMap = attFileAdPlanImpl.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileAdMap(attFileAdPlanSeqMap);
                    break;
                }
                case FM: {
                    AttFileFormulaPlanImpl attFileFormulaPlan = new AttFileFormulaPlanImpl();
                    Map<Long, TimeSeqBo<FormulaPlanPackage>> attFileFormulaPlanSeqMap = attFileFormulaPlan.getAttFilePlanSeq(planSetIds, initRequest);
                    attFilePlanPackage.setAttFileFormulaPlanMap(attFileFormulaPlanSeqMap);
                    break;
                }
            }
        }
        return attFilePlanPackage;
    }

    private void getOneAttFileTimeSeqBo(List<AttFileModel> onePersonAttFileModelList, DynamicObject file, AttFilePlanPackage attFilePlanPackage, Map<String, Map<Long, List<DynamicObject>>> scheduleMap, Map<Long, List<DynamicObject>> affiliateAdminOrgVidMap) {
        long attPersonId = file.getLong("attperson.id");
        TimeSeqInfoImpl fileTimeSeqEntity = (TimeSeqInfoImpl)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().bsed(WTCDateUtils.toLocalDate((Date)file.getDate("bsed"))).blsed(WTCDateUtils.toLocalDate((Date)file.getDate("bsled"))).bid(file.getLong("boid")).vid(file.getLong("id")).number(file.getString("number"))).build();
        List<AttFileScheduleEntity<AttModeEnum>> attModesList = this.getModeEntryList(file, scheduleMap);
        List<AttFileScheduleEntity<TimeZone>> timeZoneList = this.getTimeZoneEntryList(file, scheduleMap);
        List<AttFileScheduleEntity<String>> attCardList = this.getCardEntryList(file, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<VaAttPackage>>> attVaPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileVpMap(), AttFilePlanEnum.VP, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<TbAttPackage>>> attTpPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileTpMap(), AttFilePlanEnum.TP, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<ExAttPackage>>> attExsPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileExpMap(), AttFilePlanEnum.EXS, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<OtAttPackage>>> attOtPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileOtpMap(), AttFilePlanEnum.OTP, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<IncrDecrPlan>>> attIdPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileIdpMap(), AttFilePlanEnum.IDP, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<QTScheme>>> attQtPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileQtMap(), AttFilePlanEnum.QT, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<AttPlan>>> attAttPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileAttMap(), AttFilePlanEnum.ATT, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<AdPlanPackage>>> attAdPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileAdMap(), AttFilePlanEnum.AD, scheduleMap);
        List<AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>>> attFormulaPlanList = this.getPlanEntryList(file, attFilePlanPackage.getAttFileFormulaPlanMap(), AttFilePlanEnum.FM, scheduleMap);
        AttFileModel attFileModel = AttFileModel.withTimeSeq(fileTimeSeqEntity).attPersonId(attPersonId).startDate(WTCDateUtils.toLocalDate((Date)file.getDate("startdate"))).endDate(WTCDateUtils.toLocalDate((Date)file.getDate("enddate"))).dependency(file.getString("dependency.name")).dependencyId(file.getLong("dependency.id")).orgId(file.getLong("org.id")).empposorgrelId(file.getLong("empposorgrel.id")).epRelStatusEnum(file.getString("empposorgrel.datastatus")).cmpempId(file.getLong("cmpemp.id")).adminOrgId(file.getLong("empposorgrel.adminorg.id")).companyId(file.getLong("company.id")).jobId(file.getLong("empposorgrel.job.id")).positionId(file.getLong("empposorgrel.position.id")).affiliateAdminOrgBid(file.getLong("affiliateadminorg.id")).affiliateAdminOrgVid(affiliateAdminOrgVidMap.get(file.getLong("affiliateadminorg.id"))).empGroup(file.getLong("empgroup.id")).dependencyType(file.getLong("dependencytype.id")).workplace(file.getLong("workplace.id")).attCardList(attCardList).attModesList(attModesList).timeZoneList(timeZoneList).attExPackageList(attExsPlanList).attTbPackageList(attTpPlanList).attVaPackageList(attVaPlanList).attOtPackageList(attOtPlanList).attIdPackageList(attIdPlanList).attAttPackageList(attAttPlanList).attQtPackageList(attQtPlanList).attAdPackageList(attAdPlanList).attFormulaPlanPackageList(attFormulaPlanList).number(file.getString("number")).isManaged(file.getBoolean("ismanaged")).attTagId(file.getLong("atttag.id")).orgNumber(file.getString("org.number")).dependencyNumber(file.getString("dependency.number")).affiliateAdminOrgNumber(file.getString("affiliateadminorg.number")).dependencyTypeNumber(file.getString("dependencytype.number")).workplaceNumber(file.getString("workplace.number")).attTagNumber(file.getString("atttag.number")).empGroupNumber(file.getString("empgroup.number")).extAttribute(TieInitExtUtil.buildDataAttribute(file, this.extKeys)).employeeId(file.getLong("employee.id")).depempBoid(file.getLong("depemp.id")).personBoid(file.getLong("person.id")).build();
        onePersonAttFileModelList.add(attFileModel);
    }

    private List<AttFileScheduleEntity<TimeZone>> getTimeZoneEntryList(DynamicObject file, Map<String, Map<Long, List<DynamicObject>>> scheduleMap) {
        String key = AttFileScheduleEnum.TZ.getKey();
        List<DynamicObject> scheduleDys = scheduleMap.get(key).get(file.getLong("boid"));
        int size = scheduleDys == null ? 1 : scheduleDys.size();
        ArrayList timeZoneList = Lists.newArrayListWithExpectedSize((int)size);
        if (CollectionUtils.isEmpty(scheduleDys)) {
            return timeZoneList;
        }
        for (DynamicObject timeZone : scheduleDys) {
            AttFileScheduleEntity timeZoneEntryEntity = AttFileScheduleEntity.with().id(timeZone.getLong("id")).startDate(WTCDateUtils.toLocalDate((Date)timeZone.getDate("bsed"))).endDate(WTCDateUtils.toLocalDate((Date)timeZone.getDate("bsled"))).entity((Object)new TimeZone(timeZone.getInt("tz.timedif"), timeZone.getLong("tz.id"), timeZone.getString("tz.number"))).build();
            timeZoneList.add(timeZoneEntryEntity);
        }
        return timeZoneList;
    }

    private <T> List<AttFileScheduleEntity<T>> getPlanEntryList(DynamicObject file, Map<Long, T> map, AttFilePlanEnum attFilePlanEnum, Map<String, Map<Long, List<DynamicObject>>> scheduleMap) {
        Map<Long, List<DynamicObject>> planEntry = scheduleMap.get(attFilePlanEnum.getSign());
        if (planEntry == null) {
            return Collections.emptyList();
        }
        List<DynamicObject> scheduleDys = planEntry.get(file.getLong("boid"));
        int size = scheduleDys == null ? 1 : scheduleDys.size();
        ArrayList attPlanList = Lists.newArrayListWithExpectedSize((int)size);
        if (scheduleDys == null || scheduleDys.isEmpty()) {
            return attPlanList;
        }
        for (DynamicObject scheduleDy : scheduleDys) {
            long planId = scheduleDy.getLong(attFilePlanEnum.getEntityId());
            T obj = map.get(planId);
            AttFileScheduleEntity planEntryEntity = AttFileScheduleEntity.with().id(scheduleDy.getLong("id")).startDate(WTCDateUtils.toLocalDate((Date)scheduleDy.getDate("startdate"))).endDate(WTCDateUtils.toLocalDate((Date)scheduleDy.getDate("enddate"))).entity(obj).build();
            attPlanList.add(planEntryEntity);
        }
        return attPlanList;
    }

    private List<AttFileScheduleEntity<String>> getCardEntryList(DynamicObject file, Map<String, Map<Long, List<DynamicObject>>> scheduleMap) {
        String key = AttFileScheduleEnum.CARD.getKey();
        List<DynamicObject> scheduleDys = scheduleMap.get(key).get(file.getLong("boid"));
        int size = scheduleDys == null ? 1 : scheduleDys.size();
        ArrayList attCardList = Lists.newArrayListWithExpectedSize((int)size);
        if (CollectionUtils.isEmpty(scheduleDys)) {
            return attCardList;
        }
        for (DynamicObject card : scheduleDys) {
            AttFileScheduleEntity cardEntryEntity = AttFileScheduleEntity.with().id(card.getLong("id")).startDate(WTCDateUtils.toLocalDate((Date)card.getDate("bsed"))).endDate(WTCDateUtils.toLocalDate((Date)card.getDate("bsled"))).entity((Object)card.getString(key)).build();
            attCardList.add(cardEntryEntity);
        }
        return attCardList;
    }

    private List<AttFileScheduleEntity<AttModeEnum>> getModeEntryList(DynamicObject file, Map<String, Map<Long, List<DynamicObject>>> scheduleMap) {
        String key = AttFileScheduleEnum.MODE.getKey();
        List<DynamicObject> scheduleDys = scheduleMap.get(key).get(file.getLong("boid"));
        int size = scheduleDys == null ? 1 : scheduleDys.size();
        ArrayList attModesList = Lists.newArrayListWithExpectedSize((int)size);
        if (CollectionUtils.isEmpty(scheduleDys)) {
            return attModesList;
        }
        for (DynamicObject mode : scheduleDys) {
            AttFileScheduleEntity modeEntryEntity = AttFileScheduleEntity.with().id(mode.getLong("id")).startDate(WTCDateUtils.toLocalDate((Date)mode.getDate("bsed"))).endDate(WTCDateUtils.toLocalDate((Date)mode.getDate("bsled"))).entity((Object)AttModeEnum.of((String)mode.getString(key))).build();
            attModesList.add(modeEntryEntity);
        }
        return attModesList;
    }

    @Override
    public String category() {
        return "ATT_FILE";
    }

    private void invokeAttFileInitExtPlugin(AttFileQueryParam attFileQueryParam, Set<String> extKeys) {
        WTCPluginProxy tieInitParamExtPluginProxy = WTCPluginProxyFactory.create(TieInitAttFileExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.attfile.TieInitAttFileExtPlugin");
        tieInitParamExtPluginProxy.invokeReplace(plugin -> {
            OnQueryInitParamOfAttFileEvent event = new OnQueryInitParamOfAttFileEvent((AttFileQueryParamExt)new AttFileQueryParamExtImpl(attFileQueryParam));
            plugin.onQueryAttFile(event);
            if (WTCCollections.isNotEmpty((Collection)event.getExtKeys())) {
                HashSet<String> propertiesSet = new HashSet<String>(Arrays.asList(WTCStringUtils.split((String)attFileQueryParam.getProperties(), (String)",")));
                extKeys.addAll(event.getExtKeys());
                propertiesSet.addAll(extKeys);
                attFileQueryParam.setProperties(WTCStringUtils.join(new ArrayList<String>(propertiesSet), (String)","));
            }
        });
    }
}

