/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitException;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.util.BillTieRetrievalUtil;

public class TieInitializerBillRetrieval
implements TieParamInitializer {
    private static final Log LOG = LogFactory.getLog(TieInitializerBillRetrieval.class);

    @Override
    public InitParamResult init(InitParam initRequest) throws TieParamInitException {
        try {
            BillTieRetrievalUtil retrievalUtil = new BillTieRetrievalUtil(initRequest);
            return InitParamResult.success(retrievalUtil.getBillRetrievalResult());
        }
        catch (KDException exception) {
            TieMessageStd msg = new TieMessageStd(TieMsgLevel.ERROR, exception.getMessage());
            return InitParamResult.success(msg);
        }
        catch (Exception ex) {
            String errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u8ba1\u7b97\u89c4\u5219\u53d6\u6570\u521d\u59cb\u5316\u5f02\u5e38\uff1a{0}\u3002", (String)"TieInitializerBillRetrieval_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
            LOG.warn(errorMsg, (Throwable)ex);
            TieMessageStd msg = new TieMessageStd(TieMsgLevel.ERROR, errorMsg);
            return InitParamResult.success(msg);
        }
    }

    @Override
    public String category() {
        return "RETRIEVEL";
    }
}

