/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.ConstParam;
import kd.wtc.wtes.business.service.ConstParamData;
import kd.wtc.wtes.business.service.IConstParamService;
import kd.wtc.wtes.business.service.impl.ConstParamServiceImpl;

public class TieInitializerConstParam
implements TieParamInitializer {
    protected IConstParamService iConstParamService;

    public TieInitializerConstParam(IConstParamService iConstParamService) {
        this.iConstParamService = iConstParamService;
    }

    public TieInitializerConstParam() {
        this.iConstParamService = new ConstParamServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        Map<Long, List<ConstParam>> bo2His = this.getConstParam(initRequest);
        ConstParamData constParamData = ConstParamData.of(this.listTimeSeqBo(bo2His));
        return InitParamResult.success(constParamData);
    }

    private Map<Long, List<ConstParam>> getConstParam(InitParam initRequest) {
        Optional<PerAttPeriod> optionalMax;
        LocalDate periodEndDate;
        AttPeriodTable attPeriodTable = (AttPeriodTable)initRequest.getInitParams().get("ATT_PERIOD");
        Optional<PerAttPeriod> optionalMin = attPeriodTable.getAccountMinAttPeriodBeginDate();
        LocalDate periodStartDate = optionalMin.isPresent() ? WTCDateUtils.toLocalDate((Date)optionalMin.get().getPerAttBeginDate()) : initRequest.getStartDate();
        List<ConstParam> attItemSpecs = this.iConstParamService.listValidHisVersionsInRangeDate(periodStartDate, periodEndDate = (optionalMax = attPeriodTable.getAccountMaxAttPeriodEndDate()).isPresent() ? WTCDateUtils.toLocalDate((Date)optionalMax.get().getPerAttEndDate()) : initRequest.getEndDate());
        if (attItemSpecs.isEmpty()) {
            return Collections.emptyMap();
        }
        return attItemSpecs.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
    }

    private List<TimeSeqBo<ConstParam>> listTimeSeqBo(Map<Long, List<ConstParam>> bo2His) {
        ArrayList<TimeSeqBo<ConstParam>> constParamBo = new ArrayList<TimeSeqBo<ConstParam>>(bo2His.size());
        bo2His.forEach((bid, constParams) -> {
            TimeSeqBo timeSeqBo = TimeSeqBo.ofMultiTimeSeq((Collection)constParams);
            constParamBo.add(timeSeqBo);
        });
        return constParamBo;
    }

    @Override
    public String category() {
        return "CONST_PARAM";
    }

    public void setiConstParamService(IConstParamService iConstParamService) {
        this.iConstParamService = iConstParamService;
    }
}

