/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitException;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.attconfig.AttRuleCal;
import kd.wtc.wtes.common.lang.WtesException;

public class TieInitializerDateRange
implements TieParamInitializer {
    private static final Log LOG = LogFactory.getLog(AttRuleCal.class);
    private final Map<Long, AccessDto> contidionMap = new HashMap<Long, AccessDto>(16);

    @Override
    public InitParamResult init(InitParam initRequest) throws TieParamInitException {
        Map dynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)"wtbd_daterange", (String)"basedataid,conditions", (QFilter[])new QFilter[0]);
        this.mappingBaseDateIdToConditions(dynamicObjectsMap);
        return InitParamResult.success(this.contidionMap);
    }

    private void mappingBaseDateIdToConditions(Map<Object, DynamicObject> dynamicObjectsMap) {
        dynamicObjectsMap.values().forEach(dynamicObject -> {
            long basedataid = dynamicObject.getLong("basedataid");
            String conditions = dynamicObject.getString("conditions");
            AccessDto accessDto = null;
            if (HRStringUtils.isNotEmpty((String)conditions)) {
                try {
                    accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditions, AccessDto.class);
                }
                catch (Exception e) {
                    LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                    throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
                }
            }
            this.contidionMap.put(basedataid, accessDto);
        });
    }

    public AccessDto getConditionByBaseDateId(Long baseDateId) {
        return this.contidionMap.get(baseDateId);
    }

    @Override
    public String category() {
        return "DATE_RANGE";
    }
}

