/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.wtte.common.enums.ExConfirmOperateTypeEnum;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitException;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.ExConfirmInfo;
import kd.wtc.wtes.business.service.impl.ExRecordServiceImpl;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;

public class TieInitializerExConfirmStatus
implements TieParamInitializer {
    private static final String WTTE_EXRECORDCONFIRM = "wtte_exrecordconfirm";
    private static final String PERSON_ID = "personid";
    private static final String RECORD_DATE = "recorddate";
    private static final String FIELD_ISLATEST = "islatest";
    private static final String FIELD_OPERATE_TYPE = "operatetype";
    private static final String CONFIRM_PEOPLE = "confirmpeople";
    private static final String CONFIRM_TIME = "confirmtime";
    private static final String ATT_ITEM_VALUE = "attitemvalue";
    private static final HRBaseServiceHelper CONFIRM_HELPER = WtesHRBaseTimeWatchUtil.create(ExRecordServiceImpl.class.getName() + "." + "wtte_exrecordconfirm", "wtte_exrecordconfirm");

    @Override
    public InitParamResult init(InitParam initRequest) throws TieParamInitException {
        List<Long> attPersonIds = initRequest.getAttPersonIds();
        Date startDate = WTCDateUtils.toDate((LocalDate)initRequest.getStartDate());
        Date endDate = WTCDateUtils.toDate((LocalDate)initRequest.getEndDate());
        QFilter personQf = new QFilter(PERSON_ID, "in", attPersonIds);
        QFilter startDateQf = new QFilter(RECORD_DATE, ">=", (Object)startDate);
        QFilter endDateQf = new QFilter(RECORD_DATE, "<=", (Object)endDate);
        QFilter isNew = new QFilter(FIELD_ISLATEST, "=", (Object)Boolean.TRUE);
        String join = String.join((CharSequence)",", RECORD_DATE, CONFIRM_PEOPLE, CONFIRM_TIME, ATT_ITEM_VALUE, FIELD_ISLATEST, FIELD_OPERATE_TYPE);
        String select = "personid.id  ,punchcardpair.id ,attitemid.id ," + join;
        DynamicObject[] oldRecords = CONFIRM_HELPER.query(select, new QFilter[]{personQf, startDateQf, endDateQf, isNew});
        if (null == oldRecords || oldRecords.length == 0) {
            return InitParamResult.success(Collections.emptyMap());
        }
        Map exConfirmInfoMap = Arrays.stream(oldRecords).collect(Collectors.groupingBy(dyn -> dyn.get("personid.id").toString() + dyn.get(RECORD_DATE) + dyn.get("punchcardpair.id") + dyn.get("attitemid.id"), Collectors.mapping(this::getConfirmInfo, Collectors.toList())));
        return InitParamResult.success(exConfirmInfoMap);
    }

    @Override
    public String category() {
        return "EX_CONFIG_STATUS";
    }

    private ExConfirmInfo getConfirmInfo(DynamicObject dynamicObject) {
        ExConfirmInfo exConfirmInfo = new ExConfirmInfo();
        exConfirmInfo.setId(dynamicObject.getLong("id"));
        exConfirmInfo.setAttItemValue(dynamicObject.getBigDecimal(ATT_ITEM_VALUE));
        exConfirmInfo.setExConfirmOperateTypeEnum(ExConfirmOperateTypeEnum.getEnumByCode((String)dynamicObject.getString(FIELD_OPERATE_TYPE)));
        return exConfirmInfo;
    }
}

