/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.lang.WTCErrorCodes;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.service.ShiftService;
import kd.wtc.wtes.business.std.TieMessageStd;

public class TieInitializerRoster
implements TieParamInitializer {
    private static final Log logger = LogFactory.getLog(TieInitializerRoster.class);

    private Date getINbDay(LocalDate baseLocalDate, int day) {
        Date eachDate = WTCDateUtils.toDate((LocalDate)baseLocalDate);
        return HRDateTimeUtils.addDay((Date)eachDate, (long)day);
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        try {
            return this.initData(initRequest);
        }
        catch (WTCBizException wtcBizException) {
            logger.info("TieInitializerRoster.wtcBizException.{},{}", (Object)wtcBizException.getErrorCode(), (Object)wtcBizException.getMessage());
            if (wtcBizException.getErrorCode() != null && WTCErrorCodes.QUERY_OVER_MAX_SIZE.getCode().equals(wtcBizException.getErrorCode().getCode())) {
                String overMaxSizeTip = ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6863\u6848\u9700\u8981\u83b7\u53d6\u7684\u6392\u73ed\u4fe1\u606f\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u7f29\u51cf\u6838\u7b97\u65e5\u671f\u8303\u56f4\uff0c\u6216\u63a8\u8fdf\u8003\u52e4\u6863\u6848\u4e2d\u7684\u201c\u6700\u65e9\u5141\u8bb8\u91cd\u7b97\u65e5\u671f\u201d\uff0c\u4ee5\u51cf\u7f13\u6570\u636e\u538b\u529b\u3002", (String)"TieInitializerRoster_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
                return InitParamResult.exclusion(new TieMessageStd(TieMsgLevel.ERROR, overMaxSizeTip));
            }
            return InitParamResult.exclusion(new TieMessageStd(TieMsgLevel.ERROR, wtcBizException.getMessage()));
        }
        catch (Exception ex) {
            logger.warn("TieInitializerRoster.warn", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitParamResult initData(InitParam initRequest) {
        ShiftTableSingle shiftTableSingle;
        LocalDate date;
        List<Long> attPersonIds = initRequest.getAttPersonIds();
        AttPeriodTable attPeriodTable = (AttPeriodTable)initRequest.getInitParams().get("ATT_PERIOD");
        Set<LocalDate> eachPerAttBeginDate = attPeriodTable.getEachPerAttBeginDate(Sets.newHashSet(initRequest.getAttPersonIds()), initRequest.getStartDate(), initRequest.getEndDate());
        logger.debug("TieInitializerRoster init attFile initRequest attPersonIds {},startDate{},endDate{}", new Object[]{attPersonIds, initRequest.getStartDate(), initRequest.getEndDate()});
        HashSet allQueryDate = Sets.newHashSetWithExpectedSize((int)eachPerAttBeginDate.size());
        for (LocalDate localDate : eachPerAttBeginDate) {
            allQueryDate.add(this.getINbDay(localDate, -1));
            allQueryDate.add(this.getINbDay(localDate, -2));
            allQueryDate.add(this.getINbDay(localDate, 1));
            allQueryDate.add(this.getINbDay(localDate, 2));
            allQueryDate.add(WTCDateUtils.toDate((LocalDate)localDate));
        }
        Date startDate = this.getINbDay(initRequest.getStartDate(), -2);
        Date endDate = this.getINbDay(initRequest.getEndDate(), 2);
        Map shiftDutyMap = new HashMap(16);
        if (attPersonIds == null || attPersonIds.isEmpty()) {
            return InitParamResult.exclusion(new TieMessageStd(TieMsgLevel.WARNING, "TieInitializerRoster.init.param is null"));
        }
        logger.debug("TieInitializerRoster init step 1, allQueryDate size: {}", (Object)allQueryDate.size());
        LocalDate localDate = initRequest.getStartDate();
        synchronized (localDate) {
            List<Long> attFileBoIdList = initRequest.getAttFileBoIdList();
            logger.debug("TieInitializerRoster init step 3, attFileBoIdList size: {}", (Object)attFileBoIdList.size());
            DutyShiftResponse shiftResponse = EvaluationServiceHelper.getDutyShiftByAttFileBoIdWithDateList(attFileBoIdList, (Date)startDate, (Date)endDate, new ArrayList(allQueryDate));
            logger.debug("TieInitializerRoster init step 4, shiftResponse");
            shiftDutyMap = shiftResponse.getDutyShiftMap();
            logger.debug("TieInitializerRoster init step 5, shiftDutyMap");
        }
        HashMap shiftTableMap = Maps.newHashMapWithExpectedSize((int)shiftDutyMap.size());
        HashSet shiftSets = Sets.newHashSetWithExpectedSize((int)shiftDutyMap.size());
        for (List value : shiftDutyMap.values()) {
            shiftSets.addAll(value.stream().map(DutyShift::getShiftId).collect(Collectors.toSet()));
        }
        logger.debug("TieInitializerRoster init step 6, shiftSets:{}", (Object)shiftSets);
        Map<Long, TimeSeqBo<ShiftSpec>> shiftSeqMap = ShiftService.getShiftByIds(shiftSets, startDate, endDate);
        logger.debug("TieInitializerRoster init step 7, shiftSeqMap size:{}", (Object)shiftSeqMap.size());
        List list = shiftDutyMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        AttFileCabinet attFileCabinet = (AttFileCabinet)initRequest.getInitParams().get("ATT_FILE");
        Map<Long, List<DutyShift>> map = list.stream().collect(Collectors.groupingBy(dutyShift -> dutyShift.getAttPersonId()));
        for (Map.Entry<Long, List<DutyShift>> entries : map.entrySet()) {
            List<DutyShift> dutyShiftList = entries.getValue();
            Long attPerSonId = 0L;
            HashMap rosterSpecMap = Maps.newHashMapWithExpectedSize((int)dutyShiftList.size());
            for (DutyShift dutyShift2 : dutyShiftList) {
                attPerSonId = dutyShift2.getAttPersonId();
                Long attFileBaseBoId = dutyShift2.getAttFileBaseBoId();
                long shiftId = dutyShift2.getShiftId();
                if (attFileBaseBoId == null || shiftId == 0L) continue;
                LocalDate rosterLocalDate = WTCDateUtils.toLocalDate((Date)dutyShift2.getRosterDate());
                AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(attPerSonId, rosterLocalDate, attFileBaseBoId);
                if (attFileModel == null) continue;
                TimeSeqBo<ShiftSpec> shiftSpecTimeSeqBo = shiftSeqMap.get(shiftId);
                Roster roster = (Roster)rosterSpecMap.get(rosterLocalDate);
                if (null != roster) {
                    String rosterType = roster.getRosterType();
                    TimeSeqBo<ShiftSpec> temp = roster.getShiftSpecTimeSeqBo();
                    if ("1".equals(rosterType) && !temp.isEmpty()) continue;
                }
                DateType dateTypeModel = dutyShift2.getDateTypeModel();
                DateType originDateTypeModel = dutyShift2.getOriginDateTypeModel();
                DateAttribute dateAttribute = dutyShift2.getDateAttribute();
                DateAttribute orginDateAttribute = dutyShift2.getOrginDateAttribute();
                Roster.Builder builder = Roster.with().rosterDate(rosterLocalDate).rosterType(dutyShift2.getRosterType()).holiday(dutyShift2.getHoliday()).shiftSpecTimeSeqBo(shiftSpecTimeSeqBo);
                if (dateTypeModel != null) {
                    builder = builder.dateType(DateType.of((Long)dateTypeModel.getId(), (String)dateTypeModel.getNumber(), (String)dateTypeModel.getName(), (String)dateTypeModel.getChineseName(), null, (OrmLocaleValue)dateTypeModel.getOrmLocaleName()));
                }
                if (dateAttribute != null) {
                    builder = builder.dateAttribute(dateAttribute);
                }
                if (originDateTypeModel != null) {
                    builder = builder.originDateTypeModel(DateType.of((Long)originDateTypeModel.getId(), (String)originDateTypeModel.getNumber(), null));
                }
                if (orginDateAttribute != null) {
                    builder = builder.orginDateAttribute(orginDateAttribute);
                }
                rosterSpecMap.put(rosterLocalDate, builder.build());
            }
            ShiftTableSingle shiftTableSingle2 = ShiftTableSingle.with().attPersonId(attPerSonId).rosterSpecMap(rosterSpecMap).build();
            shiftTableMap.put(attPerSonId, shiftTableSingle2);
        }
        logger.debug("TieInitializerRoster init step 8, shiftTableMap size:{}", (Object)shiftTableMap.size());
        LocalDate localDate2 = date = initRequest.getStartDate() == null ? initRequest.getEndDate() : initRequest.getStartDate();
        if (!initRequest.getAttPersonIds().isEmpty() && (shiftTableSingle = (ShiftTableSingle)shiftTableMap.get(initRequest.getAttPersonIds().get(0))) != null && logger.isDebugEnabled()) {
            logger.debug("shiftTableSingle by date, date = {}, ", (Object)shiftTableSingle.getShiftSpec(date));
        }
        logger.debug("TieInitializerRoster init step 9 end");
        return InitParamResult.success(new ShiftTable(shiftTableMap));
    }

    @Override
    public String category() {
        return "ROSTER";
    }
}

