/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.log;

import kd.wtc.wtes.business.log.TieLogLevel;
import kd.wtc.wtes.business.log.TieLogProviderEnum;

public class TieLogConfig {
    public static final String LOG_ENABLE = "tie.log.enable";
    public static final String LOG_PROVIDER = "tie.log.provider";
    public static final String LOG_LEVEL = "tie.log.level";
    public static final String APPENDER_FACTORY = "tie.log.appender.factory";
    public static final String ASYNC_BLOCK = "tie.log.async.block";
    public static final String LOG_BATCH_SIZE = "tie.log.batchsize";
    public static final String MAX_QUEUE_SIZE = "tie.log.async.maxqueuesize";
    public static final String LOG_MAX_LENGTH = "tie.log.maxlength";
    private static volatile boolean IS_TIE_LOG_ENABLE;
    private static volatile boolean IS_TIE_LOG_PROVIDER;
    private static volatile TieLogLevel LOG_LEVEL_ENUM;
    private static final boolean TEST_MODE;

    public static void enableTieLog() {
        IS_TIE_LOG_ENABLE = true;
    }

    public static void disableTieLog() {
        IS_TIE_LOG_ENABLE = false;
    }

    public static void setTieLogLevel(TieLogLevel logLevel) {
        LOG_LEVEL_ENUM = logLevel;
    }

    public static void setTieLogProvider(TieLogProviderEnum tieLogProvider) {
        IS_TIE_LOG_PROVIDER = tieLogProvider == TieLogProviderEnum.TIE;
    }

    public static boolean isEnableTieLog() {
        return IS_TIE_LOG_ENABLE;
    }

    public static boolean isTieLogProvider() {
        return false;
    }

    public static TieLogLevel getTieLogLevel() {
        return LOG_LEVEL_ENUM;
    }

    public static boolean isTest() {
        return TEST_MODE;
    }

    static {
        int tieLogEnable = Integer.getInteger(LOG_ENABLE, 1);
        IS_TIE_LOG_ENABLE = 1 == tieLogEnable;
        String loglevelStr = System.getProperty(LOG_LEVEL);
        LOG_LEVEL_ENUM = TieLogLevel.of(loglevelStr, TieLogLevel.INFO);
        String providerName = System.getProperty(LOG_PROVIDER);
        TieLogProviderEnum tieLogProvider = TieLogProviderEnum.of(providerName, TieLogProviderEnum.TIE);
        IS_TIE_LOG_PROVIDER = tieLogProvider == TieLogProviderEnum.TIE;
        TEST_MODE = "test".equals(System.getProperty("tie.running_mode"));
    }
}

