/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AdminOrg;
import kd.wtc.wtbs.business.model.attendperson.Company;
import kd.wtc.wtbs.business.model.attendperson.Job;
import kd.wtc.wtbs.business.model.attendperson.Position;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HBJMMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HBPMMServiceImpl;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.AttFileModel;

public class AttFileCabinet {
    private Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap;
    private Map<Long, TimeSeqBo<Company>> companyMap;
    private Map<Long, TimeSeqBo<AdminOrg>> adminOrgMap;
    private Map<Long, TimeSeqBo<Position>> positionMap;
    private Map<Long, TimeSeqBo<Job>> jobMap;

    public List<TimeSeqBo<AttFileModel>> getByAttPersonId(long attPersonId) {
        return this.attFileTimeSeqBoMap.getOrDefault(attPersonId, new ArrayList());
    }

    public AttFileModel getByAttPersonIdAndDate(long attPersonId, LocalDate inDate) {
        List<TimeSeqBo<AttFileModel>> attFileBoList = this.getByAttPersonId(attPersonId);
        AttFileModel result = null;
        for (TimeSeqBo<AttFileModel> attFileModelTimeSeqBo : attFileBoList) {
            result = (AttFileModel)attFileModelTimeSeqBo.getVersionByDate(inDate);
            if (null != result && result.getEndDate().compareTo(inDate) >= 0) {
                return result;
            }
            result = null;
        }
        return result;
    }

    public AttFileModel getByAttPersonIdAndDate(long attPersonId, long attFileId) {
        List<TimeSeqBo<AttFileModel>> attFileBoList = this.getByAttPersonId(attPersonId);
        for (TimeSeqBo<AttFileModel> attFileModelTimeSeqBo : attFileBoList) {
            List versions = attFileModelTimeSeqBo.getVersions();
            Optional<AttFileModel> attFileModel = versions.stream().filter(att -> att.getId() == attFileId).findFirst();
            if (!attFileModel.isPresent()) continue;
            return attFileModel.get();
        }
        return null;
    }

    public AttFileModel getByAttPersonIdAndDate(long attPersonId, LocalDate inDate, Long boid) {
        if (boid == null) {
            return this.getByAttPersonIdAndDate(attPersonId, inDate);
        }
        List<TimeSeqBo<AttFileModel>> attFileBoList = this.getByAttPersonId(attPersonId);
        AttFileModel result = null;
        for (TimeSeqBo<AttFileModel> attFileModelTimeSeqBo : attFileBoList) {
            result = (AttFileModel)attFileModelTimeSeqBo.getVersionByDate(inDate);
            if (null != result && result.getEndDate().compareTo(inDate) >= 0 && result.getBid() == boid.longValue()) {
                return result;
            }
            result = null;
        }
        return result;
    }

    public AttFileCabinet(Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap) {
        this.attFileTimeSeqBoMap = attFileTimeSeqBoMap;
        this.initCommonRelateData(attFileTimeSeqBoMap);
    }

    private void initCommonRelateData(Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap) {
        if (WTCCollections.isNotEmpty(attFileTimeSeqBoMap)) {
            int attFileTimeSeqBoMapSize = attFileTimeSeqBoMap.size();
            HashSet companySet = Sets.newHashSetWithExpectedSize((int)attFileTimeSeqBoMapSize);
            HashSet adminOrgSet = Sets.newHashSetWithExpectedSize((int)attFileTimeSeqBoMapSize);
            HashSet positionSet = Sets.newHashSetWithExpectedSize((int)attFileTimeSeqBoMapSize);
            HashSet jobSet = Sets.newHashSetWithExpectedSize((int)attFileTimeSeqBoMapSize);
            for (List<TimeSeqBo<AttFileModel>> value : attFileTimeSeqBoMap.values()) {
                if (!WTCCollections.isNotEmpty(value)) continue;
                for (TimeSeqBo<AttFileModel> attFileModelTimeSeqBo : value) {
                    for (AttFileModel version : attFileModelTimeSeqBo.getVersions()) {
                        Long companyId = version.getCompanyId();
                        Long adminOrgId = version.getAdminOrgId();
                        Long positionId = version.getPositionId();
                        Long jobId = version.getJobId();
                        if (null != companyId && 0L != companyId) {
                            companySet.add(companyId);
                        }
                        if (null != adminOrgId && 0L != adminOrgId) {
                            adminOrgSet.add(adminOrgId);
                        }
                        if (null != positionId && 0L != positionId) {
                            positionSet.add(positionId);
                        }
                        if (null == jobId || 0L == jobId) continue;
                        jobSet.add(jobId);
                    }
                }
            }
            AttendPersonServiceImpl instance = AttendPersonServiceImpl.getInstance();
            HAOSMServiceImpl instanceHaos = HAOSMServiceImpl.getInstance();
            HBJMMServiceImpl instanceHBJM = HBJMMServiceImpl.getInstance();
            Date minEndDate = WTCHisServiceHelper.getMinEndDate();
            Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
            if (WTCCollections.isNotEmpty((Collection)companySet)) {
                this.companyMap = instance.getTimeSeqBoMap(instanceHaos.batchGetOrgInfo(minEndDate, maxEndDate, new ArrayList(companySet)), (arg_0, arg_1) -> ((AttendPersonServiceImpl)instance).genCompany(arg_0, arg_1));
            }
            if (WTCCollections.isNotEmpty((Collection)adminOrgSet)) {
                this.adminOrgMap = instance.getTimeSeqBoMap(instanceHaos.batchGetOrgInfo(minEndDate, maxEndDate, new ArrayList(adminOrgSet)), (arg_0, arg_1) -> ((AttendPersonServiceImpl)instance).genAdminOrg(arg_0, arg_1));
            }
            if (WTCCollections.isNotEmpty((Collection)positionSet)) {
                this.positionMap = instance.getTimeSeqBoMap(HBPMMServiceImpl.getInstance().queryPositionHisVersion(minEndDate, maxEndDate, new ArrayList(positionSet)), (arg_0, arg_1) -> ((AttendPersonServiceImpl)instance).genPosition(arg_0, arg_1));
            }
            if (WTCCollections.isNotEmpty((Collection)jobSet)) {
                this.jobMap = instance.getTimeSeqBoMap(instanceHBJM.getJobVersionChangeInfoByEventId(minEndDate, maxEndDate, new ArrayList(jobSet)), (arg_0, arg_1) -> ((AttendPersonServiceImpl)instance).genJob(arg_0, arg_1));
            }
        }
    }

    public AttFileCabinet() {
    }

    public Map<Long, List<TimeSeqBo<AttFileModel>>> getAttFileTimeSeqBoMap() {
        return this.attFileTimeSeqBoMap;
    }

    public Company getCompanyByDate(Long boId, LocalDate date) {
        return (Company)this.getTimeSeqVersionByDate(this.companyMap, boId, date);
    }

    public AdminOrg getAdminOrgByDate(Long boId, LocalDate date) {
        return (AdminOrg)this.getTimeSeqVersionByDate(this.adminOrgMap, boId, date);
    }

    public Position getPositionByDate(Long boId, LocalDate date) {
        return (Position)this.getTimeSeqVersionByDate(this.positionMap, boId, date);
    }

    public Job getJobByDate(Long boId, LocalDate date) {
        return (Job)this.getTimeSeqVersionByDate(this.jobMap, boId, date);
    }

    private <T extends AbstractTimeSeqVersion> T getTimeSeqVersionByDate(Map<Long, TimeSeqBo<T>> timeSeqBoMap, Long boId, LocalDate date) {
        if (WTCCollections.isEmpty(timeSeqBoMap)) {
            return null;
        }
        TimeSeqBo<T> timeSeqBo = timeSeqBoMap.get(boId);
        if (timeSeqBo == null) {
            return null;
        }
        return (T)((AbstractTimeSeqVersion)timeSeqBo.getVersionByDate(date));
    }
}

