/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtes.business.model.AttItemSpec;

public class AttItemSpecData {
    private final Map<Long, TimeSeqBo<AttItemSpec>> bid2SpecBo;
    private final Map<String, TimeSeqBo<AttItemSpec>> number2SpecBo;

    public AttItemSpecData(Map<Long, TimeSeqBo<AttItemSpec>> bid2SpecBo, Map<String, TimeSeqBo<AttItemSpec>> number2SpecBo) {
        this.bid2SpecBo = bid2SpecBo;
        this.number2SpecBo = number2SpecBo;
    }

    public static AttItemSpecData of(List<TimeSeqBo<AttItemSpec>> attItemSpecsBo) {
        HashMap<Long, TimeSeqBo<AttItemSpec>> bid2SpecBo = new HashMap<Long, TimeSeqBo<AttItemSpec>>(attItemSpecsBo.size());
        HashMap<String, TimeSeqBo<AttItemSpec>> number2SpecBo = new HashMap<String, TimeSeqBo<AttItemSpec>>(attItemSpecsBo.size());
        attItemSpecsBo.forEach(bo -> {
            bid2SpecBo.put(bo.getBid(), (TimeSeqBo<AttItemSpec>)bo);
            number2SpecBo.put(bo.getNumber(), (TimeSeqBo<AttItemSpec>)bo);
        });
        return new AttItemSpecData(bid2SpecBo, number2SpecBo);
    }

    public TimeSeqBo<AttItemSpec> getByBid(long bid) {
        return this.bid2SpecBo.getOrDefault(bid, (TimeSeqBo<AttItemSpec>)TimeSeqBo.empty());
    }

    public AttItemSpec getByBidAndDate(long bid, LocalDate inDate) {
        return (AttItemSpec)this.getByBid(bid).getVersionByDate(inDate);
    }

    public TimeSeqBo<AttItemSpec> getByNumber(String number) {
        return this.number2SpecBo.getOrDefault(number, (TimeSeqBo<AttItemSpec>)TimeSeqBo.empty());
    }

    public AttItemSpec getByNumberAndDate(String number, LocalDate inDate) {
        return (AttItemSpec)this.getByNumber(number).getVersionByDate(inDate);
    }

    public Map<Long, TimeSeqBo<AttItemSpec>> getBid2SpecBo() {
        return this.bid2SpecBo;
    }

    public List<AttItemSpec> getPeriodAttitemList() {
        ArrayList attItemSpecList = Lists.newArrayListWithExpectedSize((int)16);
        this.bid2SpecBo.forEach((bid, entry) -> {
            List attItemSpecs = entry.getVersions();
            if (WTCCollections.isEmpty((Collection)attItemSpecs)) {
                return;
            }
            String itemType = ((AttItemSpec)((Object)((Object)attItemSpecs.get(0)))).getItemType();
            if (HRStringUtils.equals((String)itemType, (String)AttItemItemType.DETAIL_ITEM.type)) {
                return;
            }
            attItemSpecList.addAll(attItemSpecs);
        });
        return attItemSpecList;
    }
}

