/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.executor.timeaffiliation.model.TimeAscriptionRule;
import kd.wtc.wtes.business.model.AttPeriodModel;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttPeriodTable {
    private Map<Long, List<PerAttPeriod>> perAttPeriodMap;
    private Map<Long, TimeSeqBo<TimeAscriptionRule>> timeAscriptionBoMap;
    private Map<Long, List<AttPeriodModel>> attPeriodMap;

    public AttPeriodTable(Map<Long, List<PerAttPeriod>> perAttPeriodMap, Map<Long, TimeSeqBo<TimeAscriptionRule>> timeAscriptionBoMap) {
        this.perAttPeriodMap = perAttPeriodMap;
        this.timeAscriptionBoMap = timeAscriptionBoMap;
    }

    public void setAttPeriodMap(Map<Long, List<AttPeriodModel>> attPeriodMap) {
        this.attPeriodMap = attPeriodMap;
    }

    public Optional<PerAttPeriod> getPerAttPeriodByAttPersonIdAndDate(long attPersonId, Date date) {
        List<PerAttPeriod> perAttPeriodList = this.perAttPeriodMap.get(attPersonId);
        if (CollectionUtils.isEmpty(perAttPeriodList)) {
            return Optional.empty();
        }
        return perAttPeriodList.stream().filter(perAttPeriod -> perAttPeriod.getPerAttBeginDate().compareTo(date) <= 0 && perAttPeriod.getPerAttEndDate().compareTo(date) >= 0).findAny();
    }

    public Optional<PerAttPeriod> getPerAttPeriodByAttPersonIdAndDate(long attPersonId, LocalDate inDate) {
        Date date = WTCDateUtils.toDate((LocalDate)inDate);
        List<PerAttPeriod> perAttPeriodList = this.perAttPeriodMap.get(attPersonId);
        if (CollectionUtils.isEmpty(perAttPeriodList)) {
            return Optional.empty();
        }
        return perAttPeriodList.stream().filter(perAttPeriod -> perAttPeriod.getPerAttBeginDate().compareTo(date) <= 0 && perAttPeriod.getPerAttEndDate().compareTo(date) >= 0).findAny();
    }

    public Optional<PerAttPeriod> getPerAttPeriod(long attPersonId, LocalDate startDate, LocalDate endDate, Long attPeriodId) {
        Date inStartDate = WTCDateUtils.toDate((LocalDate)startDate);
        Date inEndDate = WTCDateUtils.toDate((LocalDate)endDate);
        List<PerAttPeriod> perAttPeriodList = this.perAttPeriodMap.get(attPersonId);
        if (CollectionUtils.isEmpty(perAttPeriodList)) {
            return Optional.empty();
        }
        return perAttPeriodList.stream().filter(perAttPeriod -> attPeriodId.equals(perAttPeriod.getAttPeriodId()) && perAttPeriod.getPerAttBeginDate().compareTo(inEndDate) <= 0 && perAttPeriod.getPerAttEndDate().compareTo(inStartDate) >= 0).findAny();
    }

    public List<PerAttPeriod> getPerAttPeriod(long attPersonId, LocalDate startDate, LocalDate endDate) {
        Date inStartDate = WTCDateUtils.toDate((LocalDate)startDate);
        Date inEndDate = WTCDateUtils.toDate((LocalDate)endDate);
        List<PerAttPeriod> perAttPeriodList = this.perAttPeriodMap.get(attPersonId);
        if (CollectionUtils.isEmpty(perAttPeriodList)) {
            return Collections.emptyList();
        }
        return perAttPeriodList.stream().filter(perAttPeriod -> perAttPeriod.getPerAttBeginDate().compareTo(inEndDate) <= 0 && perAttPeriod.getPerAttEndDate().compareTo(inStartDate) >= 0).collect(Collectors.toList());
    }

    public TimeSeqBo<TimeAscriptionRule> getAscriptionBoByAttPersonIdAndDate(long attPersonId, LocalDate date) {
        Optional<PerAttPeriod> optionalPerAttPeriod = this.getPerAttPeriodByAttPersonIdAndDate(attPersonId, WTCDateUtils.toDate((LocalDate)date));
        if (!optionalPerAttPeriod.isPresent()) {
            return TimeSeqBo.empty();
        }
        TimeSeqBo<TimeAscriptionRule> timeAscriptionRuleTimeSeqBo = this.timeAscriptionBoMap.get(optionalPerAttPeriod.get().getMhsa());
        if (timeAscriptionRuleTimeSeqBo == null) {
            return TimeSeqBo.empty();
        }
        return timeAscriptionRuleTimeSeqBo;
    }

    public Optional<TimeAscriptionRule> getAscriptionByAttPersonIdAndDate(long attPersonId, LocalDate date) {
        Optional<PerAttPeriod> optionalPerAttPeriod = this.getPerAttPeriodByAttPersonIdAndDate(attPersonId, WTCDateUtils.toDate((LocalDate)date));
        if (!optionalPerAttPeriod.isPresent()) {
            return Optional.empty();
        }
        TimeSeqBo<TimeAscriptionRule> timeAscriptionRuleTimeSeqBo = this.timeAscriptionBoMap.get(optionalPerAttPeriod.get().getMhsa());
        if (timeAscriptionRuleTimeSeqBo == null) {
            return Optional.empty();
        }
        TimeAscriptionRule versionByDate = (TimeAscriptionRule)timeAscriptionRuleTimeSeqBo.getVersionByDate(date);
        return Optional.ofNullable(versionByDate);
    }

    public List<PerAttPeriod> getPerAttPeriodList(long attPersonId) {
        return this.perAttPeriodMap.get(attPersonId);
    }

    public List<AttPeriodModel> getAttPeriodList(long attPersonId) {
        return this.attPeriodMap.get(attPersonId);
    }

    public Map<Long, List<PerAttPeriod>> getPerAttPeriodMap() {
        return this.perAttPeriodMap;
    }

    public LocalDate getMaxAttPeriodEndDate() {
        Optional<PerAttPeriod> attPeriodMax = this.getAccountMaxAttPeriodEndDate();
        if (attPeriodMax.isPresent()) {
            return WTCDateUtils.toLocalDate((Date)attPeriodMax.get().getPerAttEndDate());
        }
        return WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxEndDate());
    }

    public Optional<PerAttPeriod> getAccountMaxAttPeriodEndDate() {
        return this.perAttPeriodMap.values().stream().map(value -> value.stream().filter(perAttPeriod -> null != perAttPeriod.getPerAttEndDate()).max(Comparator.comparing(PerAttPeriod::getPerAttEndDate))).filter(Optional::isPresent).map(Optional::get).max(Comparator.comparing(PerAttPeriod::getPerAttEndDate));
    }

    public LocalDate getMinAttPeriodBeginDate() {
        Optional<PerAttPeriod> attPeriodMin = this.getAccountMinAttPeriodBeginDate();
        if (attPeriodMin.isPresent()) {
            return WTCDateUtils.toLocalDate((Date)attPeriodMin.get().getPerAttBeginDate());
        }
        return WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinEndDate());
    }

    public Optional<PerAttPeriod> getAccountMinAttPeriodBeginDate() {
        return this.perAttPeriodMap.values().stream().map(value -> value.stream().filter(perAttPeriod -> null != perAttPeriod.getPerAttBeginDate()).min(Comparator.comparing(PerAttPeriod::getPerAttBeginDate))).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(PerAttPeriod::getPerAttBeginDate));
    }

    public Set<LocalDate> getEachPerAttBeginDate(Set<Long> personIdList, LocalDate starDate, LocalDate endDate) {
        if (CollectionUtils.isEmpty(personIdList) || starDate == null || endDate == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)personIdList.size());
        List<LocalDate> dateRange = this.getDateRange(starDate, endDate);
        for (Long personId : personIdList) {
            for (LocalDate chainDate : dateRange) {
                Date perAttBeginDate;
                Optional<PerAttPeriod> specificPer = this.getPerAttPeriodByAttPersonIdAndDate((long)personId, chainDate);
                if (!specificPer.isPresent() || (perAttBeginDate = specificPer.get().getPerAttBeginDate()) == null) continue;
                result.add(WTCDateUtils.toLocalDate((Date)specificPer.get().getPerAttBeginDate()));
            }
        }
        return result;
    }

    private List<LocalDate> getDateRange(LocalDate startLocalDate, LocalDate endLocalDate) {
        ArrayList dateRange = Lists.newArrayListWithExpectedSize((int)10);
        LocalDate lastDate = startLocalDate;
        while (!lastDate.isAfter(endLocalDate)) {
            dateRange.add(lastDate);
            lastDate = lastDate.plusDays(1L);
        }
        return dateRange;
    }

    public Optional<PerAttPeriod> getMinAttPeriodStartDate() {
        return this.perAttPeriodMap.values().stream().map(value -> value.stream().filter(perAttPeriod -> null != perAttPeriod.getAttPeriodStartDate()).min(Comparator.comparing(PerAttPeriod::getAttPeriodStartDate))).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(PerAttPeriod::getAttPeriodStartDate));
    }
}

