/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.std.datanode.TimeBucket;

public abstract class BillStateBase {
    public static final String NONE_BILL = "0";
    public static final String PARTLY_BILL = "1";
    public static final String ALL_BILL = "2";
    public static final String NONE_BILL_TEMP = "3";
    public static final String ALL_BILL_TEMP = "4";
    private String billState = "0";

    public String getBillState() {
        return this.billState;
    }

    public void setBillState(String billState) {
        this.billState = billState;
    }

    protected abstract boolean hasBillState(AttendanceBillTag var1);

    public void checkBillState(TimeBucket.Builder rawTimeBucketBuilder, boolean isEnd) {
        if (null == rawTimeBucketBuilder) {
            this.setBillStateSuperposition(isEnd);
        } else if (rawTimeBucketBuilder.getTimeBucketPosition() == TimeBucketPositionEnum.IN_SHIFT) {
            this.setBillState(isEnd, rawTimeBucketBuilder);
        } else if (isEnd) {
            this.setBillStateOutOfShiftAndEnd();
        }
    }

    private void setBillStateSuperposition(boolean isEnd) {
        switch (this.billState) {
            case "0": {
                this.billState = NONE_BILL;
                break;
            }
            case "3": {
                this.billState = isEnd ? NONE_BILL : NONE_BILL_TEMP;
                break;
            }
            case "4": {
                this.billState = isEnd ? ALL_BILL : ALL_BILL_TEMP;
            }
        }
    }

    private void setBillStateOutOfShiftAndEnd() {
        switch (this.billState) {
            case "3": {
                this.billState = NONE_BILL;
                break;
            }
            case "4": {
                this.billState = ALL_BILL;
            }
        }
    }

    private void setBillState(boolean isEnd, TimeBucket.Builder rawTimeBucketBuilder) {
        boolean hasBill = this.hasBillState(rawTimeBucketBuilder.getAttendanceBillTag());
        switch (this.billState) {
            case "0": {
                if (hasBill) {
                    this.billState = isEnd ? ALL_BILL : ALL_BILL_TEMP;
                    break;
                }
                this.billState = isEnd ? NONE_BILL : NONE_BILL_TEMP;
                break;
            }
            case "3": {
                if (hasBill) {
                    this.billState = PARTLY_BILL;
                    break;
                }
                this.billState = isEnd ? NONE_BILL : NONE_BILL_TEMP;
                break;
            }
            case "4": {
                this.billState = hasBill ? (isEnd ? ALL_BILL : ALL_BILL_TEMP) : PARTLY_BILL;
            }
        }
    }
}

