/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.wtc.wtbs.common.predata.wtbd.PreDataBizType;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.BizDataSource;
import kd.wtc.wtes.business.model.BizTypeEnum;
import kd.wtc.wtes.business.model.DasoConfData;

public class ConfigMix {
    private String country;
    private Long tbpcrelcnf;
    private Long attstsmap;
    private Long attitemmap;
    private List<BizDataSource> bizDataSourceList;

    public Long getTbpcrelcnf() {
        return this.tbpcrelcnf;
    }

    public void setTbpcrelcnf(Long tbpcrelcnf) {
        this.tbpcrelcnf = tbpcrelcnf;
    }

    public Long getAttstsmap() {
        return this.attstsmap;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setAttstsmap(Long attstsmap) {
        this.attstsmap = attstsmap;
    }

    public Long getAttitemmap() {
        return this.attitemmap;
    }

    public void setAttitemmap(Long attitemmap) {
        this.attitemmap = attitemmap;
    }

    public List<BizDataSource> getBizDataSourceList() {
        return this.bizDataSourceList;
    }

    public void setBizDataSourceList(List<BizDataSource> bizDataSourceList) {
        this.bizDataSourceList = bizDataSourceList;
    }

    public void buildBizDataSourceList(DynamicObjectCollection entryentity, Map<Long, String> dataSourceMap, DasoConfData dasoConfData) {
        ArrayList bizDataSources = Lists.newArrayList();
        for (DynamicObject dynamicObject : entryentity) {
            DynamicObject biztype = dynamicObject.getDynamicObject("biztype");
            if (biztype == null) continue;
            long bizTypeId = biztype.getLong("id");
            Long exAttrId = null;
            if (bizTypeId == PreDataBizType.PD_1040_S) {
                exAttrId = dynamicObject.getLong("exattr.id");
            } else if (bizTypeId == PreDataBizType.PD_1050_S) {
                exAttrId = dynamicObject.getLong("attendattr.id");
            }
            Long datasourceId = dynamicObject.getLong("datasource.id");
            BizDataSource bizDataSource = new BizDataSource(biztype.getString("number"), exAttrId, datasourceId, dataSourceMap.get(datasourceId), dasoConfData.getByBid(datasourceId));
            bizDataSources.add(bizDataSource);
        }
        this.setBizDataSourceList(bizDataSources);
    }

    @Deprecated
    public void buildBizDataSourceList(DynamicObjectCollection entryentity, Map<Long, String> dataSourceMap) {
        ArrayList bizDataSources = Lists.newArrayList();
        for (DynamicObject dynamicObject : entryentity) {
            DynamicObject biztype = dynamicObject.getDynamicObject("biztype");
            if (biztype == null) continue;
            long bizTypeId = biztype.getLong("id");
            Long exAttrId = null;
            if (bizTypeId == PreDataBizType.PD_1040_S) {
                exAttrId = dynamicObject.getLong("exattr.id");
            } else if (bizTypeId == PreDataBizType.PD_1050_S) {
                exAttrId = dynamicObject.getLong("attendattr.id");
            }
            Long datasourceId = dynamicObject.getLong("datasource.id");
            BizDataSource bizDataSource = new BizDataSource(biztype.getString("number"), exAttrId, datasourceId, dataSourceMap.get(datasourceId));
            bizDataSources.add(bizDataSource);
        }
        this.setBizDataSourceList(bizDataSources);
    }

    public BizDataSource getDataSource(BizTypeEnum biztype, Long exattr) {
        for (BizDataSource bizDataSource : this.bizDataSourceList) {
            if (!bizDataSource.getBiztype().equals(biztype.code) || !Objects.equals(bizDataSource.getExattr(), exattr)) continue;
            return bizDataSource;
        }
        return null;
    }

    public BizDataSource getDataSource(BizTypeEnum biztype) {
        for (BizDataSource bizDataSource : this.bizDataSourceList) {
            if (!bizDataSource.getBiztype().equals(biztype.code)) continue;
            return bizDataSource;
        }
        return null;
    }

    public BizDataSource getDataSource(Long dasoConfId) {
        for (BizDataSource bizDataSource : this.bizDataSourceList) {
            if (!bizDataSource.getDatasourceId().equals(dasoConfId)) continue;
            return bizDataSource;
        }
        return null;
    }
}

