/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.quota.model.QuotaChageDay;
import kd.wtc.wtes.business.quota.util.QTConditionsUtils;

public class EmployeeDateRecorder {
    public static final String type_comSerCount = "comSerCount";
    public static final String type_socialWork = "socialWork";
    public static final String type_companyWork = "companyWork";
    private final long employeeId;
    private final LocalDate start;
    private final LocalDate end;
    List<DatePoint> comSerCountDPListAsc;
    List<DatePoint> socialWorkDPListAsc;
    List<DatePoint> companyWorkDPListAsc;
    private final boolean fromNewAlgorithm;
    private final LocalDate oldAlgorithmUseEndDate;
    private EmployeeDateRecorder otherAlgorithmRecorder;

    public EmployeeDateRecorder getRealHolder(LocalDate date) {
        if (this.oldAlgorithmUseEndDate != null && (date.isEqual(this.oldAlgorithmUseEndDate) || date.isAfter(this.oldAlgorithmUseEndDate))) {
            if (this.fromNewAlgorithm) {
                return this;
            }
            if (this.otherAlgorithmRecorder != null && this.otherAlgorithmRecorder.fromNewAlgorithm) {
                return this.otherAlgorithmRecorder;
            }
            return null;
        }
        if (!this.fromNewAlgorithm) {
            return this;
        }
        if (this.otherAlgorithmRecorder != null && !this.otherAlgorithmRecorder.fromNewAlgorithm) {
            return this.otherAlgorithmRecorder;
        }
        return null;
    }

    public void setOtherAlgorithmRecorder(EmployeeDateRecorder otherAlgorithmRecorder) {
        this.otherAlgorithmRecorder = otherAlgorithmRecorder;
    }

    public EmployeeDateRecorder(boolean fromNewAlgorithm, LocalDate oldAlgorithmUseEndDate, long employeeId, LocalDate start, LocalDate end) {
        this.fromNewAlgorithm = fromNewAlgorithm;
        this.oldAlgorithmUseEndDate = oldAlgorithmUseEndDate;
        this.employeeId = employeeId;
        this.start = start;
        this.end = end;
    }

    public double getTypeAgeInDate(String type, Date inDate) {
        if (inDate != null) {
            long time = inDate.getTime();
            List<DatePoint> datePointList = this.judgeAndGetDPList(type);
            for (DatePoint datePoint : datePointList) {
                if (datePoint.date.getTime() > time) {
                    return datePoint.before;
                }
                if (datePoint.date.getTime() != time) continue;
                return datePoint.after;
            }
            if (WTCCollections.isNotEmpty(datePointList)) {
                return datePointList.get(datePointList.size() - 1).after;
            }
        }
        return 0.0;
    }

    public List<QuotaChageDay> computeChangeDay(String type, Date rangeStart, Date rangeEnd) {
        List<DatePoint> datePointList = this.judgeAndGetDPList(type);
        ArrayList<QuotaChageDay> res = new ArrayList<QuotaChageDay>(16);
        long start = rangeStart.getTime();
        long end = rangeEnd.getTime();
        for (DatePoint datePoint : datePointList) {
            long point = datePoint.date.getTime();
            if (point <= start || point > end) continue;
            QuotaChageDay tmp = new QuotaChageDay();
            tmp.setType(type);
            tmp.setChangeDate(datePoint.date);
            tmp.setChangeValue((int)datePoint.after);
            tmp.setOldValue(datePoint.before);
            res.add(tmp);
        }
        return res;
    }

    public long getEmployeeId() {
        return this.employeeId;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public List<DatePoint> getComSerCountDPListAsc() {
        return this.comSerCountDPListAsc;
    }

    public List<DatePoint> getSocialWorkDPListAsc() {
        return this.socialWorkDPListAsc;
    }

    public List<DatePoint> getCompanyWorkDPListAsc() {
        return this.companyWorkDPListAsc;
    }

    public void setComSerCountDPListAsc(List<DatePoint> comSerCountDPListAsc) {
        this.comSerCountDPListAsc = comSerCountDPListAsc;
    }

    public void setSocialWorkDPListAsc(List<DatePoint> socialWorkDPListAsc) {
        this.socialWorkDPListAsc = socialWorkDPListAsc;
    }

    public void setCompanyWorkDPListAsc(List<DatePoint> companyWorkDPListAsc) {
        this.companyWorkDPListAsc = companyWorkDPListAsc;
    }

    private List<DatePoint> judgeAndGetDPList(String type) {
        List<DatePoint> res = null;
        if (WTCStringUtils.equals((String)type, (String)type_comSerCount)) {
            res = this.comSerCountDPListAsc;
        } else if (WTCStringUtils.equals((String)type, (String)type_socialWork)) {
            res = this.socialWorkDPListAsc;
        } else if (WTCStringUtils.equals((String)type, (String)type_companyWork)) {
            res = this.companyWorkDPListAsc;
        }
        return res != null ? res : Collections.emptyList();
    }

    public String toString() {
        return "EmployeeDateRecorder{employeeId=" + this.employeeId + ", start=" + this.start + ", end=" + this.end + ", comSerCountDPListAsc=" + this.comSerCountDPListAsc + ", socialWorkDPListAsc=" + this.socialWorkDPListAsc + ", companyWorkDPListAsc=" + this.companyWorkDPListAsc + '}';
    }

    @Deprecated
    public EmployeeDateRecorder(long employeeId, LocalDate start, LocalDate end) {
        this(false, null, employeeId, start, end);
    }

    @Deprecated
    public static List<QuotaChageDay> calculateChangeAge(Date baseDate, Date rangeStart, Date rangeEnd, String type) {
        return QTConditionsUtils.calculateChangeAge(baseDate, rangeStart, rangeEnd, type);
    }

    public boolean isFromNewAlgorithm() {
        return this.fromNewAlgorithm;
    }

    public static class DatePoint {
        private final Date date;
        private final double before;
        private final double after;

        public DatePoint(Date date, double before, double after) {
            this.date = date;
            this.before = before;
            this.after = after;
        }

        public String toString() {
            return "DatePoint{date=" + this.date + ", before=" + this.before + ", after=" + this.after + '}';
        }

        public Date getDate() {
            return this.date;
        }

        public double getBefore() {
            return this.before;
        }

        public double getAfter() {
            return this.after;
        }
    }
}

