/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.io.Serializable;
import java.time.LocalDate;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.common.lang.WtesException;

public class Roster
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8719422855740450005L;
    private long id;
    private LocalDate rosterDate;
    private DateType dateType;
    private DateType originDateTypeModel;
    private DateAttribute dateAttribute;
    private DateAttribute orginDateAttribute;
    private String rosterType;
    private String holiday;
    private TimeSeqBo<ShiftSpec> shiftSpecTimeSeqBo;

    public Roster(LocalDate rosterDate, DateType dateType, String rosterType, String holiday, TimeSeqBo<ShiftSpec> shiftSpecTimeSeqBo) {
        this.rosterDate = rosterDate;
        this.dateType = dateType;
        this.rosterType = rosterType;
        this.holiday = holiday;
        this.shiftSpecTimeSeqBo = shiftSpecTimeSeqBo;
    }

    public Roster() {
    }

    public LocalDate getRosterDate() {
        return this.rosterDate;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public String getRosterType() {
        return this.rosterType;
    }

    public String getHoliday() {
        return this.holiday;
    }

    public TimeSeqBo<ShiftSpec> getShiftSpecTimeSeqBo() {
        return this.shiftSpecTimeSeqBo;
    }

    public long getId() {
        return this.id;
    }

    public static Builder with() {
        return new Builder(new Roster());
    }

    public static Builder withCopy(Roster roster) {
        try {
            Object clone = roster.clone();
            return new Builder((Roster)clone);
        }
        catch (CloneNotSupportedException e) {
            throw new WtesException((Throwable)e);
        }
    }

    public DateAttribute getDateAttribute() {
        return this.dateAttribute;
    }

    public void setDateAttribute(DateAttribute dateAttribute) {
        this.dateAttribute = dateAttribute;
    }

    public DateType getOriginDateTypeModel() {
        return this.originDateTypeModel;
    }

    public void setOriginDateTypeModel(DateType originDateTypeModel) {
        this.originDateTypeModel = originDateTypeModel;
    }

    public DateAttribute getOrginDateAttribute() {
        return this.orginDateAttribute;
    }

    public void setOrginDateAttribute(DateAttribute orginDateAttribute) {
        this.orginDateAttribute = orginDateAttribute;
    }

    public ShiftSpec getShiftSpec() {
        if (null == this.getRosterDate() || null == this.getShiftSpecTimeSeqBo()) {
            return null;
        }
        return (ShiftSpec)this.getShiftSpecTimeSeqBo().getVersionByDate(this.getRosterDate());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Roster{id=" + this.id + ", rosterDate=" + this.rosterDate + ", dateType=" + this.dateType + ", rosterType='" + this.rosterType + '\'' + ", holiday='" + this.holiday + '\'' + ", shiftSpecTimeSeqBo=" + this.shiftSpecTimeSeqBo + ", dateAttribute=" + this.dateAttribute + ", originDateTypeModel=" + this.originDateTypeModel + ", orginDateAttribute=" + this.orginDateAttribute + '}';
    }

    public static class Builder {
        private Roster roster;

        protected Builder(Roster roster) {
            this.roster = roster;
        }

        public Builder id(long id) {
            this.roster.id = id;
            return this;
        }

        public Builder rosterDate(LocalDate rosterDate) {
            this.roster.rosterDate = rosterDate;
            return this;
        }

        public Builder dateType(DateType dateType) {
            this.roster.dateType = dateType;
            return this;
        }

        public Builder originDateTypeModel(DateType originDateTypeModel) {
            this.roster.originDateTypeModel = originDateTypeModel;
            return this;
        }

        public Builder rosterType(String rosterType) {
            this.roster.rosterType = rosterType;
            return this;
        }

        public Builder holiday(String holiday) {
            this.roster.holiday = holiday;
            return this;
        }

        public Builder shiftSpecTimeSeqBo(TimeSeqBo<ShiftSpec> shiftSpecTimeSeqBo) {
            this.roster.shiftSpecTimeSeqBo = shiftSpecTimeSeqBo;
            return this;
        }

        public Builder dateAttribute(DateAttribute dateAttribute) {
            this.roster.dateAttribute = dateAttribute;
            return this;
        }

        public Builder orginDateAttribute(DateAttribute orginDateAttribute) {
            this.roster.orginDateAttribute = orginDateAttribute;
            return this;
        }

        public Roster build() {
            Roster tmp = this.roster;
            this.roster = null;
            return tmp;
        }
    }
}

