/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.common.enums.RefDateType;

public class ShiftSession {
    private long id;
    private RefDateType startRefDateType;
    private OutWorkType outWorkType;
    private LocalTime startTime;
    private boolean requiredPunchIn;
    private RefDateType endRefDateType;
    private LocalTime endTime;
    private boolean requiredPunchOut;
    private int durationInSeconds;

    public static Builder with() {
        return new Builder(new ShiftSession());
    }

    public long getId() {
        return this.id;
    }

    public RefDateType getStartRefDateType() {
        return this.startRefDateType;
    }

    public OutWorkType getOutWorkType() {
        return this.outWorkType;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public boolean isRequiredPunchIn() {
        return this.requiredPunchIn;
    }

    public RefDateType getEndRefDateType() {
        return this.endRefDateType;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public boolean isRequiredPunchOut() {
        return this.requiredPunchOut;
    }

    public boolean isWorkTime() {
        return OutWorkType.WORK == this.outWorkType;
    }

    public LocalDateTime getAbsoluteShiftStartDate(LocalDate checkDate) {
        return this.getAbsoluteTime(checkDate, this.startRefDateType, this.startTime);
    }

    public LocalDateTime getAbsoluteShiftEndDate(LocalDate checkDate) {
        return this.getAbsoluteTime(checkDate, this.endRefDateType, this.endTime);
    }

    private LocalDateTime getAbsoluteTime(LocalDate rankDate, RefDateType refDateType, LocalTime startDate) {
        if (rankDate == null) {
            return null;
        }
        LocalDate localDate = rankDate;
        if (refDateType == RefDateType.NEXTDAY) {
            localDate = rankDate.plusDays(1L);
        } else if (refDateType == RefDateType.LASTDAY) {
            localDate = rankDate.plusDays(-1L);
        }
        return LocalDateTime.of(localDate, startDate);
    }

    public int getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public static class Builder {
        private ShiftSession shiftSession;

        public Builder(ShiftSession shiftSession) {
            this.shiftSession = shiftSession;
        }

        public ShiftSession build() {
            ShiftSession tmp = this.shiftSession;
            this.shiftSession = null;
            return tmp;
        }

        public Builder id(long id) {
            this.shiftSession.id = id;
            return this;
        }

        public Builder startRefDateType(RefDateType startRefDateType) {
            this.shiftSession.startRefDateType = startRefDateType;
            return this;
        }

        public Builder endRefDateType(RefDateType endRefDateType) {
            this.shiftSession.endRefDateType = endRefDateType;
            return this;
        }

        public Builder startTime(LocalTime startTime) {
            this.shiftSession.startTime = startTime;
            return this;
        }

        public Builder endTime(LocalTime endTime) {
            this.shiftSession.endTime = endTime;
            return this;
        }

        public Builder requiredPunchIn(boolean requiredPunchIn) {
            this.shiftSession.requiredPunchIn = requiredPunchIn;
            return this;
        }

        public Builder requiredPunchOut(boolean requiredPunchOut) {
            this.shiftSession.requiredPunchOut = requiredPunchOut;
            return this;
        }

        public Builder outWorkType(OutWorkType outWorkType) {
            this.shiftSession.outWorkType = outWorkType;
            return this;
        }

        public Builder durationInSeconds(int durationInSeconds) {
            this.shiftSession.durationInSeconds = durationInSeconds;
            return this;
        }
    }
}

