/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;

public class ShiftTableSingle
implements Serializable {
    private static final ShiftTableSingle EMPTY = new ShiftTableSingle();
    private static final long serialVersionUID = -4829091714765506669L;
    private long attPersonId;
    private Map<LocalDate, Roster> rosterSpecMap;

    public long getAttPersonId() {
        return this.attPersonId;
    }

    public Map<LocalDate, Roster> getRosterSpecMap() {
        return this.rosterSpecMap;
    }

    public ShiftTableSingle(long attPersonId, Map<LocalDate, Roster> rosterSpecMap) {
        this.attPersonId = attPersonId;
        this.rosterSpecMap = rosterSpecMap;
    }

    public ShiftTableSingle() {
    }

    public static Builder with() {
        return new Builder(new ShiftTableSingle());
    }

    public ShiftSpec getPrevFirstNormalShiftSpec(LocalDate localDate) {
        HashMap<LocalDate, Roster> rosterSpecMapClone = new HashMap<LocalDate, Roster>(this.rosterSpecMap);
        Iterator iterator = rosterSpecMapClone.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            LocalDate key = (LocalDate)next.getKey();
            if (key.isBefore(localDate)) continue;
            iterator.remove();
        }
        while (rosterSpecMapClone.size() > 0) {
            ShiftSpec shiftSpec;
            Roster roster;
            if (!rosterSpecMapClone.containsKey(localDate = localDate.minusDays(1L)) || null == (roster = (Roster)rosterSpecMapClone.remove(localDate)) || null == roster.getShiftSpecTimeSeqBo() || null == (shiftSpec = (ShiftSpec)roster.getShiftSpecTimeSeqBo().getVersionByDate(localDate)) || shiftSpec.isOff()) continue;
            return shiftSpec;
        }
        return null;
    }

    public BigDecimal secondsToDays(ShiftSpec shiftSpec, int seconds, LocalDate inDate) {
        if (shiftSpec.isOff()) {
            return this.getPrevFirstNormalShiftSpec(inDate).secondsToDays(seconds);
        }
        return shiftSpec.secondsToDays(seconds);
    }

    public int daysToSeconds(ShiftSpec shiftSpec, BigDecimal days, LocalDate inDate) {
        if (shiftSpec.isOff()) {
            return this.getPrevFirstNormalShiftSpec(inDate).daysToSeconds(days);
        }
        return shiftSpec.daysToSeconds(days);
    }

    public DateAttribute getDateAttribute(LocalDate localDate) {
        Roster roster = this.rosterSpecMap.get(localDate);
        if (null == roster) {
            return null;
        }
        return roster.getDateAttribute();
    }

    public DateType getDateType(LocalDate localDate) {
        Roster roster = this.rosterSpecMap.get(localDate);
        if (null == roster) {
            return null;
        }
        return roster.getDateType();
    }

    public ShiftSpec getShiftSpec(LocalDate localDate) {
        Roster roster = this.rosterSpecMap.get(localDate);
        if (null == roster) {
            return null;
        }
        TimeSeqBo<ShiftSpec> shiftSpecTimeSeqBo = roster.getShiftSpecTimeSeqBo();
        if (null == shiftSpecTimeSeqBo) {
            return null;
        }
        return (ShiftSpec)shiftSpecTimeSeqBo.getVersionByDate(localDate);
    }

    public Roster getRoster(LocalDate localDate) {
        return this.rosterSpecMap.get(localDate);
    }

    public static ShiftTableSingle empty() {
        return EMPTY;
    }

    public String toString() {
        return "ShiftTableSingle{attPersonId=" + this.attPersonId + ", rosterSpecMap=" + this.rosterSpecMap + '}';
    }

    public static class Builder {
        private ShiftTableSingle shiftTableSingle;

        protected Builder(ShiftTableSingle shiftTableSingle) {
            this.shiftTableSingle = shiftTableSingle;
        }

        public Builder attPersonId(long attPersonId) {
            this.shiftTableSingle.attPersonId = attPersonId;
            return this;
        }

        public Builder rosterSpecMap(Map<LocalDate, Roster> rosterSpecMap) {
            this.shiftTableSingle.rosterSpecMap = rosterSpecMap;
            return this;
        }

        public ShiftTableSingle build() {
            ShiftTableSingle tmp = this.shiftTableSingle;
            this.shiftTableSingle = null;
            return tmp;
        }
    }
}

