/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.attconfig;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.std.datanode.AttItemValueStd;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;

public class AttCustomDuration
extends AbstractTimeSeqVersion {
    private TimeSeqInfo timeSeqInfo;
    private Long attItemBid;
    private String attItemNumber;
    private List<Tuple<Long, String>> durationEntryList;
    private List<Tuple<Long, Long>> condEntryList;

    public TimeSeqInfo getTimeSeqInfo() {
        return this.timeSeqInfo;
    }

    public String getAttItemNumber() {
        return this.attItemNumber;
    }

    public Long getAttItemBid() {
        return this.attItemBid;
    }

    public List<Tuple<Long, String>> getDurationEntryList() {
        return this.durationEntryList;
    }

    public List<Tuple<Long, Long>> getCondEntryList() {
        return this.condEntryList;
    }

    public BigDecimal getSeconds(Map<Long, BigDecimal> dataMap) {
        BigDecimal dataSeconds;
        BigDecimal seconds = BigDecimal.ZERO;
        HashSet excludeAttItemIdSet = Sets.newHashSetWithExpectedSize((int)this.condEntryList.size());
        for (Tuple<Long, Long> tuple : this.condEntryList) {
            dataSeconds = dataMap.get(tuple.item1);
            if (dataSeconds == null || dataSeconds.compareTo(BigDecimal.ZERO) <= 0) continue;
            excludeAttItemIdSet.add(tuple.item2);
        }
        for (Tuple tuple : this.durationEntryList) {
            if (excludeAttItemIdSet.contains(tuple.item1) || (dataSeconds = dataMap.get(tuple.item1)) == null) continue;
            if ("0".equals(tuple.item2)) {
                seconds = seconds.add(dataSeconds);
                continue;
            }
            if (!"1".equals(tuple.item2)) continue;
            seconds = seconds.subtract(dataSeconds);
        }
        return seconds;
    }

    public BigDecimal getTimes(Map<Long, BigDecimal> timeDataMap) {
        BigDecimal result = BigDecimal.ZERO;
        HashSet excludeAttItemIdSet = Sets.newHashSetWithExpectedSize((int)this.condEntryList.size());
        for (Tuple<Long, Long> tuple : this.condEntryList) {
            BigDecimal times = timeDataMap.get(tuple.item1);
            if (times == null || times.compareTo(BigDecimal.ZERO) <= 0) continue;
            excludeAttItemIdSet.add(tuple.item2);
        }
        for (Tuple tuple : this.durationEntryList) {
            BigDecimal time;
            if (excludeAttItemIdSet.contains(tuple.item1) || (time = timeDataMap.get(tuple.item1)) == null) continue;
            if ("0".equals(tuple.item2)) {
                result = result.add(time);
                continue;
            }
            if (!"1".equals(tuple.item2)) continue;
            result = result.subtract(time);
        }
        return result;
    }

    public List<TieDataNodeStd> filterAttItems(List<TieDataNodeStd> attItemNodes) {
        Set calAttItemIdSet = this.durationEntryList.stream().map(tuple -> (Long)tuple.item1).collect(Collectors.toSet());
        LinkedList parentNodes = Lists.newLinkedList();
        for (TieDataNodeStd attItemNode : attItemNodes) {
            TieDataNodeStd itemNode;
            if (attItemNode instanceof TimeBucketStd) {
                itemNode = (TimeBucketStd)attItemNode;
                if (itemNode.getAttItemInstances() == null || !itemNode.getAttItemInstances().stream().anyMatch(attIns -> calAttItemIdSet.contains(attIns.getAttItemSpec().getBid()))) continue;
                parentNodes.add(attItemNode);
                continue;
            }
            if (!(attItemNode instanceof AttItemValueStd) || !calAttItemIdSet.contains(((AttItemValueStd)(itemNode = (AttItemValueStd)attItemNode)).getAttItemInstance().getAttItemSpec().getBid())) continue;
            parentNodes.add(itemNode);
        }
        return parentNodes;
    }

    private AttCustomDuration() {
    }

    public static Builder create() {
        return new Builder(new AttCustomDuration());
    }

    public static class Builder {
        private AttCustomDuration attCustomDuration;

        protected Builder(AttCustomDuration attCustomDuration) {
            this.attCustomDuration = attCustomDuration;
        }

        public Builder setTimeSeqInfo(TimeSeqInfo timeSeqInfo) {
            this.attCustomDuration.timeSeqInfo = timeSeqInfo;
            return this;
        }

        public Builder setDurationEntryList(List<Tuple<Long, String>> durationEntryList) {
            this.attCustomDuration.durationEntryList = durationEntryList;
            return this;
        }

        public Builder setCondEntryList(List<Tuple<Long, Long>> condEntryList) {
            this.attCustomDuration.condEntryList = condEntryList;
            return this;
        }

        public Builder setAttItemNumber(String attItemNumber) {
            this.attCustomDuration.attItemNumber = attItemNumber;
            return this;
        }

        public Builder setAttItemBid(Long attItemBid) {
            this.attCustomDuration.attItemBid = attItemBid;
            return this;
        }

        public AttCustomDuration build() {
            AttCustomDuration tmp = this.attCustomDuration;
            this.attCustomDuration = null;
            return tmp;
        }
    }
}

