/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.attendperson;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtbs.common.model.AbstractExtendableObj;
import kd.wtc.wtbs.business.model.attendperson.AttendPerson;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonHisResult;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.EmpEntRel;
import kd.wtc.wtbs.business.model.attendperson.EmpJobRel;
import kd.wtc.wtbs.business.model.attendperson.EmpPosOrgRel;
import kd.wtc.wtbs.business.model.attendperson.Employee;
import kd.wtc.wtbs.business.model.attendperson.PerTsProp;
import kd.wtc.wtbs.business.model.attendperson.Person;
import kd.wtc.wtbs.business.model.attendperson.TrialPeriod;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EmployeeDateRecorder;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttendPersonData
extends AbstractExtendableObj {
    private static final Log LOGGER = LogFactory.getLog(AttendPersonData.class);
    private Map<Long, AttendPerson> bid2AttendPersonMap;
    private Map<Long, EmployeeDateRecorder> dateRecorderMap;

    @Deprecated
    public EmployeeDateRecorder getEmployeeDateRecorder(Long employeeId) {
        return this.dateRecorderMap != null ? this.dateRecorderMap.get(employeeId) : null;
    }

    public EmployeeDateRecorder getEmployeeDateRecorder(Long employeeId, LocalDate date) {
        EmployeeDateRecorder recorder;
        if (this.dateRecorderMap != null && (recorder = this.dateRecorderMap.get(employeeId)) != null) {
            EmployeeDateRecorder result = recorder.getRealHolder(date);
            LOGGER.info("result \u4eba\u5458IDemployeeId= {},\u662f\u5426\u4f7f\u7528\u65b0\u7b97\u6cd5fromNewAlgorithm= {},\u4f20\u5165\u65e5\u671fdate={}", new Object[]{employeeId, recorder.isFromNewAlgorithm(), date});
            return result;
        }
        return null;
    }

    public void setDateRecorderMap(Map<Long, EmployeeDateRecorder> dateRecorderMap) {
        this.dateRecorderMap = dateRecorderMap;
    }

    public Map<Long, EmployeeDateRecorder> getDateRecorderMap() {
        return this.dateRecorderMap;
    }

    protected AttendPersonData() {
    }

    public static AttendPersonData of(AttendPersonHisResult attendPersonHisResult) {
        AttendPersonData attRecordAdjustData = new AttendPersonData();
        if (attendPersonHisResult == null) {
            return attRecordAdjustData;
        }
        List attendPersonList = attendPersonHisResult.getAttendPeople();
        HashMap<Long, AttendPerson> bid2AttendPersonMap = new HashMap<Long, AttendPerson>(16);
        attendPersonList.forEach(ob -> {
            Person person = ob.getPerson();
            if (person != null) {
                bid2AttendPersonMap.put(person.getBid(), (AttendPerson)ob);
            }
        });
        attRecordAdjustData.bid2AttendPersonMap = bid2AttendPersonMap;
        return attRecordAdjustData;
    }

    public AttendPersonModel getByBidAndDate(AttFileModel attFileModel, LocalDate inDate) {
        AttendPerson attendPerson = this.bid2AttendPersonMap.get(attFileModel.getAttPersonId());
        if (attendPerson != null) {
            AttendPersonModel attendPersonModel = new AttendPersonModel();
            attendPersonModel.setPerson(attendPerson.getPerson());
            attendPersonModel.setPerNonTsProp(attendPerson.getPerNonTsProp());
            attendPersonModel.setFertilityInfo(attendPerson.getFertilityInfo(inDate));
            attendPersonModel.setPerTsProp(this.getPertsPropByDate(attendPerson, inDate));
            Employee employee = this.getEmployeeByDate(attFileModel, attendPerson, inDate);
            attendPersonModel.setEmployee(employee);
            if (null != employee) {
                attendPersonModel.setEmpEntRel(this.getEmpEntRelByDate(employee, inDate));
                attendPersonModel.setEmpJobRel(this.getEmpJobRelByDate(employee, inDate));
                attendPersonModel.setTrialPeriod(this.getTrialPeriod(employee));
                attendPersonModel.setContrWorkLoc(this.getContrWorkLocByDate(employee, inDate));
            }
            attendPersonModel.setCmpEmp(this.getCmpEmpByDate(attFileModel, attendPerson, inDate));
            attendPersonModel.setEmpPosOrgRel(this.getEmpPosOrgRelByDate(attFileModel, attendPerson, inDate));
            return attendPersonModel;
        }
        return null;
    }

    private CmpEmp getCmpEmpByDate(AttFileModel attFileModel, AttendPerson attendPerson, LocalDate inDate) {
        Map cmpEmpMap = attendPerson.getCmpEmpMap();
        if (WTCCollections.isEmpty((Map)cmpEmpMap)) {
            return null;
        }
        TimeSeqBo cmpEmpTimeSeqBo = (TimeSeqBo)cmpEmpMap.get(attFileModel.getCmpempId());
        if (null == cmpEmpTimeSeqBo) {
            return null;
        }
        return (CmpEmp)cmpEmpTimeSeqBo.getVersionByDate(inDate);
    }

    private EmpPosOrgRel getEmpPosOrgRelByDate(AttFileModel attFileModel, AttendPerson attendPerson, LocalDate inDate) {
        Map empPosOrgRelMap = attendPerson.getEmpPosOrgRelMap();
        if (CollectionUtils.isEmpty((Map)empPosOrgRelMap)) {
            return null;
        }
        Map empPosOrgSeqBoMap = (Map)empPosOrgRelMap.get(attFileModel.getCmpempId());
        if (WTCCollections.isEmpty((Map)empPosOrgSeqBoMap)) {
            return null;
        }
        TimeSeqBo empPosOrgRelSeqBo = (TimeSeqBo)empPosOrgSeqBoMap.get(attFileModel.getEmpposorgrelId());
        if (null == empPosOrgRelSeqBo) {
            return null;
        }
        return (EmpPosOrgRel)empPosOrgRelSeqBo.getVersionByDate(inDate);
    }

    private PerTsProp getPertsPropByDate(AttendPerson attendPerson, LocalDate inDate) {
        TimeSeqBo perTsProp = attendPerson.getPerTsPropList();
        Optional<PerTsProp> optional = Optional.ofNullable(perTsProp).map(uu -> (PerTsProp)uu.getVersionByDate(inDate));
        return optional.orElse(null);
    }

    private Employee getEmployeeByDate(AttFileModel attFileModel, AttendPerson attendPerson, LocalDate inDate) {
        return attendPerson.getEmployee(attFileModel.getEmployeeId().longValue(), inDate);
    }

    private EmpEntRel getEmpEntRelByDate(Employee employee, LocalDate inDate) {
        return employee.getEmpEntRel(inDate, Long.valueOf(0L));
    }

    private EmpJobRel getEmpJobRelByDate(Employee employee, LocalDate inDate) {
        return employee.getEmpJobRel(inDate, Long.valueOf(0L));
    }

    private TrialPeriod getTrialPeriodByDate(Employee employee, LocalDate inDate) {
        return employee.getTrialPeriod(inDate, Long.valueOf(0L));
    }

    private TrialPeriod getTrialPeriod(Employee employee) {
        return employee.getTrialPeriod();
    }

    private ContrWorkLoc getContrWorkLocByDate(Employee employee, LocalDate inDate) {
        return employee.getContrWorkLoc(inDate, Long.valueOf(0L));
    }

    public Map<Long, AttendPerson> getBid2AttendPersonMap() {
        return this.bid2AttendPersonMap;
    }
}

