/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.attrecordadjust;

import java.time.LocalDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.common.lang.NotNull;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttRecordAdjustData {
    private Map<LocalDate, Map<Long, List<AttRecordAdjust>>> resetRecord;
    private Map<LocalDate, Map<Long, List<AttRecordAdjust>>> besideResetRecord;

    private AttRecordAdjustData() {
    }

    public static AttRecordAdjustData of(List<AttRecordAdjust> btbs) {
        List orderBtbs = btbs.stream().sorted(Comparator.comparing(AttRecordAdjust::getCreateTime)).collect(Collectors.toList());
        AttRecordAdjustData attRecordAdjustData = new AttRecordAdjustData();
        HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>> resetRecord = new HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>>(btbs.size());
        HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>> besideResetRecord = new HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>>(16);
        for (AttRecordAdjust btb : orderBtbs) {
            HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>> adjustRecord = StringUtils.equals((CharSequence)btb.getTrimType(), (CharSequence)"reset") ? resetRecord : besideResetRecord;
            Map date2Btbs = adjustRecord.computeIfAbsent(btb.getCalculateDate(), key -> new HashMap(16));
            List btbList = date2Btbs.computeIfAbsent(btb.getAttfileId(), key -> new LinkedList());
            btbList.add(btb);
        }
        attRecordAdjustData.resetRecord = resetRecord;
        attRecordAdjustData.besideResetRecord = besideResetRecord;
        return attRecordAdjustData;
    }

    @NotNull
    public List<AttRecordAdjust> getResetRecords(long attfileId, LocalDate inDate) {
        Map<Long, List<AttRecordAdjust>> date2Btbs = this.resetRecord.get(inDate);
        if (CollectionUtils.isEmpty(date2Btbs)) {
            return Collections.emptyList();
        }
        return date2Btbs.getOrDefault(attfileId, Collections.emptyList());
    }

    @NotNull
    public List<AttRecordAdjust> getBesideResetRecords(long attfileId, LocalDate inDate) {
        Map<Long, List<AttRecordAdjust>> date2Btbs = this.besideResetRecord.get(inDate);
        if (CollectionUtils.isEmpty(date2Btbs)) {
            return Collections.emptyList();
        }
        return date2Btbs.getOrDefault(attfileId, Collections.emptyList());
    }

    public Map<LocalDate, Map<Long, List<AttRecordAdjust>>> getResetRecord() {
        return this.resetRecord;
    }

    public Map<LocalDate, Map<Long, List<AttRecordAdjust>>> getBesideResetRecord() {
        return this.besideResetRecord;
    }
}

