/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlex;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.rlex.ExConfigEntry;
import kd.wtc.wtes.common.lang.WtesException;

public class ExConfig
extends AbstractTimeSeqVersion {
    private static final long serialVersionUID = 4872919376397828727L;
    private static final Log LOG = LogFactory.getLog(ExConfig.class);
    private TimeSeqInfo timeSeqEntity;
    private Long exTypeId;
    private Long periodFilter;
    private boolean isCustom;
    private String conditions;
    private boolean isAllPunchCard;
    private boolean isFlexAttendance;
    private boolean isOff;
    private List<ExConfigEntry> entryList;
    private transient RuleConditionInfo conditionInfo;

    public String getConditions() {
        return this.conditions;
    }

    public List<ExConfigEntry> getEntryList() {
        return this.entryList;
    }

    public Long getExTypeId() {
        return this.exTypeId;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public Long getPeriodFilter() {
        return this.periodFilter;
    }

    public boolean isAllPunchCard() {
        return this.isAllPunchCard;
    }

    public boolean isFlexAttendance() {
        return this.isFlexAttendance;
    }

    public boolean isOff() {
        return this.isOff;
    }

    public RuleConditionInfo getConditionInfo() {
        return this.conditionInfo;
    }

    public TimeSeqInfo getTimeSeqInfo() {
        return this.timeSeqEntity;
    }

    public ExConfig(long id, String number, TimeSeqInfo timeSeqEntity) {
        super(id, number);
        this.timeSeqEntity = timeSeqEntity;
    }

    public static final class ExConfigBuilder {
        private TimeSeqInfo timeSeqEntity;
        private Long id;
        private String number;
        private Long exTypeId;
        private boolean isCustom;
        private String conditions;
        private boolean isAllPunchCard;
        private boolean isFlexAttendance;
        private boolean isOff;
        private List<ExConfigEntry> entryList;
        private Long periodFilter;
        private transient RuleConditionInfo conditionInfo;

        private ExConfigBuilder() {
        }

        public static ExConfigBuilder newEmp() {
            return new ExConfigBuilder();
        }

        public ExConfigBuilder timeSeqEntity(TimeSeqInfo timeSeqEntity) {
            this.timeSeqEntity = timeSeqEntity;
            return this;
        }

        public ExConfigBuilder exTypeId(Long exTypeId) {
            this.exTypeId = exTypeId;
            return this;
        }

        public ExConfigBuilder periodFilter(Long periodFilter) {
            this.periodFilter = periodFilter;
            return this;
        }

        public ExConfigBuilder isCustom(boolean isCustom) {
            this.isCustom = isCustom;
            return this;
        }

        public ExConfigBuilder isAllPunchCard(boolean isAllPunchCard) {
            this.isAllPunchCard = isAllPunchCard;
            return this;
        }

        public ExConfigBuilder isFlexAttendance(boolean isFlexAttendance) {
            this.isFlexAttendance = isFlexAttendance;
            return this;
        }

        public ExConfigBuilder isOff(boolean isOff) {
            this.isOff = isOff;
            return this;
        }

        public ExConfigBuilder conditions(String conditions) {
            this.conditions = conditions;
            if (HRStringUtils.isNotEmpty((String)conditions)) {
                try {
                    this.conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
                }
                catch (Exception e) {
                    LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                    throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
                }
            }
            return this;
        }

        public ExConfigBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ExConfigBuilder number(String number) {
            this.number = number;
            return this;
        }

        public ExConfigBuilder entryList(List<ExConfigEntry> entryList) {
            this.entryList = entryList;
            return this;
        }

        public ExConfig build() {
            ExConfig exConfigEntryPackage = new ExConfig(this.id, this.number, this.timeSeqEntity);
            exConfigEntryPackage.timeSeqEntity = this.timeSeqEntity;
            exConfigEntryPackage.exTypeId = this.exTypeId;
            exConfigEntryPackage.isCustom = this.isCustom;
            exConfigEntryPackage.isAllPunchCard = this.isAllPunchCard;
            exConfigEntryPackage.isFlexAttendance = this.isFlexAttendance;
            exConfigEntryPackage.isOff = this.isOff;
            exConfigEntryPackage.conditions = this.conditions;
            exConfigEntryPackage.entryList = this.entryList;
            exConfigEntryPackage.periodFilter = this.periodFilter;
            exConfigEntryPackage.conditionInfo = this.conditionInfo;
            return exConfigEntryPackage;
        }
    }
}

