/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlexenum;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.lang.WTCBizException;

public enum DurationUnitEnum {
    UNIT_SECOND(new MultiLangEnumBridge("\u79d2", "DurationUnitEnum_0", "wtc-wtes-business"), "second", 1),
    UNIT_MINUTE(new MultiLangEnumBridge("\u5206\u949f", "DurationUnitEnum_1", "wtc-wtes-business"), "minute", 60),
    UNIT_HOUR(new MultiLangEnumBridge("\u5c0f\u65f6", "DurationUnitEnum_2", "wtc-wtes-business"), "hour", 3600),
    UNIT_DAY(new MultiLangEnumBridge("\u5929", "DurationUnitEnum_4", "wtc-wtes-business"), "day", 3600),
    UNIT_ERROR(new MultiLangEnumBridge("\u6ca1\u5339\u914d\u7684\u5355\u4f4d", "DurationUnitEnum_3", "wtc-wtes-business"), "error", 0);

    private static final Log logger;
    private MultiLangEnumBridge desc;
    private final String code;
    private final Integer number;

    private DurationUnitEnum(MultiLangEnumBridge desc, String code, Integer number) {
        this.desc = desc;
        this.code = code;
        this.number = number;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public String getCode() {
        return this.code;
    }

    public Integer getNumber() {
        return this.number;
    }

    public static DurationUnitEnum getByCode(String code) {
        for (DurationUnitEnum value : DurationUnitEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        logger.warn(code + ":" + UNIT_ERROR.getDesc());
        throw new WTCBizException(UNIT_ERROR.getDesc());
    }

    public static BigDecimal changeValueToSecond(String code, BigDecimal value) {
        if (null == value) {
            return null;
        }
        DurationUnitEnum unitEnum = DurationUnitEnum.getByCode(code);
        if (unitEnum == UNIT_ERROR) {
            return null;
        }
        return value.multiply(new BigDecimal(unitEnum.number));
    }

    public static BigDecimal changeSecondsToUnit(String code, BigDecimal value) {
        if (null == value) {
            return null;
        }
        DurationUnitEnum unitEnum = DurationUnitEnum.getByCode(code);
        if (unitEnum == UNIT_ERROR) {
            return null;
        }
        return value.divide(new BigDecimal(unitEnum.number), 10, RoundingMode.HALF_UP);
    }

    static {
        logger = LogFactory.getLog(DurationUnitEnum.class);
    }
}

