/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlid;

import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.Entity;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.rlid.IncrDecrConfEntry;
import kd.wtc.wtes.business.model.rltl.TravelEntry;
import kd.wtc.wtes.common.lang.WtesException;

public class IncrDecrConf
extends Entity
implements TimeSeqVersion,
Serializable {
    private static final Log LOG = LogFactory.getLog(TravelEntry.class);
    private static final long serialVersionUID = -8426755681332942292L;
    private TimeSeqInfoImpl timeSeqEntity;
    private String suitType;
    private String triggerMode;
    private String condition;
    private transient AccessDto dateConditionAccessDto;
    private List<IncrDecrConfEntry> entry;

    public TimeSeqInfoImpl getTimeSeqInfo() {
        return this.timeSeqEntity;
    }

    protected IncrDecrConf(long id, String number, TimeSeqInfoImpl timeSeqEntity) {
        super(id, number);
        this.timeSeqEntity = timeSeqEntity;
    }

    public static Builder withTimeSeq(long id, String number, TimeSeqInfoImpl timeSeqEntity) {
        return new Builder(new IncrDecrConf(id, number, timeSeqEntity));
    }

    public static Builder withUnTimeSeq(long id, String number) {
        return new Builder(new IncrDecrConf(id, number, null));
    }

    public AccessDto getDateConditionAccessDto() {
        return this.dateConditionAccessDto;
    }

    public String getTriggerMode() {
        return this.triggerMode;
    }

    public String getCondition() {
        return this.condition;
    }

    public TimeSeqInfoImpl getTimeSeqEntity() {
        return this.timeSeqEntity;
    }

    public String getSuitType() {
        return this.suitType;
    }

    public List<IncrDecrConfEntry> getEntry() {
        return this.entry;
    }

    public String toString() {
        StringBuilder ruleConfigBuilder = new StringBuilder();
        return "IncrDecrConf{, triggerMode='" + this.triggerMode + '\'' + ", ruleConfig=" + ruleConfigBuilder + ", id=" + this.id + ", number='" + this.number + '\'' + '}';
    }

    public static class Builder {
        private IncrDecrConf incrDecrConf;

        protected Builder(IncrDecrConf incrDecrConf) {
            this.incrDecrConf = incrDecrConf;
        }

        public IncrDecrConf build() {
            IncrDecrConf tmp = this.incrDecrConf;
            this.incrDecrConf = null;
            return tmp;
        }

        public Builder triggerMode(String triggerMode) {
            this.incrDecrConf.triggerMode = triggerMode;
            return this;
        }

        public Builder condition(String condition) {
            this.incrDecrConf.condition = condition;
            if (HRStringUtils.isNotEmpty((String)condition)) {
                try {
                    this.incrDecrConf.dateConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
                }
                catch (Exception e) {
                    LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                    throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
                }
            }
            return this;
        }

        public Builder suitType(String suitType) {
            this.incrDecrConf.suitType = suitType;
            return this;
        }

        public Builder entry(List<IncrDecrConfEntry> entry) {
            this.incrDecrConf.entry = entry;
            return this;
        }
    }
}

