/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlqt;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.rlex.ExConfig;
import kd.wtc.wtes.business.model.rlqt.QTQualification;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTRoundPriorityEnum;
import kd.wtc.wtes.common.lang.WtesException;

public class QTGenConfigEntry
implements Serializable {
    private static final long serialVersionUID = -3546206226958819884L;
    private static final Log LOG = LogFactory.getLog(ExConfig.class);
    Map<String, String> replaceMap = Maps.newHashMapWithExpectedSize((int)16);
    private long entryBoId;
    private BigDecimal value;
    private long roundRule;
    private long resultAttItem;
    private String conditionFilter;
    private String replaceCondition;
    private RuleConditionInfo ruleConditionInfo;
    private RuleConditionInfo replaceConditionInfo;
    private BigDecimal percent;
    private QTRoundPriorityEnum roundPriority;
    private long attItem;
    private long maxAttItem;
    private long enjoyAttItem;
    private long usableAttItem;
    private TimeSeqAvailableBo<QTQualification> qtQualification;

    public QTGenConfigEntry() {
        this.replaceMap.put("\"CT_1300_S.hrpi_pernontsprop.entservicelen\"", "\"companyage\"");
        this.replaceMap.put("\"CT_1300_S.hrpi_pernontsprop.age\"", "\"age\"");
        this.replaceMap.put("\"CT_1300_S.hrpi_pernontsprop.servicelen\"", "\"workage\"");
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public QTGenConfigEntry setValue(BigDecimal value) {
        this.value = value;
        return this;
    }

    public long getRoundRule() {
        return this.roundRule;
    }

    public QTGenConfigEntry setRoundRule(long roundRule) {
        this.roundRule = roundRule;
        return this;
    }

    public long getResultAttItem() {
        return this.resultAttItem;
    }

    public QTGenConfigEntry setResultAttItem(long resultAttItem) {
        this.resultAttItem = resultAttItem;
        return this;
    }

    public String getConditionFilter() {
        return this.conditionFilter == null ? "" : this.conditionFilter;
    }

    public QTGenConfigEntry setConditionFilter(String conditionFilter) {
        this.conditionFilter = conditionFilter;
        this.replaceCondition = conditionFilter;
        if (HRStringUtils.isNotEmpty((String)conditionFilter)) {
            try {
                this.ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionFilter, RuleConditionInfo.class);
                for (Map.Entry<String, String> entry : this.replaceMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    this.replaceCondition = this.replaceCondition.replaceAll(key, value);
                }
                this.replaceConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)this.replaceCondition, RuleConditionInfo.class);
            }
            catch (Exception e) {
                LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return this;
    }

    public BigDecimal getPercent() {
        return this.percent;
    }

    public QTGenConfigEntry setPercent(BigDecimal percent) {
        this.percent = percent;
        return this;
    }

    public String getReplaceCondition() {
        return this.replaceCondition;
    }

    public RuleConditionInfo getReplaceConditionInfo() {
        return this.replaceConditionInfo;
    }

    public QTRoundPriorityEnum getRoundPriority() {
        return this.roundPriority;
    }

    public QTGenConfigEntry setRoundPriority(QTRoundPriorityEnum roundPriority) {
        this.roundPriority = roundPriority;
        return this;
    }

    public long getAttItem() {
        return this.attItem;
    }

    public QTGenConfigEntry setAttItem(long attItem) {
        this.attItem = attItem;
        return this;
    }

    public long getMaxAttItem() {
        return this.maxAttItem;
    }

    public QTGenConfigEntry setMaxAttItem(long maxAttItem) {
        this.maxAttItem = maxAttItem;
        return this;
    }

    public long getEnjoyAttItem() {
        return this.enjoyAttItem;
    }

    public void setEnjoyAttItem(long enjoyAttItem) {
        this.enjoyAttItem = enjoyAttItem;
    }

    public long getUsableAttItem() {
        return this.usableAttItem;
    }

    public void setUsableAttItem(long usableAttItem) {
        this.usableAttItem = usableAttItem;
    }

    public RuleConditionInfo getRuleConditionInfo() {
        return this.ruleConditionInfo;
    }

    public long getEntryBoId() {
        return this.entryBoId;
    }

    public void setEntryBoId(long entryBoId) {
        this.entryBoId = entryBoId;
    }

    public TimeSeqAvailableBo<QTQualification> getQtQualification() {
        return this.qtQualification;
    }

    public QTGenConfigEntry setQtQualification(TimeSeqAvailableBo<QTQualification> qtQualification) {
        this.qtQualification = qtQualification;
        return this;
    }
}

